/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api;

import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BackgroundExecutor {
    private static final String TAG = "BackgroundExecutor";
    public static final Executor DEFAULT_EXECUTOR;
    private static Executor executor;
    public static final WrongThreadListener DEFAULT_WRONG_THREAD_LISTENER;
    private static WrongThreadListener wrongThreadListener;
    private static final List<Task> TASKS;
    private static final ThreadLocal<String> CURRENT_SERIAL;

    private BackgroundExecutor() {
    }

    private static Future<?> directExecute(Runnable runnable, long delay) {
        Future<?> future = null;
        if (delay > 0L) {
            if (!(executor instanceof ScheduledExecutorService)) {
                throw new IllegalArgumentException("The executor set does not support scheduling");
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor;
            future = scheduledExecutorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        } else if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            future = executorService.submit(runnable);
        } else {
            executor.execute(runnable);
        }
        return future;
    }

    public static synchronized void execute(Task task) {
        if (task.id != null || task.serial != null) {
            TASKS.add(task);
        }
        if (task.serial == null || !BackgroundExecutor.hasSerialRunning(task.serial)) {
            task.executionAsked = true;
            task.future = BackgroundExecutor.directExecute(task, task.remainingDelay);
        }
    }

    public static void execute(final Runnable runnable, String id, long delay, String serial) {
        BackgroundExecutor.execute(new Task(id, delay, serial){

            @Override
            public void execute() {
                runnable.run();
            }
        });
    }

    public static void execute(Runnable runnable, long delay) {
        BackgroundExecutor.directExecute(runnable, delay);
    }

    public static void execute(Runnable runnable) {
        BackgroundExecutor.directExecute(runnable, 0L);
    }

    public static void execute(Runnable runnable, String id, String serial) {
        BackgroundExecutor.execute(runnable, id, 0L, serial);
    }

    public static void setExecutor(Executor executor) {
        BackgroundExecutor.executor = executor;
    }

    public static void setWrongThreadListener(WrongThreadListener listener) {
        wrongThreadListener = listener;
    }

    public static synchronized void cancelAll(String id, boolean mayInterruptIfRunning) {
        for (int i = TASKS.size() - 1; i >= 0; --i) {
            Task task = TASKS.get(i);
            if (!id.equals(task.id)) continue;
            if (task.future != null) {
                task.future.cancel(mayInterruptIfRunning);
                if (task.managed.getAndSet(true)) continue;
                task.postExecute();
                continue;
            }
            if (task.executionAsked) {
                Log.w((String)TAG, (String)("A task with id " + task.id + " cannot be cancelled (the executor set does not support it)"));
                continue;
            }
            TASKS.remove(i);
        }
    }

    public static void checkUiThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            wrongThreadListener.onUiExpected();
        }
    }

    public static void checkBgThread(String ... serials) {
        if (serials.length == 0) {
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                wrongThreadListener.onBgExpected(serials);
            }
            return;
        }
        String current = CURRENT_SERIAL.get();
        if (current == null) {
            wrongThreadListener.onWrongBgSerial(null, serials);
            return;
        }
        for (String serial : serials) {
            if (!serial.equals(current)) continue;
            return;
        }
        wrongThreadListener.onWrongBgSerial(current, serials);
    }

    private static boolean hasSerialRunning(String serial) {
        for (Task task : TASKS) {
            if (!task.executionAsked || !serial.equals(task.serial)) continue;
            return true;
        }
        return false;
    }

    private static Task take(String serial) {
        int len = TASKS.size();
        for (int i = 0; i < len; ++i) {
            if (!serial.equals(TASKS.get(i).serial)) continue;
            return TASKS.remove(i);
        }
        return null;
    }

    static {
        executor = DEFAULT_EXECUTOR = Executors.newScheduledThreadPool(2 * Runtime.getRuntime().availableProcessors());
        wrongThreadListener = DEFAULT_WRONG_THREAD_LISTENER = new WrongThreadListener(){

            @Override
            public void onUiExpected() {
                throw new IllegalStateException("Method invocation is expected from the UI thread");
            }

            @Override
            public void onBgExpected(String ... expectedSerials) {
                if (expectedSerials.length == 0) {
                    throw new IllegalStateException("Method invocation is expected from a background thread, but it was called from the UI thread");
                }
                throw new IllegalStateException("Method invocation is expected from one of serials " + Arrays.toString(expectedSerials) + ", but it was called from the UI thread");
            }

            @Override
            public void onWrongBgSerial(String currentSerial, String ... expectedSerials) {
                if (currentSerial == null) {
                    currentSerial = "anonymous";
                }
                throw new IllegalStateException("Method invocation is expected from one of serials " + Arrays.toString(expectedSerials) + ", but it was called from " + currentSerial + " serial");
            }
        };
        TASKS = new ArrayList<Task>();
        CURRENT_SERIAL = new ThreadLocal();
    }

    public static interface WrongThreadListener {
        public void onUiExpected();

        public void onBgExpected(String ... var1);

        public void onWrongBgSerial(String var1, String ... var2);
    }

    public static abstract class Task
    implements Runnable {
        private String id;
        private long remainingDelay;
        private long targetTimeMillis;
        private String serial;
        private boolean executionAsked;
        private Future<?> future;
        private AtomicBoolean managed = new AtomicBoolean();

        public Task(String id, long delay, String serial) {
            if (!"".equals(id)) {
                this.id = id;
            }
            if (delay > 0L) {
                this.remainingDelay = delay;
                this.targetTimeMillis = SystemClock.elapsedRealtime() + delay;
            }
            if (!"".equals(serial)) {
                this.serial = serial;
            }
        }

        @Override
        public void run() {
            if (this.managed.getAndSet(true)) {
                return;
            }
            try {
                CURRENT_SERIAL.set(this.serial);
                this.execute();
            }
            finally {
                this.postExecute();
            }
        }

        public abstract void execute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postExecute() {
            if (this.id == null && this.serial == null) {
                return;
            }
            CURRENT_SERIAL.set(null);
            Class<BackgroundExecutor> clazz = BackgroundExecutor.class;
            synchronized (BackgroundExecutor.class) {
                Task next;
                TASKS.remove(this);
                if (this.serial != null && (next = BackgroundExecutor.take(this.serial)) != null) {
                    if (next.remainingDelay != 0L) {
                        next.remainingDelay = Math.max(0L, next.targetTimeMillis - SystemClock.elapsedRealtime());
                    }
                    BackgroundExecutor.execute(next);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

