/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.RoboGuice;
import org.androidannotations.api.roboguice.RoboGuiceHelper;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.holder.RoboGuiceHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class RoboGuiceHandler
extends BaseAnnotationHandler<EActivityHolder> {
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public RoboGuiceHandler(ProcessingEnvironment processingEnvironment) {
        super(RoboGuice.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasEActivity(element, validatedElements, valid);
        this.validatorHelper.hasRoboGuiceJars(element, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        RoboGuiceHolder roboGuiceHolder = holder.getRoboGuiceHolder();
        holder.getGeneratedClass()._implements(this.classes().ROBO_CONTEXT);
        JFieldVar scope = roboGuiceHolder.getScopeField();
        JFieldVar scopedObjects = roboGuiceHolder.getScopedObjectsField();
        JFieldVar eventManager = roboGuiceHolder.getEventManagerField();
        roboGuiceHolder.getContentViewListenerField();
        this.listenerFields(element, holder);
        this.beforeCreateMethod(holder, scope, scopedObjects, eventManager);
        this.onRestartMethod(roboGuiceHolder, eventManager);
        this.onStartMethod(roboGuiceHolder, eventManager);
        this.onResumeMethod(roboGuiceHolder, eventManager);
        this.onPauseMethod(roboGuiceHolder, eventManager);
        this.onNewIntentMethod(roboGuiceHolder, eventManager);
        this.onStopMethod(roboGuiceHolder, eventManager);
        this.onDestroyMethod(roboGuiceHolder, eventManager);
        this.onConfigurationChangedMethod(roboGuiceHolder, eventManager);
        this.onContentChangedMethod(roboGuiceHolder, holder, scope, eventManager);
        this.onActivityResultMethod(roboGuiceHolder, eventManager);
        this.getScopedObjectMap(holder, scopedObjects);
    }

    private void listenerFields(Element element, EActivityHolder holder) {
        List<String> listenerClasses = this.extractListenerClasses(element);
        if (listenerClasses.size() > 0) {
            int i = 1;
            for (String listenerClassName : listenerClasses) {
                JClass listenerClass = this.refClass(listenerClassName);
                JFieldVar listener = holder.getGeneratedClass().field(4, listenerClass, "listener" + i + "_");
                listener.annotate(SuppressWarnings.class).param("value", "unused");
                listener.annotate(this.classes().INJECT);
                ++i;
            }
        }
    }

    private List<String> extractListenerClasses(Element activityElement) {
        List<? extends AnnotationMirror> annotationMirrors = activityElement.getAnnotationMirrors();
        String annotationName = RoboGuice.class.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue action = entry.getValue();
                List values = (List)action.getValue();
                ArrayList<String> listenerClasses = new ArrayList<String>();
                for (Object value : values) {
                    listenerClasses.add(value.toString());
                }
                return listenerClasses;
            }
        }
        return new ArrayList<String>(0);
    }

    private void beforeCreateMethod(EActivityHolder holder, JFieldVar scope, JFieldVar scopedObjects, JFieldVar eventManager) {
        JBlock body = holder.getInitBody();
        JClass keyWildCard = this.classes().KEY.narrow(this.codeModel().wildcard());
        JClass scopedHashMap = this.classes().HASH_MAP.narrow(keyWildCard, this.classes().OBJECT);
        body.assign(scopedObjects, JExpr._new(scopedHashMap));
        JVar injector = body.decl(this.classes().ROBO_INJECTOR, "injector_", this.classes().ROBO_GUICE.staticInvoke("getInjector").arg(JExpr._this()));
        body.assign(scope, JExpr.invoke((JExpression)injector, "getInstance").arg(this.classes().CONTEXT_SCOPE.dotclass()));
        body.assign(eventManager, JExpr.invoke((JExpression)injector, "getInstance").arg(this.classes().EVENT_MANAGER.dotclass()));
        body.add(injector.invoke("injectMembersWithoutViews").arg(JExpr._this()));
        this.fireEvent(eventManager, body, this.classes().ON_CREATE_EVENT, holder.getInitSavedInstanceParam());
    }

    private void onRestartMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onRestartAfterSuperBlock = holder.getOnRestartAfterSuperBlock();
        this.fireEvent(eventManager, onRestartAfterSuperBlock, this.classes().ON_RESTART_EVENT, new JExpression[0]);
    }

    private void onStartMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onStartAfterSuperBlock = holder.getOnStartAfterSuperBlock();
        this.fireEvent(eventManager, onStartAfterSuperBlock, this.classes().ON_START_EVENT, new JExpression[0]);
    }

    private void onResumeMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onResumeAfterSuperBlock = holder.getOnResumeAfterSuperBlock();
        this.fireEvent(eventManager, onResumeAfterSuperBlock, this.classes().ON_RESUME_EVENT, new JExpression[0]);
    }

    private void onPauseMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onPauseAfterSuperBlock = holder.getOnPauseAfterSuperBlock();
        this.fireEvent(eventManager, onPauseAfterSuperBlock, this.classes().ON_PAUSE_EVENT, new JExpression[0]);
    }

    private void onNewIntentMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onNewIntentAfterSuperBlock = holder.getOnNewIntentAfterSuperBlock();
        this.fireEvent(eventManager, onNewIntentAfterSuperBlock, this.classes().ON_NEW_INTENT_EVENT, new JExpression[0]);
    }

    private void onStopMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onStopBlock = new JBlock(false, false);
        JTryBlock tryBlock = onStopBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.classes().ON_STOP_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke(JExpr._super(), "onStop");
        JMethod onStop = holder.getOnStop();
        this.codeModelHelper.replaceSuperCall(onStop, onStopBlock);
    }

    private void onDestroyMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onDestroyBlock = new JBlock(false, false);
        JTryBlock tryBlock = onDestroyBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.classes().ON_DESTROY_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        JTryBlock tryInFinally = finallyBody._try();
        tryInFinally.body().add(this.classes().ROBO_GUICE.staticInvoke("destroyInjector").arg(JExpr._this()));
        tryInFinally._finally().invoke(JExpr._super(), "onDestroy");
        JMethod onDestroy = holder.getOnDestroy();
        this.codeModelHelper.replaceSuperCall(onDestroy, onDestroyBlock);
    }

    private void onConfigurationChangedMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JVar currentConfig = holder.getCurrentConfig();
        JBlock onConfigurationChangedAfterSuperBlock = holder.getOnConfigurationChangedAfterSuperBlock();
        JVar newConfig = holder.getNewConfig();
        this.fireEvent(eventManager, onConfigurationChangedAfterSuperBlock, this.classes().ON_CONFIGURATION_CHANGED_EVENT, currentConfig, newConfig);
    }

    private void onContentChangedMethod(RoboGuiceHolder holder, EActivityHolder eActivityHolder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onContentChangedAfterSuperBlock = holder.getOnContentChangedAfterSuperBlock();
        onContentChangedAfterSuperBlock.directStatement("synchronized(" + this.classes().CONTEXT_SCOPE.name() + ".class" + ")");
        JBlock synchronizedBlock = new JBlock(true, true);
        synchronizedBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = synchronizedBlock._try();
        tryBlock.body().staticInvoke(eActivityHolder.refClass(RoboGuiceHelper.class), "callInjectViews").arg(JExpr._this());
        tryBlock._finally().invoke((JExpression)scope, "exit").arg(JExpr._this());
        onContentChangedAfterSuperBlock.add(synchronizedBlock);
        this.fireEvent(eventManager, onContentChangedAfterSuperBlock, this.classes().ON_CONTENT_CHANGED_EVENT, new JExpression[0]);
    }

    private void onActivityResultMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onActivityResultAfterSuperBlock = holder.getOnActivityResultAfterSuperBlock();
        JVar requestCode = holder.getRequestCode();
        JVar resultCode = holder.getResultCode();
        JVar data = holder.getData();
        this.fireEvent(eventManager, onActivityResultAfterSuperBlock, this.classes().ON_ACTIVITY_RESULT_EVENT, requestCode, resultCode, data);
    }

    private void fireEvent(JFieldVar eventManager, JBlock body, JClass eventClass, JExpression ... eventArguments) {
        JInvocation newEvent = JExpr._new(eventClass);
        for (JExpression eventArgument : eventArguments) {
            newEvent.arg(eventArgument);
        }
        body.invoke((JExpression)eventManager, "fire").arg(newEvent);
    }

    private void getScopedObjectMap(EActivityHolder holder, JFieldVar scopedObjectMap) {
        JMethod getScopedObjectMapMethod = holder.getGeneratedClass().method(1, scopedObjectMap.type(), "getScopedObjectMap");
        getScopedObjectMapMethod.annotate(Override.class);
        getScopedObjectMapMethod.body()._return(scopedObjectMap);
    }
}

