/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.process.ProcessHolder;

public class OnActivityResultHolder {
    private EComponentHolder holder;
    private JMethod method;
    private JBlock afterSuperBlock;
    private JSwitch zwitch;
    private JVar requestCodeParam;
    private JVar dataParam;
    private JVar resultCodeParam;
    private HashMap<Integer, JBlock> caseBlocks = new HashMap();

    public OnActivityResultHolder(EComponentHolder holder) {
        this.holder = holder;
    }

    public JMethod getMethod() {
        if (this.method == null) {
            this.setOnActivityResult();
        }
        return this.method;
    }

    public JVar getRequestCodeParam() {
        if (this.requestCodeParam == null) {
            this.setOnActivityResult();
        }
        return this.requestCodeParam;
    }

    public JVar getDataParam() {
        if (this.dataParam == null) {
            this.setOnActivityResult();
        }
        return this.dataParam;
    }

    public JVar getResultCodeParam() {
        if (this.dataParam == null) {
            this.setOnActivityResult();
        }
        return this.resultCodeParam;
    }

    public JBlock getCaseBlock(int requestCode) {
        JBlock onActivityResultCaseBlock = this.caseBlocks.get(requestCode);
        if (onActivityResultCaseBlock == null) {
            onActivityResultCaseBlock = this.createCaseBlock(requestCode);
            this.caseBlocks.put(requestCode, onActivityResultCaseBlock);
        }
        return onActivityResultCaseBlock;
    }

    private JBlock createCaseBlock(int requestCode) {
        JCase onActivityResultCase = this.getSwitch()._case(JExpr.lit(requestCode));
        JBlock onActivityResultCaseBlock = onActivityResultCase.body().block();
        onActivityResultCase.body()._break();
        return onActivityResultCaseBlock;
    }

    public JSwitch getSwitch() {
        if (this.zwitch == null) {
            this.setSwitch();
        }
        return this.zwitch;
    }

    private void setSwitch() {
        this.zwitch = this.getAfterSuperBlock()._switch(this.getRequestCodeParam());
    }

    public JBlock getAfterSuperBlock() {
        if (this.afterSuperBlock == null) {
            this.setOnActivityResult();
        }
        return this.afterSuperBlock;
    }

    private void setOnActivityResult() {
        this.method = this.holder.getGeneratedClass().method(1, this.codeModel().VOID, "onActivityResult");
        this.method.annotate(Override.class);
        this.requestCodeParam = this.method.param(this.codeModel().INT, "requestCode");
        this.resultCodeParam = this.method.param(this.codeModel().INT, "resultCode");
        this.dataParam = this.method.param(this.classes().INTENT, "data");
        JBlock body = this.method.body();
        body.invoke(JExpr._super(), this.method).arg(this.requestCodeParam).arg(this.resultCodeParam).arg(this.dataParam);
        this.afterSuperBlock = body.block();
    }

    private JCodeModel codeModel() {
        return this.holder.codeModel();
    }

    public ProcessHolder.Classes classes() {
        return this.holder.classes();
    }
}

