/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.PreferenceByKey;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class PreferenceByKeyHandler
extends BaseAnnotationHandler<HasPreferences> {
    private IdAnnotationHelper annotationHelper;

    public PreferenceByKeyHandler(ProcessingEnvironment processingEnvironment) {
        super(PreferenceByKey.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element, valid);
        this.validatorHelper.isDeclaredType(element, valid);
        this.validatorHelper.extendsPreference(element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.STRING, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
    }

    @Override
    public void process(Element element, HasPreferences holder) throws Exception {
        String fieldName = element.getSimpleName().toString();
        TypeMirror prefFieldTypeMirror = element.asType();
        String typeQualifiedName = prefFieldTypeMirror.toString();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, element, IRClass.Res.STRING, true);
        JClass preferenceClass = this.refClass(typeQualifiedName);
        JFieldRef fieldRef = JExpr.ref(fieldName);
        holder.assignFindPreferenceByKey(idRef, preferenceClass, fieldRef);
    }
}

