/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.PreferenceChange;
import org.androidannotations.handler.AbstractPreferenceListenerHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class PreferenceChangeHandler
extends AbstractPreferenceListenerHandler {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public PreferenceChangeHandler(ProcessingEnvironment processingEnvironment) {
        super(PreferenceChange.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.hasNoOtherParameterThanPreferenceOrObjectOrSetOrStringOrBoolean(executableElement, valid);
        this.validatorHelper.param.hasZeroOrOnePreferenceParameter(executableElement, valid);
        this.validatorHelper.param.hasAtMostOneStringOrSetOrBooleanOrObjectParameter(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(HasPreferences holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> userParameters) {
        JVar preferenceParam = listenerMethod.param(this.classes().PREFERENCE, "preference");
        JVar newValueParam = listenerMethod.param(this.classes().OBJECT, "newValue");
        for (VariableElement variableElement : userParameters) {
            if (variableElement.asType().toString().equals("android.preference.Preference")) {
                call.arg(preferenceParam);
                continue;
            }
            if (variableElement.asType().toString().equals(CanonicalNameConstants.OBJECT)) {
                call.arg(newValueParam);
                continue;
            }
            JClass userParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), holder);
            call.arg(JExpr.cast(userParamClass, newValueParam));
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().BOOLEAN, "onPreferenceChange");
    }

    @Override
    protected String getSetterName() {
        return "setOnPreferenceChangeListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().PREFERENCE_CHANGE_LISTENER;
    }
}

