/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import org.androidannotations.annotations.sharedpreferences.DefaultFloat;
import org.androidannotations.annotations.sharedpreferences.DefaultInt;
import org.androidannotations.annotations.sharedpreferences.DefaultLong;
import org.androidannotations.annotations.sharedpreferences.DefaultRes;
import org.androidannotations.annotations.sharedpreferences.DefaultString;
import org.androidannotations.annotations.sharedpreferences.DefaultStringSet;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;
import org.androidannotations.api.sharedpreferences.BooleanPrefField;
import org.androidannotations.api.sharedpreferences.FloatPrefField;
import org.androidannotations.api.sharedpreferences.IntPrefField;
import org.androidannotations.api.sharedpreferences.LongPrefField;
import org.androidannotations.api.sharedpreferences.StringPrefField;
import org.androidannotations.api.sharedpreferences.StringSetPrefField;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.SharedPrefHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class SharedPrefHandler
extends BaseGeneratingAnnotationHandler<SharedPrefHolder> {
    private IdAnnotationHelper annotationHelper;
    private APTCodeModelHelper aptCodeModelHelper = new APTCodeModelHelper();
    private static final Map<String, DefaultPrefInfo<?>> DEFAULT_PREF_INFOS = new HashMap<String, DefaultPrefInfo<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("boolean", new DefaultPrefInfo<Boolean>(DefaultBoolean.class, BooleanPrefField.class, IRClass.Res.BOOL, false, "booleanField"));
            this.put("float", new DefaultPrefInfo<Float>(DefaultFloat.class, FloatPrefField.class, IRClass.Res.INTEGER, Float.valueOf(0.0f), "floatField"));
            this.put("int", new DefaultPrefInfo<Integer>(DefaultInt.class, IntPrefField.class, IRClass.Res.INTEGER, 0, "intField"));
            this.put("long", new DefaultPrefInfo<Long>(DefaultLong.class, LongPrefField.class, IRClass.Res.INTEGER, 0L, "longField"));
            this.put(CanonicalNameConstants.STRING, new DefaultPrefInfo<String>(DefaultString.class, StringPrefField.class, IRClass.Res.STRING, "", "stringField"));
            this.put("java.util.Set<java.lang.String>", new DefaultPrefInfo<Object>(DefaultStringSet.class, StringSetPrefField.class, null, null, "stringSetField"));
        }
    };

    public SharedPrefHandler(ProcessingEnvironment processingEnvironment) {
        super(SharedPref.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public SharedPrefHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        return new SharedPrefHolder(processHolder, annotatedElement);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.isInterface(typeElement, valid);
        List<? extends Element> inheritedMembers = this.processingEnv.getElementUtils().getAllMembers(typeElement);
        for (Element element2 : inheritedMembers) {
            if (element2.getEnclosingElement().asType().toString().equals("java.lang.Object")) continue;
            this.validatorHelper.isPrefMethod(element2, valid);
            DefaultPrefInfo<?> info = null;
            IdValidatorHelper defaultAnnotationValidatorHelper = null;
            if (!valid.isValid()) continue;
            info = DEFAULT_PREF_INFOS.get(((ExecutableElement)element2).getReturnType().toString());
            this.validatorHelper.hasCorrectDefaultAnnotation((ExecutableElement)element2, valid);
            if (valid.isValid() && element2.getAnnotation(DefaultRes.class) != null) {
                defaultAnnotationValidatorHelper = new IdValidatorHelper(new IdAnnotationHelper(this.processingEnv, DefaultRes.class.getName(), this.rClass));
                defaultAnnotationValidatorHelper.resIdsExist(element2, info.resType, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
            } else if (valid.isValid() && element2.getAnnotation(info.annotationClass) != null) {
                defaultAnnotationValidatorHelper = new IdValidatorHelper(new IdAnnotationHelper(this.processingEnv, info.annotationClass.getName(), this.rClass));
            }
            if (!valid.isValid() || defaultAnnotationValidatorHelper == null) continue;
            defaultAnnotationValidatorHelper.annotationParameterIsOptionalValidResId(element2, IRClass.Res.STRING, "keyRes", valid);
        }
    }

    @Override
    public void process(Element element, SharedPrefHolder holder) {
        this.generateConstructor(element, holder);
        this.generateFieldMethodAndEditorFieldMethod(element, holder);
    }

    private void generateConstructor(Element element, SharedPrefHolder holder) {
        SharedPref sharedPrefAnnotation = element.getAnnotation(SharedPref.class);
        SharedPref.Scope scope = sharedPrefAnnotation.value();
        int mode = sharedPrefAnnotation.mode();
        String interfaceSimpleName = element.getSimpleName().toString();
        JBlock constructorSuperBlock = holder.getConstructorSuperBlock();
        JVar contextParam = holder.getConstructorContextParam();
        switch (scope) {
            case ACTIVITY_DEFAULT: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam)).arg(JExpr.lit(mode)));
                break;
            }
            case ACTIVITY: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam).plus(JExpr.lit("_" + interfaceSimpleName))).arg(JExpr.lit(mode)));
                break;
            }
            case UNIQUE: {
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.lit(interfaceSimpleName)).arg(JExpr.lit(mode)));
                break;
            }
            case APPLICATION_DEFAULT: {
                JClass preferenceManagerClass = this.refClass("android.preference.PreferenceManager");
                constructorSuperBlock.invoke("super").arg(preferenceManagerClass.staticInvoke("getDefaultSharedPreferences").arg(contextParam));
                break;
            }
        }
    }

    private JMethod getLocalClassName(SharedPrefHolder holder) {
        JClass stringClass = this.classes().STRING;
        JMethod getLocalClassName = holder.getGeneratedClass().method(20, stringClass, "getLocalClassName");
        JClass contextClass = this.classes().CONTEXT;
        JVar contextParam = getLocalClassName.param(contextClass, "context");
        JBlock body = getLocalClassName.body();
        JVar packageName = body.decl(stringClass, "packageName", contextParam.invoke("getPackageName"));
        JVar className = body.decl(stringClass, "className", contextParam.invoke("getClass").invoke("getName"));
        JVar packageLen = body.decl(this.codeModel().INT, "packageLen", packageName.invoke("length"));
        JExpression condition = className.invoke("startsWith").arg(packageName).not().cor(className.invoke("length").lte(packageLen)).cor(className.invoke("charAt").arg(packageLen).ne(JExpr.lit('.')));
        body._if(condition)._then()._return(className);
        body._return(className.invoke("substring").arg(packageLen.plus(JExpr.lit(1))));
        return getLocalClassName;
    }

    private void generateFieldMethodAndEditorFieldMethod(Element element, SharedPrefHolder sharedPrefHolder) {
        for (ExecutableElement method : this.getValidMethods(element)) {
            JExpression keyExpression = this.generateFieldMethod(sharedPrefHolder, method);
            sharedPrefHolder.createEditorFieldMethods(method, keyExpression);
        }
    }

    private List<ExecutableElement> getValidMethods(Element element) {
        List<? extends Element> members = element.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> validMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            validMethods.add(method);
        }
        return validMethods;
    }

    private JExpression generateFieldMethod(SharedPrefHolder holder, ExecutableElement method) {
        DefaultPrefInfo<?> info = DEFAULT_PREF_INFOS.get(method.getReturnType().toString());
        return this.createFieldMethod(holder, method, info.annotationClass, info.prefFieldClass, info.defaultValue, info.resType, info.fieldHelperMethodName);
    }

    private JExpression createFieldMethod(SharedPrefHolder holder, ExecutableElement method, Class<? extends Annotation> annotationClass, Class<? extends AbstractPrefField<?>> prefFieldClass, Object defaultValue, IRClass.Res resType, String fieldHelperMethodName) {
        JExpression keyExpression;
        JExpression defaultValueExpr;
        Annotation annotation = method.getAnnotation(annotationClass);
        if (annotation != null && method.getAnnotation(DefaultStringSet.class) == null) {
            defaultValueExpr = this.aptCodeModelHelper.litObject(this.annotationHelper.extractAnnotationParameter(method, annotationClass.getName(), "value"));
        } else if (method.getAnnotation(DefaultRes.class) != null) {
            defaultValueExpr = this.extractResValue(holder, method, resType);
            annotationClass = DefaultRes.class;
        } else if (method.getAnnotation(DefaultStringSet.class) != null) {
            defaultValueExpr = this.newEmptyStringHashSet();
            annotationClass = DefaultStringSet.class;
        } else {
            defaultValueExpr = defaultValue != null ? this.aptCodeModelHelper.litObject(defaultValue) : this.newEmptyStringHashSet();
            annotationClass = null;
        }
        Integer keyResId = -1;
        if (annotationClass != null) {
            keyResId = (Integer)this.annotationHelper.extractAnnotationParameter(method, annotationClass.getName(), "keyRes");
        }
        String fieldName = method.getSimpleName().toString();
        if (keyResId == -1) {
            keyExpression = JExpr.lit(fieldName);
        } else {
            IRInnerClass idClass = this.rClass.get(IRClass.Res.STRING);
            JFieldRef idRef = idClass.getIdStaticRef(keyResId, this.processHolder);
            keyExpression = holder.getEditorContextField().invoke("getString").arg(idRef);
        }
        holder.createFieldMethod(prefFieldClass, keyExpression, fieldName, fieldHelperMethodName, defaultValueExpr);
        return keyExpression;
    }

    private JExpression extractResValue(SharedPrefHolder holder, Element method, IRClass.Res res) {
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, method, DefaultRes.class.getCanonicalName(), res, true);
        String resourceGetMethodName = null;
        switch (res) {
            case BOOL: {
                resourceGetMethodName = "getBoolean";
                break;
            }
            case INTEGER: {
                resourceGetMethodName = "getInteger";
                break;
            }
            case STRING: {
                resourceGetMethodName = "getString";
                break;
            }
        }
        return holder.getContextField().invoke("getResources").invoke(resourceGetMethodName).arg(idRef);
    }

    private JExpression newEmptyStringHashSet() {
        return JExpr._new(this.classes().HASH_SET.narrow(this.classes().STRING)).arg(JExpr.lit(0));
    }

    private static final class DefaultPrefInfo<T> {
        final Class<? extends Annotation> annotationClass;
        final Class<? extends AbstractPrefField<?>> prefFieldClass;
        final IRClass.Res resType;
        final T defaultValue;
        final String fieldHelperMethodName;

        DefaultPrefInfo(Class<? extends Annotation> annotationClass, Class<? extends AbstractPrefField<?>> prefFieldClass, IRClass.Res resType, T defaultValue, String fieldHelperMethodName) {
            this.annotationClass = annotationClass;
            this.prefFieldClass = prefFieldClass;
            this.resType = resType;
            this.defaultValue = defaultValue;
            this.fieldHelperMethodName = fieldHelperMethodName;
        }
    }
}

