/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.command;

import net.sf.asterisk.fastagi.command.AGICommand;

public class RecordFileCommand
extends AGICommand {
    private static final long serialVersionUID = 3978141041352128820L;
    private String file;
    private String format;
    private String escapeDigits;
    private int timeout;
    private int offset;
    private boolean beep;
    private int maxSilence;

    public RecordFileCommand(String file, String format, String escapeDigits, int timeout) {
        this.file = file;
        this.format = format;
        this.escapeDigits = escapeDigits;
        this.timeout = timeout;
        this.offset = 0;
        this.beep = false;
        this.maxSilence = 0;
    }

    public RecordFileCommand(String file, String format, String escapeDigits, int timeout, int offset, boolean beep, int maxSilence) {
        this.file = file;
        this.format = format;
        this.escapeDigits = escapeDigits;
        this.timeout = timeout;
        this.offset = offset;
        this.beep = beep;
        this.maxSilence = maxSilence;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEscapeDigits() {
        return this.escapeDigits;
    }

    public void setEscapeDigits(String escapeDigits) {
        this.escapeDigits = escapeDigits;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean getBeep() {
        return this.beep;
    }

    public void setBeep(boolean beep) {
        this.beep = beep;
    }

    public String buildCommand() {
        return "RECORD FILE " + this.escapeAndQuote(this.file) + " " + this.escapeAndQuote(this.format) + " " + this.escapeAndQuote(this.escapeDigits) + " " + this.timeout + " " + this.offset + (this.beep ? " BEEP" : "") + " s=" + this.maxSilence;
    }
}

