/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import java.io.IOException;
import java.util.ArrayList;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIHangupException;
import net.sf.asterisk.fastagi.AGINetworkException;
import net.sf.asterisk.fastagi.AGIReader;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.impl.AGIRequestImpl;
import net.sf.asterisk.fastagi.reply.AGIReply;
import net.sf.asterisk.fastagi.reply.impl.AGIReplyImpl;
import net.sf.asterisk.io.SocketConnectionFacade;

public class AGIReaderImpl
implements AGIReader {
    private SocketConnectionFacade socket;

    public AGIReaderImpl(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    public AGIRequest readRequest() throws AGIException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = this.socket.readLine()) != null && line.length() != 0) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new AGINetworkException("Unable to read request from Asterisk: " + e.getMessage(), e);
        }
        AGIRequestImpl request = new AGIRequestImpl(lines);
        request.setLocalAddress(this.socket.getLocalAddress());
        request.setLocalPort(this.socket.getLocalPort());
        request.setRemoteAddress(this.socket.getRemoteAddress());
        request.setRemotePort(this.socket.getRemotePort());
        return request;
    }

    public AGIReply readReply() throws AGIException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            line = this.socket.readLine();
        }
        catch (IOException e) {
            throw new AGINetworkException("Unable to read reply from Asterisk: " + e.getMessage(), e);
        }
        if (line == null) {
            throw new AGIHangupException();
        }
        lines.add(line);
        if (line.startsWith(Integer.toString(520))) {
            try {
                while ((line = this.socket.readLine()) != null) {
                    lines.add(line);
                    if (!line.startsWith(Integer.toString(520))) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new AGINetworkException("Unable to read reply from Asterisk: " + e.getMessage(), e);
            }
        }
        AGIReplyImpl reply = new AGIReplyImpl(lines);
        return reply;
    }
}

