/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.asterisk.manager.AsteriskManager;
import net.sf.asterisk.manager.AuthenticationFailedException;
import net.sf.asterisk.manager.Call;
import net.sf.asterisk.manager.Channel;
import net.sf.asterisk.manager.ChannelStateEnum;
import net.sf.asterisk.manager.EventTimeoutException;
import net.sf.asterisk.manager.Extension;
import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.ManagerEventHandler;
import net.sf.asterisk.manager.Originate;
import net.sf.asterisk.manager.Queue;
import net.sf.asterisk.manager.ResponseEvents;
import net.sf.asterisk.manager.TimeoutException;
import net.sf.asterisk.manager.action.CommandAction;
import net.sf.asterisk.manager.action.OriginateAction;
import net.sf.asterisk.manager.action.QueueStatusAction;
import net.sf.asterisk.manager.action.StatusAction;
import net.sf.asterisk.manager.event.ConnectEvent;
import net.sf.asterisk.manager.event.DisconnectEvent;
import net.sf.asterisk.manager.event.HangupEvent;
import net.sf.asterisk.manager.event.JoinEvent;
import net.sf.asterisk.manager.event.LeaveEvent;
import net.sf.asterisk.manager.event.LinkEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import net.sf.asterisk.manager.event.NewCallerIdEvent;
import net.sf.asterisk.manager.event.NewChannelEvent;
import net.sf.asterisk.manager.event.NewExtenEvent;
import net.sf.asterisk.manager.event.NewStateEvent;
import net.sf.asterisk.manager.event.OriginateEvent;
import net.sf.asterisk.manager.event.OriginateFailureEvent;
import net.sf.asterisk.manager.event.QueueEntryEvent;
import net.sf.asterisk.manager.event.QueueMemberEvent;
import net.sf.asterisk.manager.event.QueueParamsEvent;
import net.sf.asterisk.manager.event.RenameEvent;
import net.sf.asterisk.manager.event.StatusEvent;
import net.sf.asterisk.manager.event.UnlinkEvent;
import net.sf.asterisk.manager.response.CommandResponse;
import net.sf.asterisk.manager.response.ManagerResponse;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class DefaultAsteriskManager
implements AsteriskManager,
ManagerEventHandler {
    private static final Pattern SHOW_VERSION_FILES_PATTERN = Pattern.compile("^([\\S]+)\\s+Revision: ([0-9\\.]+)");
    private final Log logger = LogFactory.getLog(this.getClass());
    private ManagerConnection connection;
    private final Map channels = Collections.synchronizedMap(new HashMap());
    private final Map queues = Collections.synchronizedMap(new HashMap());
    private String version;
    private Map versions;
    private boolean skipQueues;

    public DefaultAsteriskManager() {
    }

    public DefaultAsteriskManager(ManagerConnection connection) {
        this();
        this.connection = connection;
    }

    public void setSkipQueues(boolean skipQueues) {
        this.skipQueues = skipQueues;
    }

    public void setManagerConnection(ManagerConnection connection) {
        this.connection = connection;
    }

    public void initialize() throws TimeoutException, IOException, AuthenticationFailedException {
        this.connection.login();
        this.initializeChannels();
        this.initializeQueues();
        this.connection.addEventHandler(this);
    }

    private void initializeChannels() throws EventTimeoutException, IOException {
        ResponseEvents re = this.connection.sendEventGeneratingAction(new StatusAction());
        Iterator i = re.getEvents().iterator();
        while (i.hasNext()) {
            ManagerEvent event = (ManagerEvent)i.next();
            if (!(event instanceof StatusEvent)) continue;
            this.handleStatusEvent((StatusEvent)event);
        }
    }

    private void initializeQueues() throws IOException {
        ResponseEvents re;
        if (this.skipQueues) {
            return;
        }
        try {
            re = this.connection.sendEventGeneratingAction(new QueueStatusAction());
        }
        catch (EventTimeoutException e) {
            re = e.getPartialResult();
        }
        Iterator i = re.getEvents().iterator();
        while (i.hasNext()) {
            ManagerEvent event = (ManagerEvent)i.next();
            if (event instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)event);
                continue;
            }
            if (event instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)event);
                continue;
            }
            if (!(event instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)event);
        }
    }

    public Call originateCall(Originate originate) throws TimeoutException, IOException {
        Long timeout = originate.getTimeout() == null ? new Long(30000L) : originate.getTimeout();
        OriginateAction originateAction = new OriginateAction();
        originateAction.setAccount(originate.getAccount());
        originateAction.setApplication(originate.getApplication());
        originateAction.setCallerId(originate.getCallerId());
        originateAction.setChannel(originate.getChannel());
        originateAction.setContext(originate.getContext());
        originateAction.setData(originate.getData());
        originateAction.setExten(originate.getExten());
        originateAction.setPriority(originate.getPriority());
        originateAction.setTimeout(timeout);
        originateAction.setVariables(originate.getVariables());
        originateAction.setAsync(Boolean.TRUE);
        ResponseEvents responseEvents = this.connection.sendEventGeneratingAction(originateAction, timeout + 2000L);
        return this.originateEvent2Call((OriginateEvent)responseEvents.getEvents().toArray()[0]);
    }

    public Map getChannels() {
        return this.channels;
    }

    public Map getQueues() {
        return this.queues;
    }

    public String getVersion() {
        if (this.version == null) {
            try {
                List result;
                ManagerResponse response = this.connection.sendAction(new CommandAction("show version"));
                if (response instanceof CommandResponse && (result = ((CommandResponse)response).getResult()).size() > 0) {
                    this.version = (String)result.get(0);
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to send 'show version' command.", e);
            }
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVersion(String file) {
        Map<String, String> map;
        String fileVersion = null;
        if (this.versions == null) {
            map = new HashMap();
            try {
                ManagerResponse response = this.connection.sendAction(new CommandAction("show version files"));
                if (response instanceof CommandResponse) {
                    List result = ((CommandResponse)response).getResult();
                    for (int i = 2; i < result.size(); ++i) {
                        String line = (String)result.get(i);
                        Matcher matcher = SHOW_VERSION_FILES_PATTERN.matcher(line);
                        if (!matcher.find()) continue;
                        String key = matcher.group(1);
                        String value = matcher.group(2);
                        map.put(key, value);
                    }
                    fileVersion = (String)map.get(file);
                    this.versions = map;
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to send 'show version files' command.", e);
            }
        } else {
            map = this.versions;
            synchronized (map) {
                fileVersion = (String)this.versions.get(file);
            }
        }
        if (fileVersion == null) {
            return null;
        }
        String[] parts = fileVersion.split("\\.");
        int[] intParts = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                intParts[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                intParts[i] = 0;
            }
        }
        return intParts;
    }

    public void handleEvent(ManagerEvent event) {
        if (event instanceof ConnectEvent) {
            this.handleConnectEvent((ConnectEvent)event);
        } else if (event instanceof DisconnectEvent) {
            this.handleDisconnectEvent((DisconnectEvent)event);
        } else if (event instanceof NewChannelEvent) {
            this.handleNewChannelEvent((NewChannelEvent)event);
        } else if (event instanceof NewExtenEvent) {
            this.handleNewExtenEvent((NewExtenEvent)event);
        } else if (event instanceof NewStateEvent) {
            this.handleNewStateEvent((NewStateEvent)event);
        } else if (event instanceof NewCallerIdEvent) {
            this.handleNewCallerIdEvent((NewCallerIdEvent)event);
        } else if (event instanceof LinkEvent) {
            this.handleLinkEvent((LinkEvent)event);
        } else if (event instanceof UnlinkEvent) {
            this.handleUnlinkEvent((UnlinkEvent)event);
        } else if (event instanceof RenameEvent) {
            this.handleRenameEvent((RenameEvent)event);
        } else if (event instanceof HangupEvent) {
            this.handleHangupEvent((HangupEvent)event);
        } else if (event instanceof JoinEvent) {
            this.handleJoinEvent((JoinEvent)event);
        } else if (event instanceof LeaveEvent) {
            this.handleLeaveEvent((LeaveEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChannel(Channel channel) {
        Map map = this.channels;
        synchronized (map) {
            this.channels.put(channel.getId(), channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChannel(Channel channel) {
        Map map = this.channels;
        synchronized (map) {
            this.channels.remove(channel.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addQueue(Queue queue) {
        Map map = this.queues;
        synchronized (map) {
            this.queues.put(queue.getName(), queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeQueue(Queue queue) {
        Map map = this.queues;
        synchronized (map) {
            this.queues.remove(queue.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStatusEvent(StatusEvent event) {
        boolean isNew = false;
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            channel = new Channel(event.getChannel(), event.getUniqueId());
            if (event.getSeconds() != null) {
                channel.setDateOfCreation(new Date(System.currentTimeMillis() - (long)(event.getSeconds() * 1000)));
            }
            isNew = true;
        }
        Extension extension = event.getContext() == null && event.getExtension() == null && event.getPriority() == null ? null : new Extension(event.getDateReceived(), event.getContext(), event.getExtension(), event.getPriority());
        Channel channel2 = channel;
        synchronized (channel2) {
            Channel linkedChannel;
            channel.setCallerId(event.getCallerId());
            channel.setCallerIdName(event.getCallerIdName());
            channel.setAccount(event.getAccount());
            channel.setState(ChannelStateEnum.getEnum(event.getState()));
            channel.addExtension(extension);
            if (event.getLink() != null && (linkedChannel = this.getChannelByName(event.getLink())) != null) {
                channel.setLinkedChannel(linkedChannel);
                Channel channel3 = linkedChannel;
                synchronized (channel3) {
                    linkedChannel.setLinkedChannel(channel);
                }
            }
        }
        if (isNew) {
            this.logger.info("Adding new channel " + channel.getName());
            this.addChannel(channel);
        }
    }

    protected void handleDisconnectEvent(DisconnectEvent disconnectEvent) {
        this.version = null;
        this.versions = null;
        this.channels.clear();
        this.queues.clear();
    }

    protected void handleConnectEvent(ConnectEvent connectEvent) {
        try {
            this.initializeChannels();
        }
        catch (Exception e) {
            this.logger.error("Unable to initialize channels after reconnect.", e);
        }
        try {
            this.initializeQueues();
        }
        catch (IOException e) {
            this.logger.error("Unable to initialize queues after reconnect.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueueParamsEvent(QueueParamsEvent event) {
        boolean isNew = false;
        Queue queue = (Queue)this.queues.get(event.getQueue());
        if (queue == null) {
            queue = new Queue(event.getQueue());
            isNew = true;
        }
        Queue queue2 = queue;
        synchronized (queue2) {
            queue.setMax(event.getMax());
        }
        if (isNew) {
            this.logger.info("Adding new queue " + queue.getName());
            this.addQueue(queue);
        }
    }

    protected void handleQueueMemberEvent(QueueMemberEvent event) {
    }

    protected void handleQueueEntryEvent(QueueEntryEvent event) {
        Queue queue = (Queue)this.queues.get(event.getQueue());
        Channel channel = this.getChannelByName(event.getChannel());
        if (queue == null) {
            this.logger.error("ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("ignored QueueEntryEvent for unknown channel " + event.getChannel());
            return;
        }
        if (!queue.getEntries().contains(channel)) {
            queue.addEntry(channel);
        }
    }

    protected void handleJoinEvent(JoinEvent event) {
        Queue queue = (Queue)this.queues.get(event.getQueue());
        Channel channel = this.getChannelByName(event.getChannel());
        if (queue == null) {
            this.logger.error("ignored JoinEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("ignored JoinEvent for unknown channel " + event.getChannel());
            return;
        }
        if (!queue.getEntries().contains(channel)) {
            queue.addEntry(channel);
        }
    }

    protected void handleLeaveEvent(LeaveEvent event) {
        Queue queue = (Queue)this.queues.get(event.getQueue());
        Channel channel = this.getChannelByName(event.getChannel());
        if (queue == null) {
            this.logger.error("ignored LeaveEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("ignored LeaveEvent for unknown channel " + event.getChannel());
            return;
        }
        if (queue.getEntries().contains(channel)) {
            queue.removeEntry(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannelByName(String name) {
        Channel channel = null;
        Map map = this.channels;
        synchronized (map) {
            Iterator channelIterator = this.channels.values().iterator();
            while (channelIterator.hasNext()) {
                Channel tmp = (Channel)channelIterator.next();
                if (tmp.getName() == null || !tmp.getName().equals(name)) continue;
                channel = tmp;
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannelById(String id) {
        Channel channel = null;
        Map map = this.channels;
        synchronized (map) {
            channel = (Channel)this.channels.get(id);
        }
        return channel;
    }

    protected void handleNewChannelEvent(NewChannelEvent event) {
        Channel channel = new Channel(event.getChannel(), event.getUniqueId());
        channel.setDateOfCreation(event.getDateReceived());
        channel.setCallerId(event.getCallerId());
        channel.setCallerIdName(event.getCallerIdName());
        channel.setState(ChannelStateEnum.getEnum(event.getState()));
        this.logger.info("Adding channel " + channel.getName());
        this.addChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewExtenEvent(NewExtenEvent event) {
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            this.logger.error("Ignored NewExtenEvent for unknown channel " + event.getChannel());
            return;
        }
        Extension extension = new Extension(event.getDateReceived(), event.getContext(), event.getExtension(), event.getPriority(), event.getApplication(), event.getAppData());
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.addExtension(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewStateEvent(NewStateEvent event) {
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            this.logger.error("Ignored NewStateEvent for unknown channel " + event.getChannel());
            return;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.setState(ChannelStateEnum.getEnum(event.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewCallerIdEvent(NewCallerIdEvent event) {
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            this.logger.error("Ignored NewCallerIdEvent for unknown channel " + event.getChannel());
            return;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.setCallerId(event.getCallerId());
            channel.setCallerIdName(event.getCallerIdName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHangupEvent(HangupEvent event) {
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            this.logger.error("Ignored HangupEvent for unknown channel " + event.getChannel());
            return;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.setState(ChannelStateEnum.HUNGUP);
        }
        this.logger.info("Removing channel " + channel.getName() + " due to hangup");
        this.removeChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLinkEvent(LinkEvent event) {
        Channel channel1 = (Channel)this.channels.get(event.getUniqueId1());
        Channel channel2 = (Channel)this.channels.get(event.getUniqueId2());
        if (channel1 == null) {
            this.logger.error("Ignored LinkEvent for unknown channel " + event.getChannel1());
            return;
        }
        if (channel2 == null) {
            this.logger.error("Ignored LinkEvent for unknown channel " + event.getChannel2());
            return;
        }
        this.logger.info("Linking channels " + channel1.getName() + " and " + channel2.getName());
        DefaultAsteriskManager defaultAsteriskManager = this;
        synchronized (defaultAsteriskManager) {
            channel1.setLinkedChannel(channel2);
            channel2.setLinkedChannel(channel1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnlinkEvent(UnlinkEvent event) {
        Channel channel1 = this.getChannelByName(event.getChannel1());
        Channel channel2 = this.getChannelByName(event.getChannel2());
        if (channel1 == null) {
            this.logger.error("Ignored UnlinkEvent for unknown channel " + event.getChannel1());
            return;
        }
        if (channel2 == null) {
            this.logger.error("Ignored UnlinkEvent for unknown channel " + event.getChannel2());
            return;
        }
        this.logger.info("Unlinking channels " + channel1.getName() + " and " + channel2.getName());
        Channel channel = channel1;
        synchronized (channel) {
            channel1.setLinkedChannel(null);
        }
        channel = channel2;
        synchronized (channel) {
            channel2.setLinkedChannel(null);
        }
    }

    protected void handleRenameEvent(RenameEvent event) {
        Channel channel = this.getChannelById(event.getUniqueId());
        if (channel == null) {
            this.logger.error("Ignored RenameEvent for unknown channel with uniqueId " + event.getUniqueId());
            return;
        }
        this.logger.info("Renaming channel '" + channel.getName() + "' to '" + event.getNewname() + "'");
        channel.setName(event.getNewname());
    }

    protected Call originateEvent2Call(OriginateEvent event) {
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        Call call = new Call();
        call.setUniqueId(event.getUniqueId());
        call.setChannel(channel);
        call.setStartTime(event.getDateReceived());
        if (event instanceof OriginateFailureEvent) {
            call.setEndTime(event.getDateReceived());
        }
        call.setReason(event.getReason());
        return call;
    }
}

