/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.util;

import java.util.LinkedList;
import java.util.List;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ThreadPool {
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean running;
    private int numThreads;
    private String name;
    private List jobs;

    public ThreadPool(String name, int numThreads) {
        this.name = name;
        this.numThreads = numThreads;
        this.jobs = new LinkedList();
        this.running = true;
        PoolThreadGroup group = new PoolThreadGroup(this.name);
        for (int i = 0; i < this.numThreads; ++i) {
            TaskThread thread = new TaskThread(group, this.name + "-TaskThread-" + i);
            thread.start();
        }
        this.logger.debug("ThreadPool created with " + this.numThreads + " threads.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable obtainJob() {
        Runnable job = null;
        List list = this.jobs;
        synchronized (list) {
            while (job == null && this.running) {
                try {
                    if (this.jobs.size() == 0) {
                        this.jobs.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.jobs.size() <= 0) continue;
                job = (Runnable)this.jobs.get(0);
                this.jobs.remove(0);
            }
        }
        if (this.running) {
            return job;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Runnable runnable) {
        List list = this.jobs;
        synchronized (list) {
            this.jobs.add(runnable);
            this.jobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        List list = this.jobs;
        synchronized (list) {
            this.jobs.notifyAll();
        }
        this.logger.debug("ThreadPool shutting down.");
    }

    class PoolThreadGroup
    extends ThreadGroup {
        public PoolThreadGroup(String name) {
            super(name);
        }

        public void uncaughtException(Thread t, Throwable e) {
            ThreadPool.this.logger.warn("Uncaught exception in Thread " + t.getName(), e);
        }
    }

    class TaskThread
    extends Thread {
        public TaskThread(ThreadGroup group, String name) {
            super(group, name);
        }

        public void run() {
            Runnable job;
            while ((job = ThreadPool.this.obtainJob()) != null) {
                job.run();
            }
        }
    }
}

