/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import org.asteriskjava.fastagi.command.AbstractAgiCommand;

public class SayDateTimeCommand
extends AbstractAgiCommand {
    private static final long serialVersionUID = -976344744239948036L;
    private static final String DEFAULT_FORMAT = "ABdY 'digits/at' IMp";
    private long time;
    private String escapeDigits;
    private String format;
    private String timezone;

    public SayDateTimeCommand(long time) {
        this.time = time;
    }

    public SayDateTimeCommand(long time, String escapeDigits) {
        this.time = time;
        this.escapeDigits = escapeDigits;
    }

    public SayDateTimeCommand(long time, String escapeDigits, String format) {
        this.time = time;
        this.escapeDigits = escapeDigits;
        this.format = format;
    }

    public SayDateTimeCommand(long time, String escapeDigits, String format, String timezone) {
        this.time = time;
        this.escapeDigits = escapeDigits;
        this.format = format;
        this.timezone = timezone;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getEscapeDigits() {
        return this.escapeDigits;
    }

    public void setEscapeDigits(String escapeDigits) {
        this.escapeDigits = escapeDigits;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String buildCommand() {
        StringBuffer sb = new StringBuffer("SAY DATETIME ");
        sb.append(this.time);
        sb.append(" ");
        sb.append(this.escapeAndQuote(this.escapeDigits));
        if (this.format == null && this.timezone != null) {
            sb.append(" ");
            sb.append(this.escapeAndQuote(DEFAULT_FORMAT));
        }
        if (this.format != null) {
            sb.append(" ");
            sb.append(this.escapeAndQuote(this.format));
        }
        if (this.timezone != null) {
            sb.append(" ");
            sb.append(this.escapeAndQuote(this.timezone));
        }
        return sb.toString();
    }
}

