/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.InvalidCommandSyntaxException;
import org.asteriskjava.fastagi.InvalidOrUnknownCommandException;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.fastagi.command.AnswerCommand;
import org.asteriskjava.fastagi.command.ChannelStatusCommand;
import org.asteriskjava.fastagi.command.ControlStreamFileCommand;
import org.asteriskjava.fastagi.command.DatabaseDelCommand;
import org.asteriskjava.fastagi.command.DatabaseDelTreeCommand;
import org.asteriskjava.fastagi.command.DatabaseGetCommand;
import org.asteriskjava.fastagi.command.DatabasePutCommand;
import org.asteriskjava.fastagi.command.ExecCommand;
import org.asteriskjava.fastagi.command.GetDataCommand;
import org.asteriskjava.fastagi.command.GetFullVariableCommand;
import org.asteriskjava.fastagi.command.GetOptionCommand;
import org.asteriskjava.fastagi.command.GetVariableCommand;
import org.asteriskjava.fastagi.command.HangupCommand;
import org.asteriskjava.fastagi.command.RecordFileCommand;
import org.asteriskjava.fastagi.command.SayAlphaCommand;
import org.asteriskjava.fastagi.command.SayDateTimeCommand;
import org.asteriskjava.fastagi.command.SayDigitsCommand;
import org.asteriskjava.fastagi.command.SayNumberCommand;
import org.asteriskjava.fastagi.command.SayPhoneticCommand;
import org.asteriskjava.fastagi.command.SayTimeCommand;
import org.asteriskjava.fastagi.command.SetAutoHangupCommand;
import org.asteriskjava.fastagi.command.SetCallerIdCommand;
import org.asteriskjava.fastagi.command.SetContextCommand;
import org.asteriskjava.fastagi.command.SetExtensionCommand;
import org.asteriskjava.fastagi.command.SetMusicOffCommand;
import org.asteriskjava.fastagi.command.SetMusicOnCommand;
import org.asteriskjava.fastagi.command.SetPriorityCommand;
import org.asteriskjava.fastagi.command.SetVariableCommand;
import org.asteriskjava.fastagi.command.StreamFileCommand;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.command.WaitForDigitCommand;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiReaderImpl;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.fastagi.internal.AgiWriterImpl;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.util.SocketConnectionFacade;

public class AgiChannelImpl
implements AgiChannel {
    private final AgiRequest request;
    private final AgiWriter agiWriter;
    private final AgiReader agiReader;

    AgiChannelImpl(AgiRequest request, SocketConnectionFacade socket) {
        this.request = request;
        this.agiWriter = new AgiWriterImpl(socket);
        this.agiReader = new AgiReaderImpl(socket);
    }

    AgiChannelImpl(AgiRequest request, AgiWriter agiWriter, AgiReader agiReader) {
        this.request = request;
        this.agiWriter = agiWriter;
        this.agiReader = agiReader;
    }

    public String getName() {
        return this.request.getChannel();
    }

    public String getUniqueId() {
        return this.request.getUniqueId();
    }

    public synchronized AgiReply sendCommand(AgiCommand command) throws AgiException {
        this.agiWriter.sendCommand(command);
        AgiReply reply = this.agiReader.readReply();
        if (reply.getStatus() == 510) {
            throw new InvalidOrUnknownCommandException(command.buildCommand());
        }
        if (reply.getStatus() == 520) {
            throw new InvalidCommandSyntaxException(reply.getSynopsis(), reply.getUsage());
        }
        return reply;
    }

    public void answer() throws AgiException {
        this.sendCommand(new AnswerCommand());
    }

    public void hangup() throws AgiException {
        this.sendCommand(new HangupCommand());
    }

    public void setAutoHangup(int time) throws AgiException {
        this.sendCommand(new SetAutoHangupCommand(time));
    }

    public void setCallerId(String callerId) throws AgiException {
        this.sendCommand(new SetCallerIdCommand(callerId));
    }

    public void playMusicOnHold() throws AgiException {
        this.sendCommand(new SetMusicOnCommand());
    }

    public void playMusicOnHold(String musicOnHoldClass) throws AgiException {
        this.sendCommand(new SetMusicOnCommand(musicOnHoldClass));
    }

    public void stopMusicOnHold() throws AgiException {
        this.sendCommand(new SetMusicOffCommand());
    }

    public int getChannelStatus() throws AgiException {
        AgiReply reply = this.sendCommand(new ChannelStatusCommand());
        return reply.getResultCode();
    }

    public String getData(String file) throws AgiException {
        AgiReply reply = this.sendCommand(new GetDataCommand(file));
        return reply.getResult();
    }

    public String getData(String file, long timeout) throws AgiException {
        AgiReply reply = this.sendCommand(new GetDataCommand(file, timeout));
        return reply.getResult();
    }

    public String getData(String file, long timeout, int maxDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new GetDataCommand(file, timeout, maxDigits));
        return reply.getResult();
    }

    public char getOption(String file, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public char getOption(String file, String escapeDigits, int timeout) throws AgiException {
        AgiReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits, timeout));
        return reply.getResultCodeAsChar();
    }

    public int exec(String application) throws AgiException {
        AgiReply reply = this.sendCommand(new ExecCommand(application));
        return reply.getResultCode();
    }

    public int exec(String application, String options) throws AgiException {
        AgiReply reply = this.sendCommand(new ExecCommand(application, options));
        return reply.getResultCode();
    }

    public void setContext(String context) throws AgiException {
        this.sendCommand(new SetContextCommand(context));
    }

    public void setExtension(String extension) throws AgiException {
        this.sendCommand(new SetExtensionCommand(extension));
    }

    public void setPriority(String priority) throws AgiException {
        this.sendCommand(new SetPriorityCommand(priority));
    }

    public void streamFile(String file) throws AgiException {
        this.sendCommand(new StreamFileCommand(file));
    }

    public char streamFile(String file, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new StreamFileCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayDigits(String digits) throws AgiException {
        this.sendCommand(new SayDigitsCommand(digits));
    }

    public char sayDigits(String digits, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayDigitsCommand(digits, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayNumber(String number) throws AgiException {
        this.sendCommand(new SayNumberCommand(number));
    }

    public char sayNumber(String number, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayNumberCommand(number, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayPhonetic(String text) throws AgiException {
        this.sendCommand(new SayPhoneticCommand(text));
    }

    public char sayPhonetic(String text, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayPhoneticCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayAlpha(String text) throws AgiException {
        this.sendCommand(new SayAlphaCommand(text));
    }

    public char sayAlpha(String text, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayAlphaCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayTime(long time) throws AgiException {
        this.sendCommand(new SayTimeCommand(time));
    }

    public char sayTime(long time, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public String getVariable(String name) throws AgiException {
        AgiReply reply = this.sendCommand(new GetVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public void setVariable(String name, String value) throws AgiException {
        this.sendCommand(new SetVariableCommand(name, value));
    }

    public char waitForDigit(int timeout) throws AgiException {
        AgiReply reply = this.sendCommand(new WaitForDigitCommand(timeout));
        return reply.getResultCodeAsChar();
    }

    public String getFullVariable(String name) throws AgiException {
        AgiReply reply = this.sendCommand(new GetFullVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public String getFullVariable(String name, String channel) throws AgiException {
        AgiReply reply = this.sendCommand(new GetFullVariableCommand(name, channel));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public char sayDateTime(long time, String escapeDigits, String format, String timezone) throws AgiException {
        AgiReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format, timezone));
        return reply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits, String format) throws AgiException {
        AgiReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format));
        return reply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayDateTime(long time) throws AgiException {
        this.sendCommand(new SayDateTimeCommand(time));
    }

    public String databaseGet(String family, String key) throws AgiException {
        AgiReply reply = this.sendCommand(new DatabaseGetCommand(family, key));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public void databasePut(String family, String key, String value) throws AgiException {
        this.sendCommand(new DatabasePutCommand(family, key, value));
    }

    public void databaseDel(String family, String key) throws AgiException {
        this.sendCommand(new DatabaseDelCommand(family, key));
    }

    public void databaseDelTree(String family) throws AgiException {
        this.sendCommand(new DatabaseDelTreeCommand(family));
    }

    public void databaseDelTree(String family, String keytree) throws AgiException {
        this.sendCommand(new DatabaseDelTreeCommand(family, keytree));
    }

    public void verbose(String message, int level) throws AgiException {
        this.sendCommand(new VerboseCommand(message, level));
    }

    public void recordFile(String file, String format, String escapeDigits, int timeout) throws AgiException {
        this.sendCommand(new RecordFileCommand(file, format, escapeDigits, timeout));
    }

    public void recordFile(String file, String format, String escapeDigits, int timeout, int offset, boolean beep, int maxSilence) throws AgiException {
        this.sendCommand(new RecordFileCommand(file, format, escapeDigits, timeout, offset, beep, maxSilence));
    }

    public void controlStreamFile(String file) throws AgiException {
        this.sendCommand(new ControlStreamFileCommand(file));
    }

    public char controlStreamFile(String file, String escapeDigits) throws AgiException {
        AgiReply reply = this.sendCommand(new ControlStreamFileCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public char controlStreamFile(String file, String escapeDigits, int offset) throws AgiException {
        AgiReply reply = this.sendCommand(new ControlStreamFileCommand(file, escapeDigits, offset));
        return reply.getResultCodeAsChar();
    }

    public char controlStreamFile(String file, String escapeDigits, int offset, String forwardDigit, String rewindDigit, String pauseDigit) throws AgiException {
        AgiReply reply = this.sendCommand(new ControlStreamFileCommand(file, escapeDigits, offset, forwardDigit, rewindDigit, pauseDigit));
        return reply.getResultCodeAsChar();
    }
}

