/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.List;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueListener;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsteriskQueueImpl
extends AbstractLiveObject
implements AsteriskQueue {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String name;
    private Integer max;
    private Integer serviceLevel;
    private Integer weight;
    private final ArrayList<AsteriskChannel> entries;
    private final List<AsteriskQueueListener> listeners;

    AsteriskQueueImpl(AsteriskServerImpl server, String name, Integer max, Integer serviceLevel, Integer weight) {
        super(server);
        this.name = name;
        this.max = max;
        this.serviceLevel = serviceLevel;
        this.weight = weight;
        this.entries = new ArrayList(25);
        this.listeners = new ArrayList<AsteriskQueueListener>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public Integer getServiceLevel() {
        return this.serviceLevel;
    }

    void setServiceLevel(Integer serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    void setWeight(Integer weight) {
        this.weight = weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsteriskChannel> getEntries() {
        ArrayList<AsteriskChannel> arrayList = this.entries;
        synchronized (arrayList) {
            return (List)this.entries.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(AsteriskChannel entry) {
        ArrayList<AsteriskChannel> arrayList = this.entries;
        synchronized (arrayList) {
            if (this.entries.contains(entry)) {
                return;
            }
            this.entries.add(entry);
        }
        this.fireNewEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(AsteriskChannel entry) {
        ArrayList<AsteriskChannel> arrayList = this.entries;
        synchronized (arrayList) {
            this.entries.remove(entry);
        }
        this.fireEntryLeave(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("AsteriskQueue[");
        sb.append("name='" + this.getName() + "',");
        sb.append("max='" + this.getMax() + "',");
        sb.append("serviceLevel='" + this.getServiceLevel() + "',");
        sb.append("weight='" + this.getWeight() + "',");
        ArrayList<AsteriskChannel> arrayList = this.entries;
        synchronized (arrayList) {
            sb.append("entries='" + this.entries.toString() + "',");
        }
        sb.append("systemHashcode=" + System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewEntry(AsteriskChannel channel) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onNewEntry(channel);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewEntryl()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEntryLeave(AsteriskChannel channel) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryLeave(channel);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onEntryLeave()", e);
                }
            }
        }
    }
}

