/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.QueueStatusAction;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private final Map<String, AsteriskQueueImpl> queues;

    QueueManager(AsteriskServerImpl server, ChannelManager channelManager) {
        this.server = server;
        this.channelManager = channelManager;
        this.queues = new HashMap<String, AsteriskQueueImpl>();
    }

    void initialize() throws ManagerCommunicationException {
        ResponseEvents re;
        try {
            re = this.server.sendEventGeneratingAction(new QueueStatusAction());
        }
        catch (ManagerCommunicationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EventTimeoutException) {
                re = ((EventTimeoutException)cause).getPartialResult();
            }
            throw e;
        }
        for (ResponseEvent event : re.getEvents()) {
            if (event instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)event);
                continue;
            }
            if (event instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)event);
                continue;
            }
            if (!(event instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            this.queues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskQueue> getQueues() {
        ArrayList<AsteriskQueue> copy;
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            copy = new ArrayList<AsteriskQueue>(this.queues.values());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueue(AsteriskQueueImpl queue) {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            this.queues.put(queue.getName(), queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQueueParamsEvent(QueueParamsEvent event) {
        String name = event.getQueue();
        Integer max = event.getMax();
        Integer serviceLevel = event.getServiceLevel();
        Integer weight = event.getServiceLevel();
        AsteriskQueueImpl queue = this.queues.get(name);
        if (queue == null) {
            queue = new AsteriskQueueImpl(this.server, name, max, serviceLevel, weight);
            this.logger.info("Adding new queue " + queue);
            this.addQueue(queue);
        } else {
            AsteriskQueueImpl asteriskQueueImpl = queue;
            synchronized (asteriskQueueImpl) {
                queue.setMax(max);
                queue.setServiceLevel(serviceLevel);
                queue.setWeight(weight);
            }
        }
    }

    void handleQueueMemberEvent(QueueMemberEvent event) {
    }

    void handleQueueEntryEvent(QueueEntryEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown channel " + event.getChannel());
            return;
        }
        queue.addEntry(channel);
    }

    void handleJoinEvent(JoinEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored JoinEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored JoinEvent for unknown channel " + event.getChannel());
            return;
        }
        queue.addEntry(channel);
    }

    void handleLeaveEvent(LeaveEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored LeaveEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored LeaveEvent for unknown channel " + event.getChannel());
            return;
        }
        queue.removeEntry(channel);
    }
}

