/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.internal.ActionBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionBuilderImpl
implements ActionBuilder {
    private static final String LINE_SEPARATOR = "\r\n";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AsteriskVersion targetVersion = AsteriskVersion.ASTERISK_1_0;

    ActionBuilderImpl() {
    }

    @Override
    public void setTargetVersion(AsteriskVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    @Override
    public String buildAction(ManagerAction action) {
        return this.buildAction(action, null);
    }

    @Override
    public String buildAction(ManagerAction action, String internalActionId) {
        StringBuffer sb = new StringBuffer();
        sb.append("action: ");
        sb.append(action.getAction());
        sb.append(LINE_SEPARATOR);
        if (internalActionId != null) {
            sb.append("actionid: ");
            sb.append(ManagerUtil.addInternalActionId(action.getActionId(), internalActionId));
            sb.append(LINE_SEPARATOR);
        } else if (action.getActionId() != null) {
            sb.append("actionid: ");
            sb.append(action.getActionId());
            sb.append(LINE_SEPARATOR);
        }
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("class");
        ignore.add("action");
        ignore.add("actionid");
        if (action instanceof UserEventAction) {
            UserEvent userEvent = ((UserEventAction)action).getUserEvent();
            this.appendUserEvent(sb, userEvent);
            this.appendGetters(sb, userEvent, ignore);
        } else {
            this.appendGetters(sb, action, ignore);
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    private void appendMap(StringBuffer sb, String key, Map<String, String> values) {
        String singularKey = key.endsWith("s") ? key.substring(0, key.length() - 1) : key;
        if (this.targetVersion.isAtLeast(AsteriskVersion.ASTERISK_1_2)) {
            this.appendMap12(sb, singularKey, values);
        } else {
            this.appendMap10(sb, singularKey, values);
        }
    }

    private void appendMap10(StringBuffer sb, String singularKey, Map<String, String> values) {
        sb.append(singularKey);
        sb.append(": ");
        Iterator<Map.Entry<String, String>> entryIterator = values.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> entry = entryIterator.next();
            sb.append((Object)entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append((Object)entry.getValue());
            }
            if (!entryIterator.hasNext()) continue;
            sb.append("|");
        }
        sb.append(LINE_SEPARATOR);
    }

    private void appendMap12(StringBuffer sb, String singularKey, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            sb.append(singularKey);
            sb.append(": ");
            sb.append((Object)entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append((Object)entry.getValue());
            }
            sb.append(LINE_SEPARATOR);
        }
    }

    private void appendString(StringBuffer sb, String key, String value) {
        sb.append(key);
        sb.append(": ");
        sb.append(value);
        sb.append(LINE_SEPARATOR);
    }

    private void appendUserEvent(StringBuffer sb, UserEvent event) {
        Class<?> clazz = event.getClass();
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        this.appendString(sb, "UserEvent", eventType);
    }

    private void appendGetters(StringBuffer sb, Object action, Set<String> membersToIgnore) {
        Map<String, Method> getters = ReflectionUtil.getGetters(action.getClass());
        for (String name : getters.keySet()) {
            Object value;
            if (membersToIgnore.contains(name)) continue;
            Method getter = getters.get(name);
            try {
                value = getter.invoke(action, new Object[0]);
            }
            catch (Exception ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            if (value == null || value instanceof Class) continue;
            if (value instanceof Map) {
                this.appendMap(sb, name, (Map)value);
                continue;
            }
            if (value instanceof String) {
                this.appendString(sb, name, (String)value);
                continue;
            }
            this.appendString(sb, name, value.toString());
        }
    }
}

