/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.ExtensionStateResponse;
import org.asteriskjava.manager.response.GetConfigResponse;
import org.asteriskjava.manager.response.MailboxCountResponse;
import org.asteriskjava.manager.response.MailboxStatusResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseBuilderImpl
implements ResponseBuilder {
    ResponseBuilderImpl() {
    }

    @Override
    public ManagerResponse buildResponse(Map<String, String> attributes) {
        ManagerResponse response;
        String responseType = attributes.get("response");
        String proxyResponseType = attributes.get("proxyresponse");
        if ("error".equalsIgnoreCase(responseType)) {
            response = new ManagerError();
        } else if (attributes.containsKey("challenge")) {
            ChallengeResponse challengeResponse = new ChallengeResponse();
            challengeResponse.setChallenge(attributes.get("challenge"));
            response = challengeResponse;
        } else if (attributes.containsKey("mailbox") && attributes.containsKey("waiting")) {
            MailboxStatusResponse mailboxStatusResponse = new MailboxStatusResponse();
            mailboxStatusResponse.setMailbox(attributes.get("mailbox"));
            if ("1".equals(attributes.get("waiting"))) {
                mailboxStatusResponse.setWaiting(Boolean.TRUE);
            } else {
                mailboxStatusResponse.setWaiting(Boolean.FALSE);
            }
            response = mailboxStatusResponse;
        } else if (attributes.containsKey("mailbox") && attributes.containsKey("newmessages") && attributes.containsKey("oldmessages")) {
            MailboxCountResponse mailboxCountResponse = new MailboxCountResponse();
            mailboxCountResponse.setMailbox(attributes.get("mailbox"));
            mailboxCountResponse.setNewMessages(Integer.valueOf(attributes.get("newmessages")));
            mailboxCountResponse.setOldMessages(Integer.valueOf(attributes.get("oldmessages")));
            response = mailboxCountResponse;
        } else if (attributes.containsKey("exten") && attributes.containsKey("context") && attributes.containsKey("hint") && attributes.containsKey("status")) {
            ExtensionStateResponse extensionStateResponse = new ExtensionStateResponse();
            extensionStateResponse.setExten(attributes.get("exten"));
            extensionStateResponse.setContext(attributes.get("context"));
            extensionStateResponse.setHint(attributes.get("hint"));
            extensionStateResponse.setStatus(Integer.valueOf(attributes.get("status")));
            response = extensionStateResponse;
        } else if (attributes.containsKey("line-000000-000000")) {
            GetConfigResponse getConfigResponse = new GetConfigResponse();
            response = getConfigResponse;
        } else {
            response = new ManagerResponse();
        }
        if (responseType != null) {
            response.setResponse(responseType);
        } else if (proxyResponseType != null) {
            response.setResponse(proxyResponseType);
        }
        response.setAttributes(new HashMap<String, String>(attributes));
        if (attributes.containsKey("actionid")) {
            response.setActionId(attributes.get("actionid"));
        }
        if (attributes.containsKey("message")) {
            response.setMessage(attributes.get("message"));
        }
        if (attributes.containsKey("uniqueid")) {
            response.setUniqueId(attributes.get("uniqueid"));
        }
        return response;
    }
}

