/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.SyncCacheListener;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<K, V> {
    private static final Integer NULL = new Integer(0);
    private CacheItem[] _entries;
    private boolean _isEnableListeners = true;
    private int _capacity;
    private int _capacity1;
    private int _mask;
    private int _size1;
    private CacheItem<K, V> _head1;
    private CacheItem<K, V> _tail1;
    private int _size2;
    private CacheItem<K, V> _head2;
    private CacheItem<K, V> _tail2;
    private volatile long _hitCount;
    private volatile long _missCount;

    public LruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
    }

    public void setEnableListeners(boolean isEnable) {
        this._isEnableListeners = isEnable;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    public int getCapacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        if (this._size1 == 0 && this._size2 == 0) {
            return;
        }
        ArrayList<CacheListener> listeners = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int i2 = this._entries.length - 1; i2 >= 0; --i2) {
                CacheItem item = this._entries[i2];
                this._entries[i2] = null;
                if (!this._isEnableListeners) continue;
                while (item != null) {
                    if (item._value instanceof CacheListener) {
                        if (listeners == null) {
                            listeners = new ArrayList<CacheListener>();
                        }
                        listeners.add((CacheListener)item._value);
                    }
                    item = item._nextHash;
                }
            }
            this._size1 = 0;
            this._head1 = null;
            this._tail1 = null;
            this._size2 = 0;
            this._head2 = null;
            this._tail2 = null;
        }
        int n = i = listeners != null ? listeners.size() - 1 : -1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = okey.hashCode() & this._mask;
        LruCache lruCache = this;
        synchronized (lruCache) {
            CacheItem item = this._entries[hash];
            while (item != null) {
                if (item._key == okey || item._key.equals(okey)) {
                    this.updateLru(item);
                    ++this._hitCount;
                    return item._value;
                }
                item = item._nextHash;
            }
            ++this._missCount;
        }
        return null;
    }

    public V put(K key, V value) {
        V oldValue = this.put(key, value, true);
        if (this._isEnableListeners && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    public V putIfNew(K key, V value) {
        V oldValue = this.put(key, value, false);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(K key, V value, boolean replace) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        while (this._capacity <= this._size1 + this._size2) {
            if (this.removeTail()) continue;
            throw new IllegalStateException("unable to remove tail from cache");
        }
        int hash = okey.hashCode() & this._mask;
        Object oldValue = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            CacheItem item = this._entries[hash];
            while (item != null) {
                if (item._key == okey || okey.equals(item._key)) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (replace) {
                        item._value = value;
                    }
                    if (value != oldValue) break;
                    oldValue = null;
                    break;
                }
                item = item._nextHash;
            }
            if (item == null) {
                CacheItem next = this._entries[hash];
                item = new CacheItem<Object, V>(okey, value);
                item._nextHash = next;
                if (next != null) {
                    next._prevHash = item;
                }
                this._entries[hash] = item;
                ++this._size1;
                item._nextLru = this._head1;
                if (this._head1 != null) {
                    this._head1._prevLru = item;
                } else {
                    this._tail1 = item;
                }
                this._head1 = item;
                return null;
            }
            if (this._isEnableListeners && replace && oldValue instanceof SyncCacheListener) {
                ((SyncCacheListener)oldValue).syncRemoveEvent();
            }
        }
        if (this._isEnableListeners && replace && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    private void updateLru(CacheItem<K, V> item) {
        CacheItem prevLru = item._prevLru;
        CacheItem nextLru = item._nextLru;
        if (item._hitCount++ == 1) {
            if (prevLru != null) {
                prevLru._nextLru = nextLru;
            } else {
                this._head1 = nextLru;
            }
            if (nextLru != null) {
                nextLru._prevLru = prevLru;
            } else {
                this._tail1 = prevLru;
            }
            item._prevLru = null;
            if (this._head2 != null) {
                this._head2._prevLru = item;
            } else {
                this._tail2 = item;
            }
            item._nextLru = this._head2;
            this._head2 = item;
            --this._size1;
            ++this._size2;
        } else {
            if (prevLru == null) {
                return;
            }
            prevLru._nextLru = nextLru;
            item._prevLru = null;
            item._nextLru = this._head2;
            this._head2._prevLru = item;
            this._head2 = item;
            if (nextLru != null) {
                nextLru._prevLru = prevLru;
            } else {
                this._tail2 = prevLru;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTail() {
        CacheItem<K, V> tail;
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (this._capacity1 <= this._size1) {
                tail = this._tail1;
            } else if (this._size2 > 0) {
                tail = this._tail2;
            } else if (this._size1 > 0) {
                tail = this._tail1;
            } else {
                return false;
            }
        }
        this.remove(tail._key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLongestTail() {
        CacheItem<K, V> tail;
        LruCache lruCache = this;
        synchronized (lruCache) {
            tail = this._size1 <= this._size2 ? (this._tail2 != null ? this._tail2 : this._tail1) : (this._tail1 != null ? this._tail1 : this._tail2);
        }
        if (tail == null) {
            return false;
        }
        this.remove(tail._key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = okey.hashCode() & this._mask;
        V value = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            CacheItem item = this._entries[hash];
            while (item != null) {
                if (item._key == okey || item._key.equals(okey)) {
                    CacheItem prevHash = item._prevHash;
                    CacheItem nextHash = item._nextHash;
                    if (prevHash != null) {
                        prevHash._nextHash = nextHash;
                    } else {
                        this._entries[hash] = nextHash;
                    }
                    if (nextHash != null) {
                        nextHash._prevHash = prevHash;
                    }
                    CacheItem prevLru = item._prevLru;
                    CacheItem nextLru = item._nextLru;
                    if (item._hitCount == 1) {
                        --this._size1;
                        if (prevLru != null) {
                            prevLru._nextLru = nextLru;
                        } else {
                            this._head1 = nextLru;
                        }
                        if (nextLru != null) {
                            nextLru._prevLru = prevLru;
                        } else {
                            this._tail1 = prevLru;
                        }
                    } else {
                        --this._size2;
                        if (prevLru != null) {
                            prevLru._nextLru = nextLru;
                        } else {
                            this._head2 = nextLru;
                        }
                        if (nextLru != null) {
                            nextLru._prevLru = prevLru;
                        } else {
                            this._tail2 = prevLru;
                        }
                    }
                    value = item._value;
                    break;
                }
                item = item._nextHash;
            }
            if (this._isEnableListeners && value instanceof SyncCacheListener) {
                ((SyncCacheListener)value).syncRemoveEvent();
            }
        }
        if (this._isEnableListeners && value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    public Iterator<K> keys() {
        KeyIterator iter = new KeyIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<K> keys(Iterator<K> oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator();
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    implements Iterator<Entry<K, V>>,
    Entry<K, V> {
        private int _i = -1;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i - 1;
            return i < length;
        }

        @Override
        public Entry<K, V> next() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i;
            if (this._i < length) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                if (entry == null) {
                    return null;
                }
                if (entry._key == NULL) {
                    return null;
                }
                return entry._key;
            }
            return null;
        }

        @Override
        public V getValue() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                return entry != null ? (Object)entry._value : null;
            }
            return null;
        }

        @Override
        public void remove() {
            CacheItem entry;
            if (this._i < LruCache.this._entries.length && (entry = LruCache.this._entries[this._i]) != null) {
                LruCache.this.remove(entry._key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K, V>
    implements Iterator<V> {
        private LruCache<K, V> _cache;
        private CacheItem<K, V> _item;
        private boolean _isHead1;

        ValueIterator(LruCache<K, V> cache) {
            this.init(cache);
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._item = ((LruCache)this._cache)._head2;
            this._isHead1 = false;
            if (this._item == null) {
                this._item = ((LruCache)this._cache)._head1;
                this._isHead1 = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public V next() {
            CacheItem<K, V> entry = this._item;
            if (this._item != null) {
                this._item = this._item._nextLru;
            }
            if (this._item == null && !this._isHead1) {
                this._isHead1 = true;
                this._item = ((LruCache)this._cache)._head1;
            }
            if (entry != null) {
                return entry._value;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyIterator<K, V>
    implements Iterator<K> {
        private LruCache<K, V> _cache;
        private CacheItem<K, V> _item;
        private boolean _isHead1;

        KeyIterator(LruCache<K, V> cache) {
            this.init(cache);
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._item = ((LruCache)this._cache)._head2;
            this._isHead1 = false;
            if (this._item == null) {
                this._item = ((LruCache)this._cache)._head1;
                this._isHead1 = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public K next() {
            CacheItem<K, V> entry = this._item;
            if (this._item != null) {
                this._item = this._item._nextLru;
            }
            if (this._item == null && !this._isHead1) {
                this._isHead1 = true;
                this._item = ((LruCache)this._cache)._head1;
            }
            if (entry != null) {
                return entry._key;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<K, V> {
        CacheItem<K, V> _prevHash;
        CacheItem<K, V> _nextHash;
        CacheItem<K, V> _prevLru;
        CacheItem<K, V> _nextLru;
        final K _key;
        V _value;
        int _index;
        int _hitCount;

        CacheItem(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            this._key = key;
            this._value = value;
            this._hitCount = 1;
        }
    }
}

