/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class BooleanObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BooleanObjectMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.evalBoolean(env) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        if (value.isNull()) {
            return null;
        }
        return value.toBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return Boolean.TRUE.equals(value) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof BooleanValue) {
            return 100;
        }
        return 301;
    }

    public Class getExpectedClass() {
        return Boolean.class;
    }
}

