/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class CallbackMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CallbackMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        Callback cb = env.createCallback(value);
        if (cb != null) {
            return cb;
        }
        if (value instanceof DefaultValue) {
            return null;
        }
        return new CallbackFunction(env, value.toString());
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException();
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof CallbackFunction) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Callback.class;
    }
}

