/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class DoubleValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new DoubleValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toDoubleValue();
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toDoubleValue();
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof DoubleValue) {
            return (DoubleValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toDoubleValue();
        }
        return null;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof DoubleValue) {
            return 0;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        if (argValue.isDoubleConvertible()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return DoubleValue.class;
    }
}

