/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.FileInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.util.logging.Logger;

public class PopenInput
extends ReadStreamInput
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(FileInput.class.getName());
    private Env _env;
    private Process _process;

    public PopenInput(Env env, Process process) throws IOException {
        super(env);
        this._env = env;
        this._env.addCleanup(this);
        this._process = process;
        this.init(new ReadStream((StreamImpl)new VfsStream(this._process.getInputStream(), null)));
        this._process.getOutputStream().close();
    }

    public BinaryInput openCopy() throws IOException {
        return new PopenInput(this._env, this._process);
    }

    public long getLength() {
        return 0L;
    }

    public String toString() {
        return "PopenInput[" + this._process + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pclose() {
        super.close();
        try {
            int n = this._process.waitFor();
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            this._env.removeCleanup(this);
        }
    }

    public void close() {
        this.pclose();
    }

    public void cleanup() {
        this.pclose();
    }
}

