/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.quercus.lib.file.StreamModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(SocketModule.class);
    private static final Logger log = Logger.getLogger(SocketModule.class.getName());
    private static final int AF_UNIX = 1;
    private static final int AF_INET = 2;
    private static final int AF_INET6 = 10;
    private static final int SOCK_STREAM = 1;
    private static final int SOCK_DGRAM = 2;
    private static final int SOCK_RAW = 3;
    private static final int SOCK_SEQPACKET = 5;
    private static final int SOCK_RDM = 4;
    private static final int MSG_OOB = 1;
    private static final int MSG_WAITALL = 256;
    private static final int MSG_PEEK = 2;
    private static final int MSG_DONTROUTE = 4;
    private static final int SO_DEBUG = 1;
    private static final int SO_REUSEADDR = 2;
    private static final int SO_KEEPALIVE = 9;
    private static final int SO_DONTROUTE = 5;
    private static final int SO_LINGER = 13;
    private static final int SO_BROADCAST = 6;
    private static final int SO_OOBINLINE = 10;
    private static final int SO_SNDBUF = 7;
    private static final int SO_RCVBUF = 8;
    private static final int SO_SNDLOWAT = 19;
    private static final int SO_RCVLOWAT = 18;
    private static final int SO_SNDTIMEO = 21;
    private static final int SO_RCVTIMEO = 20;
    private static final int SO_TYPE = 3;
    private static final int SO_ERROR = 4;
    private static final int SOL_SOCKET = 1;
    private static final int SOMAXCONN = 128;
    private static final int PHP_NORMAL_READ = 1;
    private static final int PHP_BINARY_READ = 2;
    private static final int SOCKET_EPERM = 1;
    private static final int SOCKET_ENOENT = 2;
    private static final int SOCKET_EINTR = 4;
    private static final int SOCKET_EIO = 5;
    private static final int SOCKET_ENXIO = 6;
    private static final int SOCKET_E2BIG = 7;
    private static final int SOCKET_EBADF = 9;
    private static final int SOCKET_EAGAIN = 11;
    private static final int SOCKET_ENOMEM = 12;
    private static final int SOCKET_EACCES = 13;
    private static final int SOCKET_EFAULT = 14;
    private static final int SOCKET_ENOTBLK = 15;
    private static final int SOCKET_EBUSY = 16;
    private static final int SOCKET_EEXIST = 17;
    private static final int SOCKET_EXDEV = 18;
    private static final int SOCKET_ENODEV = 19;
    private static final int SOCKET_ENOTDIR = 20;
    private static final int SOCKET_EISDIR = 21;
    private static final int SOCKET_EINVAL = 22;
    private static final int SOCKET_ENFILE = 23;
    private static final int SOCKET_EMFILE = 24;
    private static final int SOCKET_ENOTTY = 25;
    private static final int SOCKET_ENOSPC = 28;
    private static final int SOCKET_ESPIPE = 29;
    private static final int SOCKET_EROFS = 30;
    private static final int SOCKET_EMLINK = 31;
    private static final int SOCKET_EPIPE = 32;
    private static final int SOCKET_ENAMETOOLONG = 36;
    private static final int SOCKET_ENOLCK = 37;
    private static final int SOCKET_ENOSYS = 38;
    private static final int SOCKET_ENOTEMPTY = 39;
    private static final int SOCKET_ELOOP = 40;
    private static final int SOCKET_EWOULDBLOCK = 11;
    private static final int SOCKET_ENOMSG = 42;
    private static final int SOCKET_EIDRM = 43;
    private static final int SOCKET_ECHRNG = 44;
    private static final int SOCKET_EL2NSYNC = 45;
    private static final int SOCKET_EL3HLT = 46;
    private static final int SOCKET_EL3RST = 47;
    private static final int SOCKET_ELNRNG = 48;
    private static final int SOCKET_EUNATCH = 49;
    private static final int SOCKET_ENOCSI = 50;
    private static final int SOCKET_EL2HLT = 51;
    private static final int SOCKET_EBADE = 52;
    private static final int SOCKET_EBADR = 53;
    private static final int SOCKET_EXFULL = 54;
    private static final int SOCKET_ENOANO = 55;
    private static final int SOCKET_EBADRQC = 56;
    private static final int SOCKET_EBADSLT = 57;
    private static final int SOCKET_ENOSTR = 60;
    private static final int SOCKET_ENODATA = 61;
    private static final int SOCKET_ETIME = 62;
    private static final int SOCKET_ENOSR = 63;
    private static final int SOCKET_ENONET = 64;
    private static final int SOCKET_EREMOTE = 66;
    private static final int SOCKET_ENOLINK = 67;
    private static final int SOCKET_EADV = 68;
    private static final int SOCKET_ESRMNT = 69;
    private static final int SOCKET_ECOMM = 70;
    private static final int SOCKET_EPROTO = 71;
    private static final int SOCKET_EMULTIHOP = 72;
    private static final int SOCKET_EBADMSG = 74;
    private static final int SOCKET_ENOTUNIQ = 76;
    private static final int SOCKET_EBADFD = 77;
    private static final int SOCKET_EREMCHG = 78;
    private static final int SOCKET_ERESTART = 85;
    private static final int SOCKET_ESTRPIPE = 86;
    private static final int SOCKET_EUSERS = 87;
    private static final int SOCKET_ENOTSOCK = 88;
    private static final int SOCKET_EDESTADDRREQ = 89;
    private static final int SOCKET_EMSGSIZE = 90;
    private static final int SOCKET_EPROTOTYPE = 91;
    private static final int SOCKET_ENOPROTOOPT = 92;
    private static final int SOCKET_EPROTONOSUPPORT = 93;
    private static final int SOCKET_ESOCKTNOSUPPORT = 94;
    private static final int SOCKET_EOPNOTSUPP = 95;
    private static final int SOCKET_EPFNOSUPPORT = 96;
    private static final int SOCKET_EAFNOSUPPORT = 97;
    private static final int SOCKET_EADDRINUSE = 98;
    private static final int SOCKET_EADDRNOTAVAIL = 99;
    private static final int SOCKET_ENETDOWN = 100;
    private static final int SOCKET_ENETUNREACH = 101;
    private static final int SOCKET_ENETRESET = 102;
    private static final int SOCKET_ECONNABORTED = 103;
    private static final int SOCKET_ECONNRESET = 104;
    private static final int SOCKET_ENOBUFS = 105;
    private static final int SOCKET_EISCONN = 106;
    private static final int SOCKET_ENOTCONN = 107;
    private static final int SOCKET_ESHUTDOWN = 108;
    private static final int SOCKET_ETOOMANYREFS = 109;
    private static final int SOCKET_ETIMEDOUT = 110;
    private static final int SOCKET_ECONNREFUSED = 111;
    private static final int SOCKET_EHOSTDOWN = 112;
    private static final int SOCKET_EHOSTUNREACH = 113;
    private static final int SOCKET_EALREADY = 114;
    private static final int SOCKET_EINPROGRESS = 115;
    private static final int SOCKET_EISNAM = 120;
    private static final int SOCKET_EREMOTEIO = 121;
    private static final int SOCKET_EDQUOT = 122;
    private static final int SOCKET_ENOMEDIUM = 123;
    private static final int SOCKET_EMEDIUMTYPE = 124;
    private static final int SOL_TCP = 6;
    private static final int SOL_UDP = 17;
    private static final HashMap<String, Value> _constMap = new HashMap();

    @Override
    public Map<String, Value> getConstMap() {
        return _constMap;
    }

    @ReturnNullAsFalse
    public static SocketInputOutput socket_create(Env env, int domain, int type, int protocol) {
        try {
            Object local = null;
            SocketInputOutput.Domain socketDomain = SocketInputOutput.Domain.AF_INET;
            switch (domain) {
                case 2: {
                    socketDomain = SocketInputOutput.Domain.AF_INET;
                    break;
                }
                case 10: {
                    socketDomain = SocketInputOutput.Domain.AF_INET6;
                    break;
                }
                case 1: {
                    env.warning(L.l("Unix sockets not supported"));
                    return null;
                }
                default: {
                    env.warning(L.l("Unknown domain: {0}", (long)domain));
                    return null;
                }
            }
            switch (type) {
                case 1: {
                    return new SocketInputOutput(env, new Socket(), socketDomain);
                }
                case 2: {
                    env.warning(L.l("Datagrams not supported"));
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean socket_bind(Env env, @NotNull SocketInputOutput socket, StringValue address, @Optional(value="0") int port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(address.toString());
            if (addresses == null || addresses.length < 1) {
                return false;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(addresses[0], port);
            socket.bind(socketAddress);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void socket_close(Env env, @NotNull SocketInputOutput socket) {
        socket.close();
    }

    public static boolean socket_connect(Env env, @NotNull SocketInputOutput socket, StringValue address, @Optional int port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(address.toString());
            if (addresses == null || addresses.length < 1) {
                return false;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(addresses[0], port);
            socket.connect(socketAddress);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Value socket_get_status(Env env, BinaryStream stream) {
        return StreamModule.stream_get_meta_data(env, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value socket_read(Env env, @NotNull SocketInputOutput socket, int length, @Optional int type) {
        TempBuffer tempBuffer = null;
        TempCharBuffer tempCharBuffer = null;
        try {
            byte[] buffer;
            if (type == 1) {
                StringValue stringValue = socket.readLine(length);
                return stringValue;
            }
            tempBuffer = TempBuffer.allocate();
            if (length > tempBuffer.getCapacity()) {
                length = tempBuffer.getCapacity();
            }
            if ((length = socket.read(buffer = tempBuffer.getBuffer(), 0, length)) > 0) {
                StringValue sb;
                StringValue stringValue = sb = env.createBinaryBuilder(buffer, 0, length);
                return stringValue;
            }
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        catch (IOException e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            if (tempCharBuffer != null) {
                TempCharBuffer.free(tempCharBuffer);
            }
            if (tempBuffer != null) {
                TempBuffer.free((TempBuffer)tempBuffer);
            }
        }
    }

    public static boolean socket_set_timeout(Env env, @NotNull Value stream, int seconds, @Optional(value="-1") int milliseconds) {
        return StreamModule.stream_set_timeout(env, stream, seconds, milliseconds);
    }

    public static Value socket_write(Env env, @NotNull SocketInputOutput socket, @NotNull InputStream is, @Optional(value="-1") int length) {
        int result;
        if (is == null) {
            return BooleanValue.FALSE;
        }
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        if ((result = socket.write(is, length)) < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(result);
    }

    public boolean socket_shutdown(Env env, @NotNull SocketInputOutput file, int how) {
        if (file == null) {
            return false;
        }
        switch (how) {
            case 0: {
                file.closeRead();
                return true;
            }
            case 1: {
                file.closeWrite();
                return true;
            }
            case 2: {
                file.close();
                return true;
            }
        }
        return false;
    }

    static {
        _constMap.put("AF_UNIX", LongValue.create(1L));
        _constMap.put("AF_INET", LongValue.create(2L));
        _constMap.put("AF_INET6", LongValue.create(10L));
        _constMap.put("SOCK_STREAM", LongValue.create(1L));
        _constMap.put("SOCK_DGRAM", LongValue.create(2L));
        _constMap.put("SOCK_RAW", LongValue.create(3L));
        _constMap.put("SOCK_SEQPACKET", LongValue.create(5L));
        _constMap.put("SOCK_RDM", LongValue.create(4L));
        _constMap.put("MSG_OOB", LongValue.create(1L));
        _constMap.put("MSG_WAITALL", LongValue.create(256L));
        _constMap.put("MSG_PEEK", LongValue.create(2L));
        _constMap.put("MSG_DONTROUTE", LongValue.create(4L));
        _constMap.put("SO_DEBUG", LongValue.create(1L));
        _constMap.put("SO_REUSEADDR", LongValue.create(2L));
        _constMap.put("SO_KEEPALIVE", LongValue.create(9L));
        _constMap.put("SO_DONTROUTE", LongValue.create(5L));
        _constMap.put("SO_LINGER", LongValue.create(13L));
        _constMap.put("SO_BROADCAST", LongValue.create(6L));
        _constMap.put("SO_OOBINLINE", LongValue.create(10L));
        _constMap.put("SO_SNDBUF", LongValue.create(7L));
        _constMap.put("SO_RCVBUF", LongValue.create(8L));
        _constMap.put("SO_SNDLOWAT", LongValue.create(19L));
        _constMap.put("SO_RCVLOWAT", LongValue.create(18L));
        _constMap.put("SO_SNDTIMEO", LongValue.create(21L));
        _constMap.put("SO_RCVTIMEO", LongValue.create(20L));
        _constMap.put("SO_TYPE", LongValue.create(3L));
        _constMap.put("SO_ERROR", LongValue.create(4L));
        _constMap.put("SOL_SOCKET", LongValue.create(1L));
        _constMap.put("SOMAXCONN", LongValue.create(128L));
        _constMap.put("PHP_NORMAL_READ", LongValue.create(1L));
        _constMap.put("PHP_BINARY_READ", LongValue.create(2L));
        _constMap.put("SOCKET_EPERM", LongValue.create(1L));
        _constMap.put("SOCKET_ENOENT", LongValue.create(2L));
        _constMap.put("SOCKET_EINTR", LongValue.create(4L));
        _constMap.put("SOCKET_EIO", LongValue.create(5L));
        _constMap.put("SOCKET_ENXIO", LongValue.create(6L));
        _constMap.put("SOCKET_E2BIG", LongValue.create(7L));
        _constMap.put("SOCKET_EBADF", LongValue.create(9L));
        _constMap.put("SOCKET_EAGAIN", LongValue.create(11L));
        _constMap.put("SOCKET_ENOMEM", LongValue.create(12L));
        _constMap.put("SOCKET_EACCES", LongValue.create(13L));
        _constMap.put("SOCKET_EFAULT", LongValue.create(14L));
        _constMap.put("SOCKET_ENOTBLK", LongValue.create(15L));
        _constMap.put("SOCKET_EBUSY", LongValue.create(16L));
        _constMap.put("SOCKET_EEXIST", LongValue.create(17L));
        _constMap.put("SOCKET_EXDEV", LongValue.create(18L));
        _constMap.put("SOCKET_ENODEV", LongValue.create(19L));
        _constMap.put("SOCKET_ENOTDIR", LongValue.create(20L));
        _constMap.put("SOCKET_EISDIR", LongValue.create(21L));
        _constMap.put("SOCKET_EINVAL", LongValue.create(22L));
        _constMap.put("SOCKET_ENFILE", LongValue.create(23L));
        _constMap.put("SOCKET_EMFILE", LongValue.create(24L));
        _constMap.put("SOCKET_ENOTTY", LongValue.create(25L));
        _constMap.put("SOCKET_ENOSPC", LongValue.create(28L));
        _constMap.put("SOCKET_ESPIPE", LongValue.create(29L));
        _constMap.put("SOCKET_EROFS", LongValue.create(30L));
        _constMap.put("SOCKET_EMLINK", LongValue.create(31L));
        _constMap.put("SOCKET_EPIPE", LongValue.create(32L));
        _constMap.put("SOCKET_ENAMETOOLONG", LongValue.create(36L));
        _constMap.put("SOCKET_ENOLCK", LongValue.create(37L));
        _constMap.put("SOCKET_ENOSYS", LongValue.create(38L));
        _constMap.put("SOCKET_ENOTEMPTY", LongValue.create(39L));
        _constMap.put("SOCKET_ELOOP", LongValue.create(40L));
        _constMap.put("SOCKET_EWOULDBLOCK", LongValue.create(11L));
        _constMap.put("SOCKET_ENOMSG", LongValue.create(42L));
        _constMap.put("SOCKET_EIDRM", LongValue.create(43L));
        _constMap.put("SOCKET_ECHRNG", LongValue.create(44L));
        _constMap.put("SOCKET_EL2NSYNC", LongValue.create(45L));
        _constMap.put("SOCKET_EL3HLT", LongValue.create(46L));
        _constMap.put("SOCKET_EL3RST", LongValue.create(47L));
        _constMap.put("SOCKET_ELNRNG", LongValue.create(48L));
        _constMap.put("SOCKET_EUNATCH", LongValue.create(49L));
        _constMap.put("SOCKET_ENOCSI", LongValue.create(50L));
        _constMap.put("SOCKET_EL2HLT", LongValue.create(51L));
        _constMap.put("SOCKET_EBADE", LongValue.create(52L));
        _constMap.put("SOCKET_EBADR", LongValue.create(53L));
        _constMap.put("SOCKET_EXFULL", LongValue.create(54L));
        _constMap.put("SOCKET_ENOANO", LongValue.create(55L));
        _constMap.put("SOCKET_EBADRQC", LongValue.create(56L));
        _constMap.put("SOCKET_EBADSLT", LongValue.create(57L));
        _constMap.put("SOCKET_ENOSTR", LongValue.create(60L));
        _constMap.put("SOCKET_ENODATA", LongValue.create(61L));
        _constMap.put("SOCKET_ETIME", LongValue.create(62L));
        _constMap.put("SOCKET_ENOSR", LongValue.create(63L));
        _constMap.put("SOCKET_ENONET", LongValue.create(64L));
        _constMap.put("SOCKET_EREMOTE", LongValue.create(66L));
        _constMap.put("SOCKET_ENOLINK", LongValue.create(67L));
        _constMap.put("SOCKET_EADV", LongValue.create(68L));
        _constMap.put("SOCKET_ESRMNT", LongValue.create(69L));
        _constMap.put("SOCKET_ECOMM", LongValue.create(70L));
        _constMap.put("SOCKET_EPROTO", LongValue.create(71L));
        _constMap.put("SOCKET_EMULTIHOP", LongValue.create(72L));
        _constMap.put("SOCKET_EBADMSG", LongValue.create(74L));
        _constMap.put("SOCKET_ENOTUNIQ", LongValue.create(76L));
        _constMap.put("SOCKET_EBADFD", LongValue.create(77L));
        _constMap.put("SOCKET_EREMCHG", LongValue.create(78L));
        _constMap.put("SOCKET_ERESTART", LongValue.create(85L));
        _constMap.put("SOCKET_ESTRPIPE", LongValue.create(86L));
        _constMap.put("SOCKET_EUSERS", LongValue.create(87L));
        _constMap.put("SOCKET_ENOTSOCK", LongValue.create(88L));
        _constMap.put("SOCKET_EDESTADDRREQ", LongValue.create(89L));
        _constMap.put("SOCKET_EMSGSIZE", LongValue.create(90L));
        _constMap.put("SOCKET_EPROTOTYPE", LongValue.create(91L));
        _constMap.put("SOCKET_ENOPROTOOPT", LongValue.create(92L));
        _constMap.put("SOCKET_EPROTONOSUPPORT", LongValue.create(93L));
        _constMap.put("SOCKET_ESOCKTNOSUPPORT", LongValue.create(94L));
        _constMap.put("SOCKET_EOPNOTSUPP", LongValue.create(95L));
        _constMap.put("SOCKET_EPFNOSUPPORT", LongValue.create(96L));
        _constMap.put("SOCKET_EAFNOSUPPORT", LongValue.create(97L));
        _constMap.put("SOCKET_EADDRINUSE", LongValue.create(98L));
        _constMap.put("SOCKET_EADDRNOTAVAIL", LongValue.create(99L));
        _constMap.put("SOCKET_ENETDOWN", LongValue.create(100L));
        _constMap.put("SOCKET_ENETUNREACH", LongValue.create(101L));
        _constMap.put("SOCKET_ENETRESET", LongValue.create(102L));
        _constMap.put("SOCKET_ECONNABORTED", LongValue.create(103L));
        _constMap.put("SOCKET_ECONNRESET", LongValue.create(104L));
        _constMap.put("SOCKET_ENOBUFS", LongValue.create(105L));
        _constMap.put("SOCKET_EISCONN", LongValue.create(106L));
        _constMap.put("SOCKET_ENOTCONN", LongValue.create(107L));
        _constMap.put("SOCKET_ESHUTDOWN", LongValue.create(108L));
        _constMap.put("SOCKET_ETOOMANYREFS", LongValue.create(109L));
        _constMap.put("SOCKET_ETIMEDOUT", LongValue.create(110L));
        _constMap.put("SOCKET_ECONNREFUSED", LongValue.create(111L));
        _constMap.put("SOCKET_EHOSTDOWN", LongValue.create(112L));
        _constMap.put("SOCKET_EHOSTUNREACH", LongValue.create(113L));
        _constMap.put("SOCKET_EALREADY", LongValue.create(114L));
        _constMap.put("SOCKET_EINPROGRESS", LongValue.create(115L));
        _constMap.put("SOCKET_EISNAM", LongValue.create(120L));
        _constMap.put("SOCKET_EREMOTEIO", LongValue.create(121L));
        _constMap.put("SOCKET_EDQUOT", LongValue.create(122L));
        _constMap.put("SOCKET_ENOMEDIUM", LongValue.create(123L));
        _constMap.put("SOCKET_EMEDIUMTYPE", LongValue.create(124L));
        _constMap.put("SOL_TCP", LongValue.create(6L));
        _constMap.put("SOL_UDP", LongValue.create(17L));
    }
}

