/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.reflection.ReflectionException;
import com.caucho.quercus.lib.reflection.ReflectionExtension;
import com.caucho.quercus.lib.reflection.ReflectionMethod;
import com.caucho.quercus.lib.reflection.ReflectionProperty;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ReflectionClass
implements Reflector {
    private static final L10N L = new L10N(ReflectionClass.class);
    public static int IS_IMPLICIT_ABSTRACT = 16;
    public static int IS_EXPLICIT_ABSTRACT = 32;
    public static int IS_FINAL = 64;
    public String _name;
    private QuercusClass _cls;

    protected ReflectionClass(QuercusClass cls) {
        this._cls = cls;
        this._name = cls.getName();
    }

    protected ReflectionClass(Env env, String name) {
        this._cls = env.findClass(name);
        this._name = name;
    }

    protected QuercusClass getQuercusClass() {
        return this._cls;
    }

    private final ReflectionClass __clone() {
        return new ReflectionClass(this._cls);
    }

    public static ReflectionClass __construct(Env env, Value obj) {
        QuercusClass cls = obj.isObject() ? ((ObjectValue)obj.toValue()).getQuercusClass() : env.findClass(obj.toString());
        return new ReflectionClass(cls);
    }

    public static String export(Env env, Value cls, @Optional boolean isReturn) {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public boolean isInternal() {
        throw new UnimplementedException("ReflectionClass->isInternal()");
    }

    public boolean isUserDefined() {
        throw new UnimplementedException("ReflectionClass->isUserDefined()");
    }

    public boolean isInstantiable() {
        return !this._cls.isInterface();
    }

    public boolean hasConstant(String name) {
        return this._cls.hasConstant(name);
    }

    public String getFileName() {
        return null;
    }

    public int getStartLine() {
        return -1;
    }

    public int getEndLine() {
        return -1;
    }

    public String getDocComment() {
        return null;
    }

    public ReflectionMethod getConstructor() {
        AbstractFunction cons = this._cls.getConstructor();
        if (cons != null) {
            return new ReflectionMethod(this._name, cons);
        }
        return null;
    }

    public boolean hasMethod(String name) {
        MethodMap<AbstractFunction> map = this._cls.getMethodMap();
        return map.get(name) != null;
    }

    public ReflectionMethod getMethod(String name) {
        return new ReflectionMethod(this._name, this._cls.getFunction(name));
    }

    public ArrayValue getMethods(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        MethodMap<AbstractFunction> map = this._cls.getMethodMap();
        for (AbstractFunction method : map.values()) {
            ((ArrayValue)array).put(env.wrapJava(new ReflectionMethod(method)));
        }
        return array;
    }

    public boolean hasProperty(StringValue name) {
        return this._cls.findFieldIndex(name) >= 0;
    }

    public ReflectionProperty getProperty(Env env, StringValue name) {
        return new ReflectionProperty(env, this._cls, name);
    }

    public ArrayValue getProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        ArrayList<StringValue> list = this._cls.getFieldNames();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((ArrayValue)array).put(env.wrapJava(new ReflectionProperty(env, this._cls, list.get(i))));
        }
        return array;
    }

    public ArrayValue getConstants(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<String, Expr> _constMap = this._cls.getConstantMap();
        for (Map.Entry<String, Expr> entry : _constMap.entrySet()) {
            Value name = StringValue.create(entry.getKey());
            array.put(name, entry.getValue().eval(env));
        }
        return array;
    }

    public Value getConstant(Env env, String name) {
        if (this.hasConstant(name)) {
            return this._cls.getConstant(env, name);
        }
        return BooleanValue.FALSE;
    }

    public ArrayValue getInterfaces(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.findInterfaces(env, (ArrayValue)array, this._cls);
        return array;
    }

    private void findInterfaces(Env env, ArrayValue array, QuercusClass cls) {
        if (cls.isInterface()) {
            array.put(StringValue.create(cls.getName()), env.wrapJava(new ReflectionClass(cls)));
        } else {
            ClassDef[] defList = cls.getClassDefList();
            for (int i = 0; i < defList.length; ++i) {
                this.findInterfaces(env, array, defList[i]);
            }
        }
    }

    private void findInterfaces(Env env, ArrayValue array, ClassDef def) {
        String name = def.getName();
        if (def.isInterface()) {
            this.addInterface(env, array, name);
        } else {
            String[] defList = def.getInterfaces();
            for (int i = 0; i < defList.length; ++i) {
                QuercusClass cls = env.findClass(defList[i]);
                this.findInterfaces(env, array, cls);
            }
        }
    }

    private void addInterface(Env env, ArrayValue array, String name) {
        QuercusClass cls = env.findClass(name);
        array.put(StringValue.create(name), env.wrapJava(new ReflectionClass(cls)));
    }

    public boolean isInterface() {
        return this._cls.isInterface();
    }

    public boolean isAbstract() {
        return this._cls.isAbstract();
    }

    public boolean isFinal() {
        return this._cls.isFinal();
    }

    public int getModifiers() {
        int flag = 0;
        if (this.isFinal()) {
            flag |= IS_FINAL;
        }
        return flag;
    }

    public boolean isInstance(ObjectValue obj) {
        return obj.getQuercusClass().getName().equals(this._name);
    }

    public Value newInstance(Env env, @Optional Value[] args) {
        return this._cls.callNew(env, args);
    }

    public Value newInstanceArgs(Env env, @Optional ArrayValue args) {
        if (args == null) {
            return this._cls.callNew(env, new Value[0]);
        }
        return this._cls.callNew(env, args.getValueArray(env));
    }

    @ReturnNullAsFalse
    public ReflectionClass getParentClass() {
        QuercusClass parent = this._cls.getParent();
        if (parent == null) {
            return null;
        }
        return new ReflectionClass(parent);
    }

    public boolean isSubclassOf(ReflectionClass cls) {
        if (this._cls.getName().equals(cls.getName())) {
            return false;
        }
        return this._cls.isA(cls.getName());
    }

    public ArrayValue getStaticProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.addStaticFields(env, array, this._cls);
        return array;
    }

    private void addStaticFields(Env env, ArrayValue array, QuercusClass cls) {
        if (cls == null) {
            return;
        }
        HashMap<String, Value> fieldMap = cls.getStaticFieldMap();
        if (fieldMap != null) {
            for (Map.Entry<String, Value> entry : fieldMap.entrySet()) {
                String name = entry.getKey();
                Var field = cls.getStaticField(env, name);
                array.put(StringValue.create(name), field.toValue());
            }
        }
        this.addStaticFields(env, array, cls.getParent());
    }

    public Value getStaticPropertyValue(Env env, String name, @Optional Value defaultV) {
        Var field = this._cls.getStaticField(env, name);
        if (field == null) {
            if (!defaultV.isDefault()) {
                return defaultV;
            }
            throw new ReflectionException(L.l("Class '{0}' does not have property named '{1}'", (Object)this._name, (Object)name));
        }
        return field.toValue();
    }

    public void setStaticPropertyValue(Env env, String name, Value value) {
        this._cls.getStaticField(env, name).set(value);
    }

    public ArrayValue getDefaultProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.addStaticFields(env, array, this._cls);
        HashMap<StringValue, Expr> fieldMap = this._cls.getClassVars();
        for (Map.Entry<StringValue, Expr> entry : fieldMap.entrySet()) {
            array.put(entry.getKey(), entry.getValue().eval(env));
        }
        return array;
    }

    public boolean isIterateable() {
        return this._cls.getTraversableDelegate() != null;
    }

    public boolean implementsInterface(Env env, String name) {
        return this._cls.implementsInterface(env, name);
    }

    public ReflectionExtension getExtension(Env env) {
        String extName = this.getExtensionName();
        if (extName != null) {
            return new ReflectionExtension(env, extName);
        }
        return null;
    }

    public String getExtensionName() {
        return this._cls.getExtension();
    }

    public String toString() {
        return "ReflectionClass[" + this._name + "]";
    }
}

