/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

final class Init {
    Init() {
    }

    static final void init() {
    }

    private static final void load() {
        String libName = Platform.getPlatform().getStubLibraryName();
        String bootPath = System.getProperty("jffi.boot.library.path");
        if (bootPath != null) {
            String[] dirs = bootPath.split(File.pathSeparator);
            for (int i = 0; i < dirs.length; ++i) {
                String path2 = new File(new File(dirs[i]), System.mapLibraryName(libName)).getAbsolutePath();
                try {
                    System.load(path2);
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    String ext2;
                    String orig;
                    if (Platform.getPlatform().getOS() != Platform.OS.DARWIN) continue;
                    if (path2.endsWith("dylib")) {
                        orig = "dylib";
                        ext2 = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext2 = "dylib";
                    }
                    try {
                        System.load(path2.substring(0, path2.lastIndexOf(orig)) + ext2);
                        return;
                    }
                    catch (UnsatisfiedLinkError ex2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            System.loadLibrary(libName);
            return;
        }
        catch (UnsatisfiedLinkError ex) {
            InputStream is = Platform.getPlatform().getStubLibraryStream();
            if (is == null) {
                throw new UnsatisfiedLinkError("Could not locate " + libName + " in jar file");
            }
            File dstFile = null;
            try {
                dstFile = File.createTempFile(libName, null);
                dstFile.deleteOnExit();
                FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
                ReadableByteChannel srcChannel = Channels.newChannel(is);
                long pos2 = 0L;
                while (is.available() > 0) {
                    pos2 += dstChannel.transferFrom(srcChannel, pos2, Math.max(4096, is.available()));
                }
                dstChannel.close();
                System.load(dstFile.getAbsolutePath());
            }
            catch (IOException ex3) {
                throw new UnsatisfiedLinkError(ex3.getMessage());
            }
            return;
        }
    }

    static {
        Init.load();
    }
}

