/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

public class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final String iResourcePath;
    private final ClassLoader iLoader;
    private final Map iZoneInfoMap;

    public ZoneInfoProvider(File file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!file2.exists()) {
            throw new IOException("File directory doesn't exist: " + file2);
        }
        if (!file2.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + file2);
        }
        this.iFileDir = file2;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public ZoneInfoProvider(String string2) throws IOException {
        this(string2, null, false);
    }

    public ZoneInfoProvider(String string2, ClassLoader classLoader) throws IOException {
        this(string2, classLoader, true);
    }

    private ZoneInfoProvider(String string2, ClassLoader classLoader, boolean bl) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        this.iFileDir = null;
        this.iResourcePath = string2;
        if (classLoader == null && !bl) {
            classLoader = this.getClass().getClassLoader();
        }
        this.iLoader = classLoader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public synchronized DateTimeZone getZone(String string2) {
        if (string2 == null) {
            return null;
        }
        Object v = this.iZoneInfoMap.get(string2);
        if (v == null) {
            return null;
        }
        if (string2.equals(v)) {
            return this.loadZoneData(string2);
        }
        if (v instanceof SoftReference) {
            DateTimeZone dateTimeZone = (DateTimeZone)((SoftReference)v).get();
            if (dateTimeZone != null) {
                return dateTimeZone;
            }
            return this.loadZoneData(string2);
        }
        return this.getZone((String)v);
    }

    public synchronized Set getAvailableIDs() {
        return new TreeSet(this.iZoneInfoMap.keySet());
    }

    protected void uncaughtException(Exception exception2) {
        Thread thread = Thread.currentThread();
        thread.getThreadGroup().uncaughtException(thread, exception2);
    }

    private InputStream openResource(String string2) throws IOException {
        InputStream inputStream;
        if (this.iFileDir != null) {
            inputStream = new FileInputStream(new File(this.iFileDir, string2));
        } else {
            String string3 = this.iResourcePath.concat(string2);
            inputStream = this.iLoader != null ? this.iLoader.getResourceAsStream(string3) : ClassLoader.getSystemResourceAsStream(string3);
            if (inputStream == null) {
                StringBuffer stringBuffer = new StringBuffer(40).append("Resource not found: \"").append(string3).append("\" ClassLoader: ").append(this.iLoader != null ? this.iLoader.toString() : "system");
                throw new IOException(stringBuffer.toString());
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DateTimeZone loadZoneData(String string2) {
        DateTimeZone dateTimeZone2;
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.openResource(string2);
                DateTimeZone dateTimeZone = DateTimeZoneBuilder.readFrom(inputStream, string2);
                this.iZoneInfoMap.put(string2, new SoftReference<DateTimeZone>(dateTimeZone));
                dateTimeZone2 = dateTimeZone;
                Object var6_7 = null;
            }
            catch (IOException iOException) {
                this.uncaughtException(iOException);
                this.iZoneInfoMap.remove(string2);
                DateTimeZone dateTimeZone3 = null;
                Object var6_8 = null;
                try {
                    if (inputStream == null) return dateTimeZone3;
                    inputStream.close();
                    return dateTimeZone3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return dateTimeZone3;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return dateTimeZone2;
        }
        if (inputStream == null) return dateTimeZone2;
        inputStream.close();
        return dateTimeZone2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadZoneInfoMap(InputStream inputStream) throws IOException {
        TreeMap<String, SoftReference<DateTimeZone>> treeMap = new TreeMap<String, SoftReference<DateTimeZone>>(String.CASE_INSENSITIVE_ORDER);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            ZoneInfoProvider.readZoneInfoMap(dataInputStream, treeMap);
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        treeMap.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return treeMap;
    }

    private static void readZoneInfoMap(DataInputStream dataInputStream, Map map) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = dataInputStream.readUTF().intern();
        }
        n2 = dataInputStream.readUnsignedShort();
        for (n = 0; n < n2; ++n) {
            try {
                map.put(stringArray[dataInputStream.readUnsignedShort()], stringArray[dataInputStream.readUnsignedShort()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }
}

