/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.CallbackMarshaller;
import org.jruby.ext.ffi.jna.FunctionInvoker;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.JNAInvoker;
import org.jruby.ext.ffi.jna.Marshaller;
import org.jruby.ext.ffi.jna.NativeMemoryIO;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class JNAProvider
extends FFIProvider {
    JNAProvider(Ruby runtime2) {
        super(runtime2);
    }

    public final AbstractInvoker createInvoker(Ruby runtime2, String libraryName, String functionName, NativeType returnType, NativeParam[] parameterTypes, String convention) {
        int conv2;
        int n = conv2 = "stdcall".equals(convention) ? 1 : 0;
        if (libraryName == null) {
            libraryName = Platform.LIBC;
        }
        Function function = NativeLibrary.getInstance(libraryName).getFunction(functionName, conv2);
        FunctionInvoker functionInvoker = JNAProvider.getFunctionInvoker(returnType);
        Marshaller[] marshallers = new Marshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = JNAProvider.getMarshaller(parameterTypes[i], conv2);
        }
        return new JNAInvoker(runtime2, FFIProvider.getModule(runtime2).fastGetClass("Invoker"), function, functionInvoker, marshallers);
    }

    public int getLastError() {
        return Native.getLastError();
    }

    public void setLastError(int error) {
        Native.setLastError(error);
    }

    static FunctionInvoker getFunctionInvoker(NativeType returnType) {
        switch (returnType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case POINTER: {
                return PointerInvoker.INSTANCE;
            }
            case INT8: {
                return Signed8Invoker.INSTANCE;
            }
            case INT16: {
                return Signed16Invoker.INSTANCE;
            }
            case INT32: {
                return Signed32Invoker.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Invoker.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Invoker.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Invoker.INSTANCE;
            }
            case INT64: {
                return Signed64Invoker.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().addressSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().addressSize() == 32 ? Unsigned32Invoker.INSTANCE : Unsigned64Invoker.INSTANCE;
            }
            case FLOAT32: {
                return Float32Invoker.INSTANCE;
            }
            case FLOAT64: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: 
            case RBXSTRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + returnType);
    }

    static final Marshaller getMarshaller(NativeParam type2, int convention) {
        if (type2 instanceof NativeType) {
            return JNAProvider.getMarshaller((NativeType)type2);
        }
        if (type2 instanceof CallbackInfo) {
            return new CallbackMarshaller((CallbackInfo)type2, convention);
        }
        return null;
    }

    static final Marshaller getMarshaller(NativeType type2) {
        switch (type2) {
            case INT8: {
                return Signed8Marshaller.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case INT16: {
                return Signed16Marshaller.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT32: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case INT64: {
                return Signed64Marshaller.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case FLOAT32: {
                return Float32Marshaller.INSTANCE;
            }
            case FLOAT64: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
            case RBXSTRING: {
                return RbxStringMarshaller.INSTANCE;
            }
            case POINTER: {
                return PointerMarshaller.INSTANCE;
            }
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return BufferMarshaller.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + type2);
    }

    private static final Object getNativeMemory(Pointer memory) {
        MemoryIO io2 = memory.getMemoryIO();
        return io2 instanceof NativeMemoryIO ? ((NativeMemoryIO)io2).getPointer() : null;
    }

    private static final Object getNativeMemory(Ruby runtime2, IRubyObject memory) {
        if (memory instanceof Pointer) {
            return JNAProvider.getNativeMemory((Pointer)memory);
        }
        if (memory instanceof Buffer) {
            ArrayMemoryIO io2 = (ArrayMemoryIO)((Buffer)memory).getMemoryIO();
            return ByteBuffer.wrap(io2.array(), io2.arrayOffset(), io2.arrayLength());
        }
        if (memory == null || memory.isNil()) {
            return com.sun.jna.Pointer.NULL;
        }
        throw runtime2.newArgumentError("Invalid memory object");
    }

    private static final class BufferMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new BufferMarshaller();

        private BufferMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            if (parameter instanceof Pointer) {
                return JNAProvider.getNativeMemory((Pointer)parameter);
            }
            if (parameter instanceof Buffer) {
                ArrayMemoryIO io2 = (ArrayMemoryIO)((Buffer)parameter).getMemoryIO();
                return ByteBuffer.wrap(io2.array(), io2.arrayOffset(), io2.arrayLength());
            }
            if (parameter instanceof Struct) {
                return JNAProvider.getNativeMemory(invocation.getThreadContext().getRuntime(), ((Struct)parameter).getMemory());
            }
            if (parameter.isNil()) {
                return com.sun.jna.Pointer.NULL;
            }
            if (parameter instanceof RubyString) {
                ByteList bl = ((RubyString)parameter).getByteList();
                return ByteBuffer.wrap(bl.unsafeBytes(), bl.begin(), bl.realSize);
            }
            if (parameter.respondsTo("to_ptr")) {
                return JNAProvider.getNativeMemory(invocation.getThreadContext().getRuntime(), parameter.callMethod(invocation.getThreadContext(), "to_ptr"));
            }
            throw invocation.getThreadContext().getRuntime().newArgumentError("Invalid Buffer argument");
        }
    }

    private static final class RbxStringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new RbxStringMarshaller();

        private RbxStringMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            final ByteList bl = parameter.asString().getByteList();
            final int strlen = bl.length();
            final Memory memory = new Memory(strlen + 1);
            memory.write(0L, bl.unsafeBytes(), bl.begin(), strlen);
            memory.setByte(bl.length(), (byte)0);
            invocation.addPostInvoke(new Runnable(){

                public void run() {
                    memory.read(0L, bl.unsafeBytes(), bl.begin(), strlen);
                }
            });
            return memory;
        }
    }

    private static final class StringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            if (parameter instanceof RubyString) {
                Util.checkStringSafety(invocation.getThreadContext().getRuntime(), parameter);
                RubyString s = parameter.asString();
                ByteList bl = s.getByteList();
                Memory memory = new Memory(bl.length() + 1);
                memory.write(0L, bl.unsafeBytes(), bl.begin(), bl.length());
                memory.setByte(bl.length(), (byte)0);
                return memory;
            }
            if (parameter.isNil()) {
                return null;
            }
            throw invocation.getThreadContext().getRuntime().newArgumentError("Invalid string parameter");
        }
    }

    static final class PointerMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new PointerMarshaller();

        PointerMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            if (parameter instanceof Pointer) {
                return JNAProvider.getNativeMemory((Pointer)parameter);
            }
            if (parameter instanceof Buffer) {
                ArrayMemoryIO io2 = (ArrayMemoryIO)((Buffer)parameter).getMemoryIO();
                return ByteBuffer.wrap(io2.array(), io2.arrayOffset(), io2.arrayLength());
            }
            if (parameter instanceof Struct) {
                return JNAProvider.getNativeMemory(invocation.getThreadContext().getRuntime(), ((Struct)parameter).getMemory());
            }
            if (parameter.isNil()) {
                return com.sun.jna.Pointer.NULL;
            }
            if (parameter instanceof RubyString) {
                final ByteList bl = ((RubyString)parameter).getByteList();
                final int len = bl.length();
                final Memory memory = new Memory(len);
                memory.write(0L, bl.unsafeBytes(), bl.begin(), len);
                invocation.addPostInvoke(new Runnable(){

                    public void run() {
                        memory.read(0L, bl.unsafeBytes(), bl.begin(), len);
                    }
                });
                return memory;
            }
            if (parameter.respondsTo("to_ptr")) {
                return JNAProvider.getNativeMemory(invocation.getThreadContext().getRuntime(), parameter.callMethod(invocation.getThreadContext(), "to_ptr"));
            }
            throw invocation.getThreadContext().getRuntime().newArgumentError("Invalid Pointer argument");
        }
    }

    static final class Float64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.doubleValue(parameter);
        }
    }

    static final class Float32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Float.valueOf(Util.floatValue(parameter));
        }
    }

    static final class Unsigned64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned64Marshaller();

        Unsigned64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.uint64Value(parameter);
        }
    }

    static final class Signed64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed64Marshaller();

        Signed64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int64Value(parameter);
        }
    }

    static final class Unsigned32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned32Marshaller();

        Unsigned32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (int)Util.uint32Value(parameter);
        }
    }

    static final class Signed32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed32Marshaller();

        Signed32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int32Value(parameter);
        }
    }

    static final class Unsigned16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned16Marshaller();

        Unsigned16Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (short)Util.uint16Value(parameter);
        }
    }

    static final class Signed16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed16Marshaller();

        Signed16Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int16Value(parameter);
        }
    }

    static final class Unsigned8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned8Marshaller();

        Unsigned8Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (byte)Util.uint8Value(parameter);
        }
    }

    static final class Signed8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed8Marshaller();

        Signed8Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int8Value(parameter);
        }
    }

    private static final class StringInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            com.sun.jna.Pointer address2 = function.invokePointer(args2);
            if (address2 == null) {
                return runtime2.getNil();
            }
            int len = (int)address2.indexOf(0L, (byte)0);
            if (len == 0) {
                return RubyString.newEmptyString(runtime2);
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            address2.read(0L, bl.unsafeBytes(), bl.begin(), len);
            RubyString s = RubyString.newString(runtime2, bl);
            s.setTaint(true);
            return s;
        }
    }

    private static final class PointerInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new PointerInvoker();

        private PointerInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            com.sun.jna.Pointer ptr = function.invokePointer(args2);
            return new BasePointer(runtime2, ptr != null ? new NativeMemoryIO(ptr) : new NullMemoryIO(runtime2));
        }
    }

    private static final class Float64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return runtime2.newFloat(function.invokeDouble(args2));
        }
    }

    private static final class Float32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return runtime2.newFloat(function.invokeFloat(args2));
        }
    }

    private static final class Unsigned64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned64Invoker();

        private Unsigned64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newUnsigned64(runtime2, function.invokeLong(args2));
        }
    }

    private static final class Signed64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newSigned64(runtime2, function.invokeLong(args2));
        }
    }

    private static final class Unsigned32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newUnsigned32(runtime2, function.invokeInt(args2));
        }
    }

    private static final class Signed32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newSigned32(runtime2, function.invokeInt(args2));
        }
    }

    private static final class Unsigned16Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned16Invoker();

        private Unsigned16Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newUnsigned16(runtime2, function.invokeInt(args2));
        }
    }

    private static final class Signed16Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed16Invoker();

        private Signed16Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newSigned16(runtime2, function.invokeInt(args2));
        }
    }

    private static final class Unsigned8Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned8Invoker();

        private Unsigned8Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newUnsigned8(runtime2, function.invokeInt(args2));
        }
    }

    private static final class Signed8Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed8Invoker();

        private Signed8Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            return Util.newSigned8(runtime2, function.invokeInt(args2));
        }
    }

    private static final class VoidInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, Object[] args2) {
            function.invoke(args2);
            return runtime2.getNil();
        }
    }
}

