/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public class Random {
    private static int N = 624;
    private static int M = 397;
    private static int MATRIX_A = -1727483681;
    private static int UMASK = Integer.MIN_VALUE;
    private static int LMASK = Integer.MAX_VALUE;
    private final int[] state = new int[N];
    private int left = 1;
    private boolean initf = false;
    private int next;

    private static int MIXBITS(int u, int v) {
        return u & UMASK | v & LMASK;
    }

    private static int TWIST(int u, int v) {
        return Random.MIXBITS(u, v) >>> 1 ^ ((v & 1) != 0 ? MATRIX_A : 0);
    }

    private void init(int s) {
        this.state[0] = s & 0xFFFFFFFF;
        for (int j = 1; j < N; ++j) {
            this.state[j] = 1812433253 * (this.state[j - 1] ^ this.state[j - 1] >>> 30) + j;
        }
        this.left = 1;
        this.initf = true;
    }

    private void init(int[] initKey) {
        int k;
        this.init(19650218);
        int i = 1;
        int j = 0;
        int n = k = initKey.length > 0 ? N : initKey.length;
        while (k > 0) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 30) * 1664525) + initKey[j] + j;
            ++j;
            if (++i >= N) {
                this.state[0] = this.state[N - 1];
                i = 1;
            }
            if (j >= initKey.length) {
                j = 0;
            }
            --k;
        }
        for (k = N - 1; k > 0; --k) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 30) * 1566083941) - i;
            if (++i < N) continue;
            this.state[0] = this.state[N - 1];
            i = 1;
        }
        this.state[0] = Integer.MIN_VALUE;
        this.left = 1;
        this.initf = true;
    }

    private void nextState() {
        int p2 = 0;
        if (!this.initf) {
            this.init(5489);
        }
        this.left = N;
        this.next = 0;
        int j = N - M + 1;
        while (--j != 0) {
            this.state[p2] = this.state[p2 + M] ^ Random.TWIST(this.state[p2 + 0], this.state[p2 + 1]);
            ++p2;
        }
        j = M;
        while (--j != 0) {
            this.state[p2] = this.state[p2 + M - N] ^ Random.TWIST(this.state[p2 + 0], this.state[p2 + 1]);
            ++p2;
        }
        this.state[p2] = this.state[p2 + M - N] ^ Random.TWIST(this.state[p2], this.state[0]);
    }

    public int nextInt32() {
        if (--this.left == 0) {
            this.nextState();
        }
        int y = this.state[this.next++];
        y ^= y >>> 11;
        y = (int)((long)y ^ (long)(y << 7) & 0x9D2C5680L);
        y = (int)((long)y ^ (long)(y << 15) & 0xEFC60000L);
        y ^= y >>> 18;
        return y;
    }

    public double nextReal() {
        int a = this.nextInt32() >>> 5;
        int b = this.nextInt32() >>> 6;
        return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
    }
}

