/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal.backwardsCompatibility.bridge;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.manager.event.BridgeEnterEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.BridgeLeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class BridgeState {
    final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, BridgeEnterEvent> members = new HashMap<String, BridgeEnterEvent>();

    BridgeState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent destroy() {
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            this.members.clear();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent addMember(BridgeEnterEvent event) {
        ArrayList<BridgeEnterEvent> remaining = null;
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            if (this.members.put(event.getChannel(), event) == null && this.members.size() == 2) {
                remaining = new ArrayList<BridgeEnterEvent>(this.members.values());
            }
        }
        if (remaining == null) {
            return null;
        }
        this.logger.info("Members size " + remaining.size() + " " + event);
        BridgeEvent bridgeEvent = this.buildBridgeEvent("Link", remaining);
        this.logger.info("Bridge " + bridgeEvent.getChannel1() + " " + bridgeEvent.getChannel2());
        return bridgeEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent removeMember(BridgeLeaveEvent event) {
        ArrayList<BridgeEnterEvent> remaining = null;
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            if (this.members.remove(event.getChannel()) != null && this.members.size() == 2) {
                remaining = new ArrayList<BridgeEnterEvent>(this.members.values());
            }
        }
        if (remaining == null) {
            return null;
        }
        return this.buildBridgeEvent("Unlink", remaining);
    }

    private BridgeEvent buildBridgeEvent(String bridgeState, List<BridgeEnterEvent> members) {
        int index2;
        int index1;
        BridgeEvent bridgeEvent = new BridgeEvent(this);
        if (this.compareUniqueId(members.get(0).getUniqueId(), members.get(1).getUniqueId()) < 0) {
            index1 = 0;
            index2 = 1;
        } else {
            index1 = 1;
            index2 = 0;
        }
        bridgeEvent.setCallerId1(members.get(index1).getCallerIdNum());
        bridgeEvent.setUniqueId1(members.get(index1).getUniqueId());
        bridgeEvent.setChannel1(members.get(index1).getChannel());
        bridgeEvent.setCallerId2(members.get(index2).getCallerIdNum());
        bridgeEvent.setUniqueId2(members.get(index2).getUniqueId());
        bridgeEvent.setChannel2(members.get(index2).getChannel());
        bridgeEvent.setBridgeState(bridgeState);
        bridgeEvent.setDateReceived(new Date());
        return bridgeEvent;
    }

    private int compareUniqueId(String id1, String id2) {
        Pattern uniqueIdPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)$");
        Matcher uniqueId1Matcher = uniqueIdPattern.matcher(id1);
        Matcher uniqueId2Matcher = uniqueIdPattern.matcher(id2);
        boolean find1 = uniqueId1Matcher.find();
        boolean find2 = uniqueId2Matcher.find();
        if (find1 && find2) {
            long epochtime1 = Long.valueOf(uniqueId1Matcher.group(1));
            long epochtime2 = Long.valueOf(uniqueId2Matcher.group(1));
            int serial1 = Integer.valueOf(uniqueId1Matcher.group(2));
            int serial2 = Integer.valueOf(uniqueId2Matcher.group(2));
            if (epochtime1 == epochtime2) {
                return Integer.compare(serial1, serial2);
            }
            return Long.compare(epochtime1, epochtime2);
        }
        if (!find1 && find2) {
            return -1;
        }
        if (find1 && !find2) {
            return 1;
        }
        return 0;
    }
}

