/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.RedirectAction;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiChannelActivityQueue
implements AgiChannelActivityAction {
    private final Log logger = LogFactory.getLog(this.getClass());
    CountDownLatch latch = new CountDownLatch(1);
    private final String queue;
    private volatile boolean hangup = true;

    public AgiChannelActivityQueue(String queue) {
        this.queue = queue;
    }

    @Override
    public void execute(AgiChannel channel, Channel ichannel) throws AgiException, InterruptedException {
        channel.queue(this.queue);
        if (this.hangup) {
            try {
                channel.hangup();
            }
            catch (AgiHangupException e) {
                this.logger.warn("Channel " + channel.getName() + " hungup");
            }
            catch (Exception e) {
                this.logger.warn(e);
            }
        }
        this.logger.info(ichannel + " left the queue");
    }

    @Override
    public boolean isDisconnect() {
        return false;
    }

    @Override
    public void cancel(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel cannot be null");
        }
        this.hangup = false;
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        RedirectAction redirect = new RedirectAction(channel, profile.getManagementContext(), pbx.getExtensionAgi(), 1);
        try {
            pbx.sendAction(redirect, 1000);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
            this.logger.error(e, e);
        }
    }
}

