/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class CaseInsensitiveIntMap {
    public static final int NULL = -559038737;
    private char[][] _keys;
    private int[] _values;
    private int _size;
    private int _mask;

    public CaseInsensitiveIntMap() {
        this._keys = new char[256][];
        this._values = new int[256];
        this._mask = this._keys.length - 1;
        this._size = 0;
    }

    private CaseInsensitiveIntMap(boolean dummy) {
    }

    public void clear() {
        for (int i = 0; i < this._values.length; ++i) {
            this._keys[i] = null;
            this._values[i] = 0;
        }
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public int get(char[] key, int length) {
        if (key == null) {
            return -559038737;
        }
        int hash = CaseInsensitiveIntMap.hash(key, length) & this._mask;
        char[] mapKey;
        while ((mapKey = this._keys[hash]) != null) {
            if (CaseInsensitiveIntMap.equals(mapKey, key, length)) {
                return this._values[hash];
            }
            hash = hash + 1 & this._mask;
        }
        return -559038737;
    }

    public void put(char[] key, int length, int value) {
        if (key == null) {
            return;
        }
        int hash = CaseInsensitiveIntMap.hash(key, length) & this._mask;
        while (true) {
            char[] testKey;
            if ((testKey = this._keys[hash]) == null || CaseInsensitiveIntMap.equals(testKey, key, length)) {
                this._keys[hash] = new char[length];
                for (int i = length - 1; i >= 0; --i) {
                    char ch = key[i];
                    if ('A' <= ch && ch <= 'Z') {
                        ch = (char)(ch + 32);
                    }
                    this._keys[hash][i] = ch;
                }
                this._values[hash] = value;
                ++this._size;
                if (this._keys.length <= 4 * this._size) {
                    this.resize(2 * this._keys.length);
                }
                return;
            }
            if (key == testKey || testKey.equals(key)) break;
            hash = hash + 1 & this._mask;
        }
        this._values[hash] = value;
    }

    public void put(String key, int value) {
        this.put(key.toCharArray(), key.length(), value);
    }

    private void resize(int newSize) {
        char[][] newKeys = new char[newSize][];
        int[] newValues = new int[newSize];
        this._mask = newKeys.length - 1;
        block0: for (int i = 0; i < this._keys.length; ++i) {
            char[] key = this._keys[i];
            if (key == null) continue;
            int hash = CaseInsensitiveIntMap.hash(key, key.length) & this._mask;
            while (true) {
                if (newKeys[hash] == null) {
                    newKeys[hash] = this._keys[i];
                    newValues[hash] = this._values[i];
                    continue block0;
                }
                hash = hash + 1 & this._mask;
            }
        }
        this._keys = newKeys;
        this._values = newValues;
    }

    private static int hash(char[] key, int length) {
        int hash = 17;
        for (int i = length - 1; i >= 0; --i) {
            char a = key[i];
            if ('A' <= a && a <= 'Z') {
                a = (char)(a + 32);
            }
            hash = 65537 * hash + a;
        }
        return hash;
    }

    private static boolean equals(char[] lower, char[] mixed, int length) {
        if (lower.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            char a = lower[i];
            char b = mixed[i];
            if ('A' <= b && b <= 'Z') {
                b = (char)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "CaseInsensitiveIntMap[]";
    }
}

