/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ExitListener;
import java.util.ArrayList;

public class Exit {
    private static ThreadLocal<Queue> _waiting = new ThreadLocal();

    private Exit() {
    }

    public static void addExit(ExitListener listener, Object object) {
        Queue queue = _waiting.get();
        if (queue != null) {
            queue.add(listener, object);
        }
    }

    public static boolean addExit() {
        Queue queue = _waiting.get();
        if (queue == null) {
            queue = Queue.allocate();
            _waiting.set(queue);
            return true;
        }
        return false;
    }

    public static void exit() {
        Queue queue = null;
        queue = _waiting.get();
        _waiting.set(null);
        if (queue == null) {
            return;
        }
        int size = queue._listeners.size();
        for (int i = 0; i < size; ++i) {
            ExitListener listener = queue._listeners.get(i);
            Object object = queue._objects.get(i);
            if (listener == null) continue;
            try {
                listener.handleExit(object);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        queue.free();
    }

    private static class Queue {
        static Queue _freeList;
        Queue _next;
        ArrayList<ExitListener> _listeners = new ArrayList();
        ArrayList<Object> _objects = new ArrayList();

        private Queue() {
        }

        void add(ExitListener listener, Object object) {
            this._listeners.add(listener);
            this._objects.add(object);
        }

        static Queue allocate() {
            if (_freeList == null) {
                return new Queue();
            }
            Queue queue = _freeList;
            _freeList = Queue._freeList._next;
            return queue;
        }

        void free() {
            this._listeners.clear();
            this._objects.clear();
            this._next = _freeList;
            _freeList = this;
        }
    }
}

