/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class Html {
    public static String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder cb = new StringBuilder();
        int lineCharacter = 0;
        boolean startsWithSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            ++lineCharacter;
            if (ch == '<') {
                cb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                cb.append("&amp;");
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                lineCharacter = 0;
                cb.append(ch);
                startsWithSpace = false;
                continue;
            }
            if (lineCharacter > 70 && ch == ' ' && !startsWithSpace) {
                lineCharacter = 0;
                cb.append('\n');
                while (i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (lineCharacter == 1 && (ch == ' ' || ch == '\t')) {
                cb.append(ch);
                startsWithSpace = true;
                continue;
            }
            cb.append(ch);
        }
        return cb.toString();
    }
}

