/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeList;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempBuffer
implements Serializable {
    private static Logger _log;
    private static final FreeList<TempBuffer> _freeList;
    private static final boolean _isSmallmem;
    public static final int SIZE;
    TempBuffer _next;
    final byte[] _buf;
    int _offset;
    int _length;
    int _bufferCount;
    private boolean _isFree;

    public TempBuffer(int size) {
        this._buf = new byte[size];
    }

    public static boolean isSmallmem() {
        return _isSmallmem;
    }

    public static TempBuffer allocate() {
        TempBuffer next = _freeList.allocate();
        if (next == null) {
            return new TempBuffer(SIZE);
        }
        next._isFree = false;
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public void clear() {
        this._next = null;
        this._offset = 0;
        this._length = 0;
        this._bufferCount = 0;
    }

    public final byte[] getBuffer() {
        return this._buf;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getCapacity() {
        return this._buf.length;
    }

    public int getAvailable() {
        return this._buf.length - this._length;
    }

    public final TempBuffer getNext() {
        return this._next;
    }

    public final void setNext(TempBuffer next) {
        this._next = next;
    }

    public int write(byte[] buf, int offset, int length) {
        byte[] thisBuf = this._buf;
        int thisLength = this._length;
        if (thisBuf.length - thisLength < length) {
            length = thisBuf.length - thisLength;
        }
        System.arraycopy(buf, offset, thisBuf, thisLength, length);
        this._length = thisLength + length;
        return length;
    }

    public static TempBuffer copyFromStream(ReadStream is) throws IOException {
        int len;
        TempBuffer head;
        TempBuffer tail = head = TempBuffer.allocate();
        while ((len = is.readAll(tail._buf, 0, tail._buf.length)) == tail._buf.length) {
            TempBuffer buf = TempBuffer.allocate();
            tail._length = len;
            tail._next = buf;
            tail = buf;
        }
        if (len == 0 && head == tail) {
            return null;
        }
        if (len == 0) {
            TempBuffer ptr = head;
            while (ptr.getNext() != null) {
                TempBuffer next = ptr.getNext();
                if (next.getNext() == null) {
                    TempBuffer.free(next);
                    next = null;
                    ptr._next = null;
                }
                ptr = ptr.getNext();
            }
        } else {
            tail._length = len;
        }
        return head;
    }

    public static void free(TempBuffer buf) {
        buf._next = null;
        if (buf._buf.length == SIZE) {
            if (buf._isFree) {
                IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                throw e;
            }
            buf._isFree = true;
            _freeList.free(buf);
        }
    }

    public static void freeAll(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf._next;
            buf._next = null;
            if (buf._buf.length == SIZE) {
                if (buf._isFree) {
                    IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                    TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                    throw e;
                }
                buf._isFree = true;
                _freeList.free(buf);
            }
            buf = next;
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(TempBuffer.class.getName());
        }
        return _log;
    }

    static {
        _freeList = new FreeList(32);
        int size = 16384;
        boolean isSmallmem = false;
        String smallmem = System.getProperty("caucho.smallmem");
        if (smallmem != null && !"false".equals(smallmem)) {
            isSmallmem = true;
            size = 1024;
        }
        _isSmallmem = isSmallmem;
        SIZE = size;
    }
}

