/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;

public class TempInputStream
extends InputStream {
    private TempBuffer _head;
    private int _offset;

    public TempInputStream(TempBuffer head) {
        this._head = head;
    }

    public int read() throws IOException {
        if (this._head == null) {
            return -1;
        }
        int value = this._head._buf[this._offset++] & 0xFF;
        if (this._head._length <= this._offset) {
            TempBuffer next = this._head._next;
            this._head._next = null;
            TempBuffer.free(this._head);
            this._head = next;
            this._offset = 0;
        }
        return value;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._head == null) {
            return -1;
        }
        int sublen = this._head._length - this._offset;
        if (length < sublen) {
            sublen = length;
        }
        System.arraycopy(this._head._buf, this._offset, buf, offset, sublen);
        if (this._head._length <= this._offset + sublen) {
            TempBuffer next = this._head._next;
            this._head._next = null;
            TempBuffer.free(this._head);
            this._head = next;
            this._offset = 0;
        } else {
            this._offset += sublen;
        }
        return sublen;
    }

    public int available() throws IOException {
        if (this._head != null) {
            return this._head._length - this._offset;
        }
        return 0;
    }

    public void close() throws IOException {
        if (this._head != null) {
            TempBuffer.freeAll(this._head);
        }
        this._head = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

