/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;

public class JAVAWriter
extends EncodingWriter {
    private static JAVAWriter _writer = new JAVAWriter();

    public String getJavaEncoding() {
        return "JAVA";
    }

    public EncodingWriter create(String javaEncoding) {
        return _writer;
    }

    public void write(OutputStreamWithBuffer os, char ch) throws IOException {
        if (ch < '\u0080') {
            os.write(ch);
        } else {
            os.write(92);
            os.write(117);
            int b = ch >> 12 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch >> 8 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch >> 4 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
        }
    }

    public void write(OutputStreamWithBuffer os, char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            char ch = cbuf[off + i];
            if (ch < '\u0080') {
                os.write(ch);
                continue;
            }
            os.write(92);
            os.write(117);
            int b = ch >> 12 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch >> 8 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch >> 4 & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
            b = ch & 0xF;
            os.write(b < 10 ? b + 48 : b + 97 - 10);
        }
    }
}

