/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.i18n.EncodingReader;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF8Reader
extends EncodingReader {
    private InputStream _is;
    private int _peek = -1;

    public UTF8Reader() {
    }

    private UTF8Reader(InputStream is) {
        this._is = is;
    }

    public Reader create(InputStream is, String javaEncoding) {
        return new UTF8Reader(is);
    }

    public int read() throws IOException {
        if (this._peek >= 0) {
            int peek = this._peek;
            this._peek = -1;
            return peek;
        }
        InputStream is = this._is;
        int ch1 = is.read();
        if (ch1 < 128) {
            return ch1;
        }
        if ((ch1 & 0xE0) == 192) {
            int ch2 = is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch1) + ", " + Integer.toHexString(ch2));
            }
            return ((ch1 & 0x1F) << 6) + (ch2 & 0x3F);
        }
        if ((ch1 & 0xF0) == 224) {
            int ch2 = is.read();
            int ch3 = is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch2));
            }
            if (ch3 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch3 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch3));
            }
            int ch = ((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F);
            if (ch == 65279) {
                return is.read();
            }
            return ch;
        }
        if ((ch1 & 0xF0) == 240) {
            int ch2 = is.read();
            int ch3 = is.read();
            int ch4 = is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch2));
            }
            if (ch3 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch3 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch3));
            }
            if (ch4 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch4 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding at 0x" + Integer.toHexString(ch4));
            }
            int ch = ((ch1 & 0xF) << 18) + ((ch2 & 0x3F) << 12) + ((ch3 & 0x3F) << 6) + (ch4 & 0x3F);
            this._peek = 56320 + (ch & 0x3FF);
            return 55296 + (ch - 65536) / 1024;
        }
        throw new CharConversionException("illegal utf8 encoding at (" + ch1 + ")");
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        InputStream is = this._is;
        if (is == null) {
            return -1;
        }
        for (i = 0; i < len; ++i) {
            if (i > 0 && is.available() < 1) {
                return i;
            }
            int ch = this.read();
            if (ch < 0) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)ch;
        }
        return i;
    }
}

