/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.util.SafePropertyAccessor;

public class ASTInspector {
    public static final int BLOCK_ARG = 1;
    public static final int CLOSURE = 2;
    public static final int CLASS = 4;
    public static final int METHOD = 8;
    public static final int EVAL = 16;
    public static final int FRAME_AWARE = 32;
    public static final int FRAME_SELF = 64;
    public static final int FRAME_VISIBILITY = 128;
    public static final int FRAME_BLOCK = 256;
    public static final int FRAME_NAME = 512;
    public static final int BACKREF = 1024;
    public static final int LASTLINE = 2048;
    public static final int FRAME_CLASS = 4096;
    public static final int OPT_ARGS = 8192;
    public static final int REST_ARG = 16384;
    public static final int SCOPE_AWARE = 32768;
    public static final int ZSUPER = 65536;
    public static final int CONSTANT = 131072;
    public static final int CLASS_VAR = 262144;
    public static final int SUPER = 524288;
    public static final int RETRY = 0x100000;
    private int flags;
    private boolean noFrame;
    public static Set<String> FRAME_AWARE_METHODS = Collections.synchronizedSet(new HashSet());
    private static Set<String> SCOPE_AWARE_METHODS = Collections.synchronizedSet(new HashSet());
    public static Set<String> PRAGMAS = Collections.synchronizedSet(new HashSet());
    public static final boolean ENABLED;

    public void disable() {
        this.flags = -1;
    }

    public CallConfiguration getCallConfig() {
        if (this.hasFrameAwareMethods() || this.hasClosure() || !this.noFrame() && !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
            if (this.hasClosure() || this.hasScopeAwareMethods()) {
                return CallConfiguration.FrameFullScopeFull;
            }
            if (this.hasConstant() || this.hasMethod() || this.hasClass() || this.hasClassVar()) {
                return CallConfiguration.FrameFullScopeDummy;
            }
            return CallConfiguration.FrameFullScopeNone;
        }
        if (this.hasClosure() || this.hasScopeAwareMethods()) {
            if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                return CallConfiguration.FrameNoneScopeFull;
            }
            return CallConfiguration.FrameBacktraceScopeFull;
        }
        if (this.hasConstant() || this.hasMethod() || this.hasClass() || this.hasClassVar()) {
            if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED || this.noFrame()) {
                return CallConfiguration.FrameNoneScopeDummy;
            }
            return CallConfiguration.FrameBacktraceScopeDummy;
        }
        if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED || this.noFrame()) {
            return CallConfiguration.FrameNoneScopeNone;
        }
        return CallConfiguration.FrameBacktraceScopeNone;
    }

    public static ASTInspector subInspect(Node ... nodes) {
        ASTInspector newInspector = new ASTInspector();
        for (Node node : nodes) {
            newInspector.inspect(node);
        }
        return newInspector;
    }

    public boolean getFlag(int modifier) {
        return (this.flags & modifier) != 0;
    }

    public void setFlag(int modifier) {
        this.flags |= modifier;
    }

    public void integrate(ASTInspector other) {
        this.flags |= other.flags;
    }

    public void inspect(Node node) {
        if (!ENABLED) {
            this.disable();
        }
        if (node == null) {
            return;
        }
        block0 : switch (node.getNodeType()) {
            case ALIASNODE: {
                this.setFlag(8);
                break;
            }
            case ANDNODE: {
                AndNode andNode = (AndNode)node;
                this.inspect(andNode.getFirstNode());
                this.inspect(andNode.getSecondNode());
                break;
            }
            case ARGSCATNODE: {
                ArgsCatNode argsCatNode = (ArgsCatNode)node;
                this.inspect(argsCatNode.getFirstNode());
                this.inspect(argsCatNode.getSecondNode());
                break;
            }
            case ARGSPUSHNODE: {
                ArgsPushNode argsPushNode = (ArgsPushNode)node;
                this.inspect(argsPushNode.getFirstNode());
                this.inspect(argsPushNode.getSecondNode());
                break;
            }
            case ARGUMENTNODE: {
                break;
            }
            case ARRAYNODE: 
            case BLOCKNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case DXSTRNODE: 
            case LISTNODE: {
                ListNode listNode = (ListNode)node;
                for (int i = 0; i < listNode.size(); ++i) {
                    this.inspect(listNode.get(i));
                }
                break;
            }
            case ARGSNODE: {
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getBlock() != null) {
                    this.setFlag(1);
                }
                if (argsNode.getOptArgs() != null) {
                    this.setFlag(8192);
                    this.inspect(argsNode.getOptArgs());
                }
                if (argsNode.getRestArg() != -2 && argsNode.getRestArg() < 0) break;
                this.setFlag(16384);
                break;
            }
            case ATTRASSIGNNODE: {
                AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                this.setFlag(64);
                this.inspect(attrAssignNode.getArgsNode());
                this.inspect(attrAssignNode.getReceiverNode());
                break;
            }
            case BACKREFNODE: {
                this.setFlag(1024);
                break;
            }
            case BEGINNODE: {
                this.inspect(((BeginNode)node).getBodyNode());
                break;
            }
            case BIGNUMNODE: {
                break;
            }
            case BINARYOPERATORNODE: {
                BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)((Object)node);
                this.inspect(binaryOperatorNode.getFirstNode());
                this.inspect(binaryOperatorNode.getSecondNode());
                break;
            }
            case BLOCKARGNODE: {
                break;
            }
            case BLOCKPASSNODE: {
                BlockPassNode blockPassNode = (BlockPassNode)node;
                this.inspect(blockPassNode.getArgsNode());
                this.inspect(blockPassNode.getBodyNode());
                break;
            }
            case BREAKNODE: {
                this.inspect(((BreakNode)node).getValueNode());
                break;
            }
            case CALLNODE: {
                CallNode callNode = (CallNode)node;
                this.inspect(callNode.getReceiverNode());
                if (callNode.getName() == "new" && callNode.getReceiverNode() instanceof ConstNode && ((ConstNode)callNode.getReceiverNode()).getName() == "Proc") {
                    this.setFlag(256);
                }
            }
            case FCALLNODE: {
                this.inspect(((IArgumentNode)((Object)node)).getArgsNode());
                this.inspect(((BlockAcceptingNode)((Object)node)).getIterNode());
            }
            case VCALLNODE: {
                INameNode nameNode = (INameNode)((Object)node);
                if (FRAME_AWARE_METHODS.contains(nameNode.getName())) {
                    this.setFlag(32);
                    if (nameNode.getName().indexOf("eval") != -1) {
                        this.setFlag(16);
                    }
                }
                if (!SCOPE_AWARE_METHODS.contains(nameNode.getName())) break;
                this.setFlag(32768);
                break;
            }
            case CASENODE: {
                CaseNode caseNode = (CaseNode)node;
                this.inspect(caseNode.getCaseNode());
                for (Node when : caseNode.getCases().childNodes()) {
                    this.inspect(when);
                }
                this.inspect(caseNode.getElseNode());
                break;
            }
            case CLASSNODE: {
                this.setFlag(4);
                ClassNode classNode = (ClassNode)node;
                this.inspect(classNode.getCPath());
                this.inspect(classNode.getSuperNode());
                break;
            }
            case CLASSVARNODE: {
                this.setFlag(262144);
                break;
            }
            case CONSTDECLNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.setFlag(131072);
                break;
            }
            case CLASSVARASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.setFlag(262144);
                break;
            }
            case CLASSVARDECLNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.setFlag(262144);
                break;
            }
            case COLON2NODE: {
                this.inspect(((Colon2Node)node).getLeftNode());
                break;
            }
            case COLON3NODE: {
                break;
            }
            case CONSTNODE: {
                this.setFlag(131072);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                this.setFlag(8);
                this.setFlag(128);
                break;
            }
            case DEFINEDNODE: {
                switch (((DefinedNode)node).getExpressionNode().getNodeType()) {
                    case CLASSVARASGNNODE: 
                    case CLASSVARDECLNODE: 
                    case CONSTDECLNODE: 
                    case DASGNNODE: 
                    case GLOBALASGNNODE: 
                    case LOCALASGNNODE: 
                    case MULTIPLEASGNNODE: 
                    case OPASGNNODE: 
                    case OPELEMENTASGNNODE: 
                    case DVARNODE: 
                    case FALSENODE: 
                    case TRUENODE: 
                    case LOCALVARNODE: 
                    case INSTVARNODE: 
                    case BACKREFNODE: 
                    case SELFNODE: 
                    case VCALLNODE: 
                    case YIELDNODE: 
                    case GLOBALVARNODE: 
                    case CONSTNODE: 
                    case FCALLNODE: 
                    case CLASSVARNODE: {
                        this.inspect(((DefinedNode)node).getExpressionNode());
                        break block0;
                    }
                }
                this.disable();
                break;
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                this.inspect(dotNode.getBeginNode());
                this.inspect(dotNode.getEndNode());
                break;
            }
            case DASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                break;
            }
            case DVARNODE: {
                break;
            }
            case ENSURENODE: {
                this.disable();
                break;
            }
            case EVSTRNODE: {
                this.inspect(((EvStrNode)node).getBody());
                break;
            }
            case FALSENODE: {
                break;
            }
            case FIXNUMNODE: {
                break;
            }
            case FLIPNODE: {
                this.inspect(((FlipNode)node).getBeginNode());
                this.inspect(((FlipNode)node).getEndNode());
                break;
            }
            case FLOATNODE: {
                break;
            }
            case FORNODE: {
                this.setFlag(2);
                this.setFlag(32768);
                this.inspect(((ForNode)node).getIterNode());
                this.inspect(((ForNode)node).getBodyNode());
                this.inspect(((ForNode)node).getVarNode());
                break;
            }
            case GLOBALASGNNODE: {
                GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
                if (globalAsgnNode.getName().equals("$_")) {
                    this.setFlag(2048);
                } else if (globalAsgnNode.getName().equals("$~")) {
                    this.setFlag(1024);
                }
                this.inspect(globalAsgnNode.getValueNode());
                break;
            }
            case GLOBALVARNODE: {
                if (((GlobalVarNode)node).getName().equals("$_")) {
                    this.setFlag(2048);
                    break;
                }
                if (!((GlobalVarNode)node).getName().equals("$~")) break;
                this.setFlag(1024);
                break;
            }
            case HASHNODE: {
                HashNode hashNode = (HashNode)node;
                this.inspect(hashNode.getListNode());
                break;
            }
            case IFNODE: {
                IfNode ifNode = (IfNode)node;
                this.inspect(ifNode.getCondition());
                this.inspect(ifNode.getThenBody());
                this.inspect(ifNode.getElseBody());
                break;
            }
            case INSTASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                break;
            }
            case INSTVARNODE: {
                break;
            }
            case ISCOPINGNODE: {
                IScopingNode iscopingNode = (IScopingNode)((Object)node);
                this.inspect(iscopingNode.getCPath());
                break;
            }
            case ITERNODE: {
                this.setFlag(2);
                break;
            }
            case LAMBDANODE: {
                this.setFlag(2);
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
                if (PRAGMAS.contains(localAsgnNode.getName())) {
                    if (!localAsgnNode.getName().equals("__NOFRAME__")) break;
                    this.noFrame = localAsgnNode.getValueNode() instanceof TrueNode;
                    break;
                }
                this.inspect(localAsgnNode.getValueNode());
                break;
            }
            case LOCALVARNODE: {
                break;
            }
            case MATCHNODE: {
                this.inspect(((MatchNode)node).getRegexpNode());
                this.setFlag(1024);
                break;
            }
            case MATCH2NODE: {
                Match2Node match2Node = (Match2Node)node;
                this.inspect(match2Node.getReceiverNode());
                this.inspect(match2Node.getValueNode());
                this.setFlag(1024);
                break;
            }
            case MATCH3NODE: {
                Match3Node match3Node = (Match3Node)node;
                this.inspect(match3Node.getReceiverNode());
                this.inspect(match3Node.getValueNode());
                this.setFlag(1024);
                break;
            }
            case MODULENODE: {
                this.setFlag(4);
                this.inspect(((ModuleNode)node).getCPath());
                break;
            }
            case MULTIPLEASGN19NODE: {
                MultipleAsgn19Node multipleAsgn19Node = (MultipleAsgn19Node)node;
                this.inspect(multipleAsgn19Node.getPre());
                this.inspect(multipleAsgn19Node.getPost());
                this.inspect(multipleAsgn19Node.getRest());
                this.inspect(multipleAsgn19Node.getValueNode());
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
                this.inspect(multipleAsgnNode.getArgsNode());
                this.inspect(multipleAsgnNode.getHeadNode());
                this.inspect(multipleAsgnNode.getValueNode());
                break;
            }
            case NEWLINENODE: {
                this.inspect(((NewlineNode)node).getNextNode());
                break;
            }
            case NEXTNODE: {
                this.inspect(((NextNode)node).getValueNode());
                break;
            }
            case NILNODE: {
                break;
            }
            case NOTNODE: {
                this.inspect(((NotNode)node).getConditionNode());
                break;
            }
            case NTHREFNODE: {
                break;
            }
            case OPASGNANDNODE: {
                OpAsgnAndNode opAsgnAndNode = (OpAsgnAndNode)node;
                this.inspect(opAsgnAndNode.getFirstNode());
                this.inspect(opAsgnAndNode.getSecondNode());
                break;
            }
            case OPASGNNODE: {
                OpAsgnNode opAsgnNode = (OpAsgnNode)node;
                this.inspect(opAsgnNode.getReceiverNode());
                this.inspect(opAsgnNode.getValueNode());
                break;
            }
            case OPASGNORNODE: {
                switch (((OpAsgnOrNode)node).getFirstNode().getNodeType()) {
                    case CLASSVARASGNNODE: 
                    case CLASSVARDECLNODE: 
                    case CONSTDECLNODE: 
                    case DASGNNODE: 
                    case GLOBALASGNNODE: 
                    case LOCALASGNNODE: 
                    case MULTIPLEASGNNODE: 
                    case OPASGNNODE: 
                    case OPELEMENTASGNNODE: 
                    case DVARNODE: 
                    case FALSENODE: 
                    case TRUENODE: 
                    case LOCALVARNODE: 
                    case INSTVARNODE: 
                    case BACKREFNODE: 
                    case SELFNODE: 
                    case VCALLNODE: 
                    case YIELDNODE: 
                    case GLOBALVARNODE: 
                    case CONSTNODE: 
                    case FCALLNODE: 
                    case CLASSVARNODE: {
                        this.inspect(((OpAsgnOrNode)node).getSecondNode());
                        break block0;
                    }
                }
                this.disable();
                break;
            }
            case OPELEMENTASGNNODE: {
                OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
                this.setFlag(64);
                this.inspect(opElementAsgnNode.getArgsNode());
                this.inspect(opElementAsgnNode.getReceiverNode());
                this.inspect(opElementAsgnNode.getValueNode());
                break;
            }
            case OPTARGNODE: {
                this.inspect(((OptArgNode)node).getValue());
                break;
            }
            case ORNODE: {
                OrNode orNode = (OrNode)node;
                this.inspect(orNode.getFirstNode());
                this.inspect(orNode.getSecondNode());
                break;
            }
            case POSTEXENODE: {
                PostExeNode postExeNode = (PostExeNode)node;
                this.setFlag(2);
                this.setFlag(32768);
                this.inspect(postExeNode.getBodyNode());
                this.inspect(postExeNode.getVarNode());
                break;
            }
            case PREEXENODE: {
                PreExeNode preExeNode = (PreExeNode)node;
                this.setFlag(2);
                this.setFlag(32768);
                this.inspect(preExeNode.getBodyNode());
                this.inspect(preExeNode.getVarNode());
                break;
            }
            case REDONODE: {
                break;
            }
            case REGEXPNODE: {
                break;
            }
            case ROOTNODE: {
                BlockNode blockNode;
                this.inspect(((RootNode)node).getBodyNode());
                if (!(((RootNode)node).getBodyNode() instanceof BlockNode) || (blockNode = (BlockNode)((RootNode)node).getBodyNode()).size() <= 500) break;
                this.setFlag(32768);
                break;
            }
            case RESCUEBODYNODE: {
                RescueBodyNode rescueBody = (RescueBodyNode)node;
                this.inspect(rescueBody.getExceptionNodes());
                this.inspect(rescueBody.getBodyNode());
                this.inspect(rescueBody.getOptRescueNode());
                break;
            }
            case RESCUENODE: {
                RescueNode rescueNode = (RescueNode)node;
                this.inspect(rescueNode.getBodyNode());
                this.inspect(rescueNode.getElseNode());
                this.inspect(rescueNode.getRescueNode());
                this.disable();
                break;
            }
            case RETRYNODE: {
                this.setFlag(0x100000);
                break;
            }
            case RETURNNODE: {
                this.inspect(((ReturnNode)node).getValueNode());
                break;
            }
            case SCLASSNODE: {
                this.setFlag(4);
                SClassNode sclassNode = (SClassNode)node;
                this.inspect(sclassNode.getReceiverNode());
                break;
            }
            case SCOPENODE: {
                break;
            }
            case SELFNODE: {
                break;
            }
            case SPLATNODE: {
                this.inspect(((SplatNode)node).getValue());
                break;
            }
            case STARNODE: {
                break;
            }
            case STRNODE: {
                break;
            }
            case SUPERNODE: {
                SuperNode superNode = (SuperNode)node;
                this.inspect(superNode.getArgsNode());
                this.inspect(superNode.getIterNode());
                this.setFlag(524288);
                break;
            }
            case SVALUENODE: {
                this.inspect(((SValueNode)node).getValue());
                break;
            }
            case SYMBOLNODE: {
                break;
            }
            case TOARYNODE: {
                this.inspect(((ToAryNode)node).getValue());
                break;
            }
            case TRUENODE: {
                break;
            }
            case UNDEFNODE: {
                this.setFlag(8);
                break;
            }
            case UNTILNODE: {
                UntilNode untilNode = (UntilNode)node;
                ASTInspector untilInspector = ASTInspector.subInspect(untilNode.getConditionNode(), untilNode.getBodyNode());
                if (untilInspector.getFlag(2) || untilInspector.getFlag(16)) {
                    untilNode.containsNonlocalFlow = true;
                    this.setFlag(32768);
                }
                this.integrate(untilInspector);
                break;
            }
            case VALIASNODE: {
                break;
            }
            case WHENNODE: {
                this.inspect(((WhenNode)node).getBodyNode());
                this.inspect(((WhenNode)node).getExpressionNodes());
                this.inspect(((WhenNode)node).getNextCase());
                break;
            }
            case WHILENODE: {
                WhileNode whileNode = (WhileNode)node;
                ASTInspector whileInspector = ASTInspector.subInspect(whileNode.getConditionNode(), whileNode.getBodyNode());
                if (whileInspector.getFlag(2) || whileInspector.getFlag(16) || this.getFlag(1)) {
                    whileNode.containsNonlocalFlow = true;
                    this.setFlag(32768);
                }
                this.integrate(whileInspector);
                break;
            }
            case XSTRNODE: {
                break;
            }
            case YIELDNODE: {
                this.inspect(((YieldNode)node).getArgsNode());
                break;
            }
            case ZARRAYNODE: {
                break;
            }
            case ZEROARGNODE: {
                break;
            }
            case ZSUPERNODE: {
                this.setFlag(32768);
                this.setFlag(65536);
                this.inspect(((ZSuperNode)node).getIterNode());
                break;
            }
            default: {
                assert (false) : "All nodes should be accounted for in AST inspector: " + node;
                this.disable();
            }
        }
    }

    public boolean hasClass() {
        return this.getFlag(4);
    }

    public boolean hasClosure() {
        return this.getFlag(2);
    }

    public boolean hasMethod() {
        return this.getFlag(8);
    }

    public boolean hasFrameAwareMethods() {
        return this.getFlag(598002);
    }

    public boolean hasScopeAwareMethods() {
        return this.getFlag(32768);
    }

    public boolean hasBlockArg() {
        return this.getFlag(1);
    }

    public boolean hasOptArgs() {
        return this.getFlag(8192);
    }

    public boolean hasRestArg() {
        return this.getFlag(16384);
    }

    public boolean hasConstant() {
        return this.getFlag(131072);
    }

    public boolean hasClassVar() {
        return this.getFlag(262144);
    }

    public boolean noFrame() {
        return this.noFrame;
    }

    static {
        FRAME_AWARE_METHODS.add("eval");
        FRAME_AWARE_METHODS.add("module_eval");
        FRAME_AWARE_METHODS.add("class_eval");
        FRAME_AWARE_METHODS.add("instance_eval");
        FRAME_AWARE_METHODS.add("binding");
        FRAME_AWARE_METHODS.add("public");
        FRAME_AWARE_METHODS.add("private");
        FRAME_AWARE_METHODS.add("protected");
        FRAME_AWARE_METHODS.add("module_function");
        FRAME_AWARE_METHODS.add("block_given?");
        FRAME_AWARE_METHODS.add("iterator?");
        SCOPE_AWARE_METHODS.addAll(RubyModule.SCOPE_CAPTURING_METHODS);
        PRAGMAS.add("__NOFRAME__");
        ENABLED = SafePropertyAccessor.getProperty("jruby.astInspector.enabled", "true").equals("true");
    }
}

