/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetBinaryValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.util.Alarm;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryBuilderValue
extends BinaryValue {
    public static final BinaryBuilderValue EMPTY = new BinaryBuilderValue("");
    private static final BinaryBuilderValue[] CHAR_STRINGS = new BinaryBuilderValue[256];
    protected byte[] _buffer;
    protected int _length;
    private String _value;

    public BinaryBuilderValue() {
        this._buffer = new byte[128];
    }

    public BinaryBuilderValue(int capacity) {
        capacity = capacity < 64 ? 128 : 2 * capacity;
        this._buffer = new byte[capacity];
    }

    public BinaryBuilderValue(byte[] buffer, int offset, int length) {
        this._buffer = new byte[length];
        this._length = length;
        System.arraycopy(buffer, offset, this._buffer, 0, length);
    }

    public BinaryBuilderValue(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BinaryBuilderValue(String s) {
        int len = s.length();
        this._buffer = new byte[len];
        this._length = len;
        for (int i = 0; i < len; ++i) {
            this._buffer[i] = (byte)s.charAt(i);
        }
    }

    public BinaryBuilderValue(char[] buffer) {
        this._buffer = new byte[buffer.length];
        this._length = buffer.length;
        for (int i = 0; i < buffer.length; ++i) {
            this._buffer[i] = (byte)buffer[i];
        }
    }

    public BinaryBuilderValue(char[] s, Value v1) {
        int len = s.length;
        this._buffer = len < 128 ? new byte[128] : new byte[len + 32];
        this._length = len;
        for (int i = 0; i < len; ++i) {
            this._buffer[i] = (byte)s[i];
        }
        v1.appendTo(this);
    }

    public BinaryBuilderValue(Byte[] buffer) {
        int length = buffer.length;
        this._buffer = new byte[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = buffer[i];
        }
    }

    public BinaryBuilderValue(byte ch) {
        this._buffer = new byte[1];
        this._length = 1;
        this._buffer[0] = ch;
    }

    public static StringValue create(int value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new BinaryBuilderValue(value);
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return BinaryBuilderValue.getValueType(this._buffer, 0, this._length);
    }

    @Override
    public boolean isLongConvertible() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            byte ch = this._buffer[i];
            if (48 <= ch && ch <= 57) continue;
            return false;
        }
        return true;
    }

    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._buffer[0] != 48;
    }

    @Override
    public long toLong() {
        return BinaryBuilderValue.parseLong(this._buffer, 0, this._length);
    }

    @Override
    public double toDouble() {
        return BinaryBuilderValue.toDouble(this._buffer, 0, this._length);
    }

    @Override
    public InputStream toInputStream() {
        return new BuilderInputStream();
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    @Override
    public Object toJavaObject() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    @Override
    public StringValue toStringBuilder() {
        return new BinaryBuilderValue(this._buffer, 0, this._length);
    }

    @Override
    public StringValue toBinaryValue(Env env) {
        return this;
    }

    @Override
    public StringValue toBinaryValue(Env env, String charset) {
        return this;
    }

    public void appendTo(StringValue bb) {
        bb.append(this._buffer, 0, this._length);
    }

    @Override
    public Value toKey() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        byte ch = buffer[i];
        if (ch == 45) {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = buffer[i];
            if (48 > ch || ch > 57) {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return new LongValue((long)sign * value);
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        System.arraycopy(this._buffer, 0, bytes, 0, this._length);
        return bytes;
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getRef(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetBinaryValue.UNSET;
        }
        return BinaryBuilderValue.create(this._buffer[(int)index] & 0xFF);
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public char charAt(int index) {
        return (char)(this._buffer[index] & 0xFF);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return EMPTY;
        }
        return new BinaryBuilderValue(this._buffer, start, end - start);
    }

    @Override
    public StringValue toLowerCase() {
        int length = this._length;
        BinaryBuilderValue string = new BinaryBuilderValue(length);
        byte[] srcBuffer = this._buffer;
        byte[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 65 <= ch && ch <= 90 ? (byte)(ch + 97 - 65) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this._length;
        BinaryBuilderValue string = new BinaryBuilderValue(this._length);
        byte[] srcBuffer = this._buffer;
        byte[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 97 <= ch && ch <= 122 ? (byte)(ch + 65 - 97) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public StringValue createStringBuilder() {
        return new BinaryBuilderValue();
    }

    @Override
    public StringValue createStringBuilder(int length) {
        return new BinaryBuilderValue(length);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return new BinaryBuilderValue(this._buffer, 0, this._length);
    }

    @Override
    public final StringValue appendUnicode(char[] buf, int offset, int length) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(buf, offset, length);
        return sb;
    }

    @Override
    public final StringValue append(CharSequence buf, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        if (buf instanceof BinaryBuilderValue) {
            BinaryBuilderValue sb = (BinaryBuilderValue)buf;
            System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
            this._length += tail - head;
            return this;
        }
        byte[] buffer = this._buffer;
        int bufferLength = this._length;
        while (head < tail) {
            buffer[bufferLength++] = (byte)buf.charAt(head);
            ++head;
        }
        this._length = bufferLength;
        return this;
    }

    public final StringValue append(BinaryBuilderValue sb, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
        this._length += tail - head;
        return this;
    }

    @Override
    public final StringValue append(Value v) {
        return v.appendTo(this);
    }

    @Override
    public final StringValue append(byte[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(buf, offset, this._buffer, this._length, length);
        this._length += length;
        return this;
    }

    @Override
    public final StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    @Override
    public final StringValue append(char v) {
        int length = this._length + 1;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        this._buffer[this._length++] = (byte)v;
        return this;
    }

    public final StringValue append(byte v) {
        int length = this._length + 1;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        this._buffer[this._length++] = v;
        return this;
    }

    @Override
    public final StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue append(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = 0; i < sublen; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
        return this;
    }

    @Override
    public StringValue append(String s, int start, int end) {
        int sublen = end - start;
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = start; i < end; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
        return this;
    }

    @Override
    public StringValue append(char[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this._buffer[this._length++] = (byte)buf[i];
        }
        return this;
    }

    @Override
    public final StringValue appendUnicode(String s) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(String s, int start, int end) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s, start, end);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(Value value) {
        if ((value = value.toValue()) instanceof BinaryBuilderValue) {
            this.append((BinaryBuilderValue)value);
            return this;
        }
        if (value.isString()) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue();
            this.appendTo(sb);
            sb.append(value);
            return sb;
        }
        return value.appendTo(this);
    }

    @Override
    public final StringValue appendUnicode(char ch) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(ch);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue appendUnicode(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendUnicode(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendUnicode(Object v) {
        if (v instanceof String) {
            return this.appendUnicode(v.toString());
        }
        return this.append(v.toString());
    }

    @Override
    public final StringValue appendByte(int v) {
        int length = this._length + 1;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        this._buffer[this._length++] = (byte)v;
        return this;
    }

    @Override
    public final StringValue appendBytes(byte[] bytes, int offset, int end) {
        int length = this._length + end - offset;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        for (int i = offset; i < end; ++i) {
            this._buffer[this._length++] = bytes[i];
        }
        return this;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        if (this.length() == 0) {
            return sb;
        }
        Env env = Env.getInstance();
        try {
            Reader reader = env.getRuntimeEncodingFactory().create(this.toInputStream());
            if (reader != null) {
                sb.append(reader);
                reader.close();
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public byte[] getBuffer() {
        return this._buffer;
    }

    @Override
    public int getOffset() {
        return this._length;
    }

    @Override
    public void setOffset(int offset) {
        this._length = offset;
    }

    public int getLength() {
        return this._buffer.length;
    }

    @Override
    public void print(Env env) {
        env.write(this._buffer, 0, this._length);
    }

    @Override
    public void print(Env env, WriteStream out) {
        try {
            out.write(this._buffer, 0, this._length);
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    public OutputStream getOutputStream() {
        return new BuilderOutputStream();
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity <= this._buffer.length) {
            return;
        }
        newCapacity = newCapacity < 4096 ? 4 * newCapacity : (newCapacity += 4096);
        byte[] buffer = new byte[newCapacity];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        int length = this._length;
        byte[] buffer = this._buffer;
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + (buffer[i] & 0xFF);
        }
        return hash;
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeA = this.getValueType();
        ValueType typeB = rValue.getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if ((rValue = rValue.toValue()) instanceof BinaryBuilderValue) {
            BinaryBuilderValue value = (BinaryBuilderValue)rValue;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return this.toString().equals(rValue.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BinaryBuilderValue) {
            BinaryBuilderValue value = (BinaryBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean eql(Value o) {
        if ((o = o.toValue()) instanceof BinaryBuilderValue) {
            BinaryBuilderValue value = (BinaryBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("binary(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        if (Alarm.isTest()) {
            out.print("binary");
        } else {
            out.print("string");
        }
        out.print("(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            if (' ' <= ch && ch <= '\u007f' || ch == '\t' || ch == '\r' || ch == '\n') {
                out.print(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                out.print("\\x" + Integer.toHexString(ch / 16) + Integer.toHexString(ch % 16));
                continue;
            }
            out.print("\\u" + Integer.toHexString(ch >> 12 & 0xF) + Integer.toHexString(ch >> 8 & 0xF) + Integer.toHexString(ch >> 4 & 0xF) + Integer.toHexString(ch & 0xF));
        }
        out.print("\"");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._length);
        out.write(this._buffer, 0, this._length);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._length = in.readInt();
        this._buffer = new byte[this._length];
        in.read(this._buffer, 0, this._length);
    }

    public static ValueType getValueType(byte[] buffer, int offset, int len) {
        if (len == 0) {
            return ValueType.LONG_ADD;
        }
        int i = offset;
        byte ch = 0;
        boolean hasPoint = false;
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        if (len <= i) {
            return ValueType.STRING;
        }
        ch = buffer[i];
        if (ch == 46) {
            if (++i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                return ValueType.DOUBLE_CMP;
            }
            return ValueType.STRING;
        }
        if (48 > ch || ch > 57) {
            return ValueType.STRING;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (len <= i) {
            return ValueType.LONG_EQ;
        }
        if (ch == 46 || ch == 101 || ch == 69) {
            ++i;
            while (i < len && (48 <= (ch = buffer[i]) && ch <= 57 || ch == 43 || ch == 45 || ch == 101 || ch == 69)) {
                ++i;
            }
            if (i < len) {
                return ValueType.STRING;
            }
            return ValueType.DOUBLE_CMP;
        }
        return ValueType.STRING;
    }

    public static int getNumericType(byte[] buffer, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int i = offset;
        byte ch = 0;
        boolean hasPoint = false;
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        if (len <= i) {
            return 0;
        }
        ch = buffer[i];
        if (ch == 46) {
            if (++i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                return 2;
            }
            return 0;
        }
        if (48 > ch || ch > 57) {
            return 0;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (len <= i) {
            return 1;
        }
        if (ch == 46 || ch == 101 || ch == 69) {
            ++i;
            while (i < len && (48 <= (ch = buffer[i]) && ch <= 57 || ch == 43 || ch == 45 || ch == 101 || ch == 69)) {
                ++i;
            }
            if (i < len) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public static double toDouble(byte[] buffer, int offset, int len) {
        int i = offset;
        byte ch = 0;
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (ch == 46) {
            ++i;
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == 1) {
                return 0.0;
            }
        }
        if (ch == 101 || ch == 69) {
            int e = i++;
            if (i < len && (ch = buffer[i]) == 43 || ch == 45) {
                ++i;
            }
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(new String(buffer, 0, i));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            BinaryBuilderValue.CHAR_STRINGS[i] = new BinaryBuilderValue((byte)i);
        }
    }

    class BuilderOutputStream
    extends OutputStream {
        BuilderOutputStream() {
        }

        public void write(int ch) {
            BinaryBuilderValue.this.append(ch);
        }

        public void write(byte[] buffer, int offset, int length) {
            BinaryBuilderValue.this.append(buffer, offset, length);
        }
    }

    class BuilderInputStream
    extends InputStream {
        private int _index;

        BuilderInputStream() {
        }

        public int read() {
            if (this._index < BinaryBuilderValue.this._length) {
                return BinaryBuilderValue.this._buffer[this._index++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = BinaryBuilderValue.this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(BinaryBuilderValue.this._buffer, this._index, buffer, offset, sublen);
            this._index += sublen;
            return sublen;
        }
    }

    class BinaryInputStream
    extends InputStream {
        private int _offset;

        BinaryInputStream() {
        }

        public int read() {
            if (this._offset < BinaryBuilderValue.this._length) {
                return BinaryBuilderValue.this._buffer[this._offset++];
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = BinaryBuilderValue.this._length - this._offset;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(BinaryBuilderValue.this._buffer, this._offset, buffer, offset, sublen);
            this._offset += sublen;
            return sublen;
        }
    }
}

