/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.CallbackObjectMethod;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.GlobalArrayValue;
import com.caucho.quercus.env.ImportMap;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.OutputBuffer;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.ServerArrayValue;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.SessionCallback;
import com.caucho.quercus.env.SessionVar;
import com.caucho.quercus.env.Shutdown;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.ErrorModule;
import com.caucho.quercus.lib.OptionsModule;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.PhpStderr;
import com.caucho.quercus.lib.file.PhpStdin;
import com.caucho.quercus.lib.file.PhpStdout;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.program.UndefinedFunction;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.i18n.EncodingReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Env {
    private static final L10N L = new L10N(Env.class);
    private static final Logger log = Logger.getLogger(Env.class.getName());
    public static final int B_ERROR = 0;
    public static final int B_WARNING = 1;
    public static final int B_PARSE = 2;
    public static final int B_NOTICE = 3;
    public static final int B_CORE_ERROR = 4;
    public static final int B_CORE_WARNING = 5;
    public static final int B_COMPILE_ERROR = 6;
    public static final int B_COMPILE_WARNING = 7;
    public static final int B_USER_ERROR = 8;
    public static final int B_USER_WARNING = 9;
    public static final int B_USER_NOTICE = 10;
    public static final int B_STRICT = 11;
    public static final int B_RECOVERABLE_ERROR = 12;
    public static final int B_LAST = 12;
    public static final int E_ERROR = 1;
    public static final int E_WARNING = 2;
    public static final int E_PARSE = 4;
    public static final int E_NOTICE = 8;
    public static final int E_CORE_ERROR = 16;
    public static final int E_CORE_WARNING = 32;
    public static final int E_COMPILE_ERROR = 64;
    public static final int E_COMPILE_WARNING = 128;
    public static final int E_USER_ERROR = 256;
    public static final int E_USER_WARNING = 512;
    public static final int E_USER_NOTICE = 1024;
    public static final int E_ALL = 6143;
    public static final int E_STRICT = 2048;
    public static final int E_RECOVERABLE_ERROR = 4096;
    public static final int E_DEFAULT = 6135;
    private static final int _SERVER = 1;
    private static final int _GET = 2;
    private static final int _POST = 3;
    private static final int _COOKIE = 4;
    private static final int _GLOBAL = 5;
    private static final int _REQUEST = 6;
    private static final int _SESSION = 7;
    private static final int HTTP_GET_VARS = 8;
    private static final int HTTP_POST_VARS = 9;
    private static final int HTTP_COOKIE_VARS = 10;
    private static final int PHP_SELF = 11;
    private static final int _FILES = 12;
    private static final int HTTP_POST_FILES = 13;
    private static final int _ENV = 14;
    private static final int HTTP_SERVER_VARS = 15;
    private static final int HTTP_RAW_POST_DATA = 16;
    private static final IntMap SPECIAL_VARS = new IntMap();
    private static final StringValue PHP_SELF_STRING = new StringBuilderValue("PHP_SELF");
    private static final StringValue UTF8_STRING = new StringBuilderValue("utf-8");
    public static final Value[] EMPTY_VALUE = new Value[0];
    private static final LruCache<ClassKey, SoftReference<QuercusClass>> _classCache = new LruCache(4096);
    private static ThreadLocal<Env> _threadEnv = new ThreadLocal();
    private static final FreeList<AbstractFunction[]> _freeFunList = new FreeList(256);
    private static final FreeList<ClassDef[]> _freeClassDefList = new FreeList(256);
    private static final FreeList<QuercusClass[]> _freeClassList = new FreeList(256);
    protected final Quercus _quercus;
    private final boolean _isUnicodeSemantics;
    private QuercusPage _page;
    private Value _this = NullThisValue.NULL;
    private ArrayList<EnvCleanup> _cleanupList = new ArrayList();
    private ArrayList<ObjectExtValue> _objCleanupList = new ArrayList();
    private ArrayList<Shutdown> _shutdownList = new ArrayList();
    private final HashMap<String, Var> _globalMap = new HashMap(1024);
    private HashMap<String, Var> _staticMap = new HashMap();
    private HashMap<String, Var> _map = this._globalMap;
    private HashMap<String, Value> _constMap = new HashMap(1024);
    private HashMap<String, Value> _lowerConstMap = new HashMap(1024);
    private HashMap<String, QuercusClass> _classMap = new HashMap();
    private HashMap<String, QuercusClass> _lowerClassMap = new HashMap();
    private HashSet<String> _initializedClassSet = new HashSet();
    public AbstractFunction[] _fun;
    public HashMap<String, AbstractFunction> _anonymousFunMap;
    public ClassDef[] _classDef;
    public QuercusClass[] _qClass;
    private IdentityHashMap<String, Value> _iniMap;
    private HashMap<String, Object> _specialMap = new HashMap();
    private int _iniCount = 1;
    private String _defaultIncludePath;
    private String _includePath;
    private int _includePathIniCount;
    private ArrayList<String> _includePathList;
    private HashMap<Path, ArrayList<Path>> _includePathMap;
    private HashMap<Path, QuercusPage> _includeMap = new HashMap();
    private boolean _isAllowUrlInclude;
    private boolean _isAllowUrlFopen;
    private HashMap<StringValue, Path> _lookupCache = new HashMap();
    private HashMap<ConnectionEntry, ConnectionEntry> _connMap = new HashMap();
    private AbstractFunction _autoload;
    private HashSet<String> _autoloadClasses = new HashSet();
    private ArrayList<Callback> _autoloadList;
    private long _startTime;
    private long _timeLimit = 600000L;
    private Expr[] _callStack = new Expr[256];
    private Value[] _callThisStack = new Value[256];
    private Value[][] _callArgStack = new Value[256][];
    private int _callStackTop;
    private QuercusClass _callingClass;
    private Value[] _functionArgs;
    private LinkedList<FieldGetEntry> _fieldGetList = new LinkedList();
    private Path _selfPath;
    private Path _selfDirectory;
    private Path _pwd;
    private Path _uploadPath;
    private Path _tmpPath;
    private ArrayList<Path> _removePaths;
    private final boolean _isStrict;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ArrayValue _postArray;
    private StringValue _inputData;
    private ArrayValue _files;
    private SessionArrayValue _session;
    private HttpSession _javaSession;
    private ScriptContext _scriptContext;
    private WriteStream _originalOut;
    private OutputBuffer _outputBuffer;
    private WriteStream _out;
    private LocaleInfo _locale;
    private Callback[] _prevErrorHandlers = new Callback[13];
    private Callback[] _errorHandlers = new Callback[13];
    private Callback _prevExceptionHandler;
    private Callback _exceptionHandler;
    private SessionCallback _sessionCallback;
    private StreamContextResource _defaultStreamContext;
    private int _errorMask = 6135;
    private int _objectId = 0;
    private Logger _logger;
    private ImportMap _importMap;
    private TimeZone _defaultTimeZone;
    private Object _gzStream;
    private Env _oldThreadEnv;

    public Env(Quercus quercus, QuercusPage page, WriteStream out, HttpServletRequest request, HttpServletResponse response) {
        this._quercus = quercus;
        this._isStrict = quercus.isStrict();
        this._isUnicodeSemantics = quercus.isUnicodeSemantics();
        this._isAllowUrlInclude = quercus.isAllowUrlInclude();
        this._isAllowUrlFopen = quercus.isAllowUrlFopen();
        this._page = page;
        AbstractFunction[] defFuns = quercus.getFunctionMap();
        this._fun = (AbstractFunction[])_freeFunList.allocate();
        if (this._fun == null || this._fun.length != defFuns.length) {
            this._fun = new AbstractFunction[defFuns.length];
        }
        System.arraycopy(defFuns, 0, this._fun, 0, defFuns.length);
        ClassDef[] defClasses = quercus.getClassDefMap();
        this._classDef = (ClassDef[])_freeClassDefList.allocate();
        if (this._classDef == null || this._classDef.length != defClasses.length) {
            this._classDef = new ClassDef[defClasses.length];
        }
        this._qClass = (QuercusClass[])_freeClassList.allocate();
        if (this._qClass == null || this._qClass.length != defClasses.length) {
            this._qClass = new QuercusClass[defClasses.length];
        }
        this._originalOut = out;
        this._out = out;
        this._request = request;
        this._response = response;
        if (this._page != null) {
            this._page.init(this);
            this._page.importDefinitions(this);
        }
        this.setPwd(this._quercus.getPwd());
        if (this._page != null) {
            this.setSelfPath(this._page.getSelfPath(null));
            this._includeMap.put(this._selfPath, this._page);
        }
        if (this._request != null && this._request.getMethod().equals("POST")) {
            this._postArray = new ArrayValueImpl();
            this._files = new ArrayValueImpl();
            Post.fillPost(this, this._postArray, this._files, this._request, this.getIniBoolean("magic_quotes_gpc"));
        } else if (this._request != null && !this._request.getMethod().equals("GET")) {
            ServletInputStream is = null;
            try {
                is = this._request.getInputStream();
            }
            catch (IOException e) {
                this.warning(e);
            }
            StringValue bb = this.createBinaryBuilder();
            bb.appendReadAll((InputStream)is, Integer.MAX_VALUE);
            this.setInputData(bb);
        }
        this.addConstant("PHP_VERSION", OptionsModule.phpversion(this, null), true);
        if (response == null) {
            this.addConstant("STDOUT", this.wrapJava(new PhpStdout()), false);
            this.addConstant("STDERR", this.wrapJava(new PhpStderr()), false);
            this.addConstant("STDIN", this.wrapJava(new PhpStdin(this)), false);
        }
    }

    public Env(Quercus quercus) {
        this(quercus, null, null, null, null);
    }

    public static Env getInstance() {
        return _threadEnv.get();
    }

    public boolean isUnicodeSemantics() {
        return this._isUnicodeSemantics;
    }

    public String getScriptEncoding() {
        StringValue encoding = this.getIni("unicode.script_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            return this.getQuercus().getScriptEncoding();
        }
        return encoding.toString();
    }

    public String getRuntimeEncoding() {
        if (!this._isUnicodeSemantics) {
            return "iso-8859-1";
        }
        StringValue encoding = this.getIni("unicode.runtime_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            encoding = UTF8_STRING;
        }
        return encoding.toString();
    }

    public Value setRuntimeEncoding(String encoding) {
        return this.setIni("unicode.runtime_encoding", encoding);
    }

    public EncodingReader getRuntimeEncodingFactory() throws IOException {
        return Encoding.getReadFactory((String)this.getRuntimeEncoding());
    }

    public String getHttpInputEncoding() {
        if (!this._isUnicodeSemantics) {
            return null;
        }
        StringValue encoding = this.getIni("unicode.http_input_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            encoding = UTF8_STRING;
        }
        return encoding.toString();
    }

    public String getOutputEncoding() {
        if (!this._isUnicodeSemantics) {
            return null;
        }
        String encoding = Quercus.INI_UNICODE_OUTPUT_ENCODING.getAsString(this);
        if (encoding == null) {
            encoding = Quercus.INI_UNICODE_FALLBACK_ENCODING.getAsString(this);
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        return encoding;
    }

    public StringValue createBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createLargeBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new LargeStringBuilderValue();
    }

    public StringValue createBinaryBuilder(int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(length);
        }
        return new StringBuilderValue(length);
    }

    public StringValue createBinaryBuilder(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, offset, length);
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createBinaryBuilder(byte[] buffer) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, 0, buffer.length);
        }
        return new StringBuilderValue(buffer, 0, buffer.length);
    }

    public StringValue createUnicodeBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public TimeZone getDefaultTimeZone() {
        return this._defaultTimeZone;
    }

    public void setDefaultTimeZone(String id) {
        this._defaultTimeZone = TimeZone.getTimeZone(id);
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
    }

    public ServletContext getServletContext() {
        return this._quercus.getServletContext();
    }

    public void setScriptContext(ScriptContext context) {
        this._scriptContext = context;
    }

    public StringValue getInputData() {
        return this._inputData;
    }

    public void setInputData(StringValue data) {
        this._inputData = data;
    }

    public final boolean isStrict() {
        return this._isStrict;
    }

    public boolean isAllowUrlInclude() {
        return this._isAllowUrlInclude;
    }

    public boolean isAllowUrlFopen() {
        return this._isAllowUrlFopen;
    }

    public int getConnectionStatus() {
        return 0;
    }

    public void start() {
        this._oldThreadEnv = _threadEnv.get();
        this._startTime = Alarm.getCurrentTime();
        this._timeLimit = this.getIniLong("max_execution_time") * 1000L;
        _threadEnv.set(this);
        String encoding = this.getOutputEncoding();
        String type = this.getIniString("default_mimetype");
        if (!"".equals(type) && this._response != null) {
            if (encoding != null) {
                this._response.setContentType(type + "; charset=" + encoding);
            } else {
                this._response.setContentType(type);
            }
        }
        if (this._out != null && encoding != null) {
            try {
                this._out.setEncoding(encoding);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        HashSet<ModuleStartupListener> listeners = this._quercus.getModuleStartupListeners();
        for (ModuleStartupListener listener : listeners) {
            listener.startup(this);
        }
    }

    public void addCleanup(EnvCleanup envCleanup) {
        this._cleanupList.add(envCleanup);
    }

    public void addObjectCleanup(ObjectExtValue objCleanup) {
        this._objCleanupList.add(objCleanup);
    }

    public void removeCleanup(EnvCleanup envCleanup) {
        for (int i = this._cleanupList.size() - 1; i >= 0; --i) {
            EnvCleanup res = this._cleanupList.get(i);
            if (!envCleanup.equals(res)) continue;
            this._cleanupList.remove(i);
            break;
        }
    }

    public Quercus getQuercus() {
        return this._quercus;
    }

    public ModuleContext getModuleContext() {
        return this._quercus.getModuleContext();
    }

    public DataSource getDatabase() {
        return this._quercus.getDatabase();
    }

    protected final DataSource findDatabase(String driver, String url) throws Exception {
        return this._quercus.findDatabase(driver, url);
    }

    public ConnectionEntry getConnection(String driver, String url, String userName, String password, boolean isReuse) throws Exception {
        isReuse = false;
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            userName = null;
            password = null;
        } else {
            database = this.findDatabase(driver, url);
            if (database == null) {
                return null;
            }
        }
        ConnectionEntry entry = new ConnectionEntry(this);
        entry.init(database, userName, password);
        ConnectionEntry oldEntry = null;
        if (isReuse) {
            oldEntry = this._connMap.get(entry);
        }
        if (oldEntry != null && oldEntry.isReusable()) {
            return oldEntry;
        }
        entry.connect(isReuse);
        if (isReuse) {
            this._connMap.put(entry, entry);
        }
        return entry;
    }

    public DataSource getDataSource(String driver, String url) throws Exception {
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            return database;
        }
        return this.findDatabase(driver, url);
    }

    public void setTimeLimit(long ms) {
        if (ms <= 0L) {
            ms = 0x3FFFFFFFFFFFFFFFL;
        }
        this._timeLimit = ms;
    }

    public final void checkTimeout() {
        long now = Alarm.getCurrentTime();
        if (this._timeLimit > 0L && this._startTime + this._timeLimit < now) {
            throw new QuercusRuntimeException(L.l("script timed out"));
        }
    }

    public void resetTimeout() {
        this._startTime = Alarm.getCurrentTime();
    }

    public WriteStream getOut() {
        return this._out;
    }

    public WriteStream getOriginalOut() {
        return this._originalOut;
    }

    public final void flush() {
        try {
            this.getOut().flush();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(String v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char[] buffer, int offset, int length) {
        try {
            this.getOut().print(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(long v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(double v) {
        try {
            long longV = (long)v;
            if (v == (double)longV) {
                this.getOut().print(longV);
            } else {
                this.getOut().print(v);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Object v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Value v) {
        v.print(this);
    }

    public final void println() {
        try {
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(String v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Value v) {
        try {
            v.print(this);
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Object v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void write(byte[] buffer, int offset, int length) {
        try {
            this.getOut().write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public OutputBuffer getOutputBuffer() {
        return this._outputBuffer;
    }

    public void pushOutputBuffer(Callback callback, int chunkSize, boolean erase) {
        this._outputBuffer = this._outputBuffer == null ? new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase) : new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase);
        this._out = this._outputBuffer.getOut();
    }

    public boolean popOutputBuffer() {
        OutputBuffer outputBuffer = this._outputBuffer;
        if (outputBuffer == null) {
            return false;
        }
        outputBuffer.close();
        this._outputBuffer = outputBuffer.getNext();
        this._out = this._outputBuffer != null ? this._outputBuffer.getOut() : this._originalOut;
        return true;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public Path getWorkDir() {
        return this._quercus.getWorkDir();
    }

    public void setPwd(Path path) {
        this._pwd = path;
        this._lookupCache.clear();
    }

    public Path getSelfPath() {
        return this._selfPath;
    }

    public Path getSelfDirectory() {
        return this._selfDirectory;
    }

    public void setSelfPath(Path path) {
        this._selfPath = path;
        this._selfDirectory = this._selfPath.getParent();
    }

    public Path getUploadDirectory() {
        if (this._uploadPath == null) {
            String realPath = this.getIniString("upload_tmp_dir");
            if (realPath == null) {
                realPath = this.getRequest().getRealPath("/WEB-INF/upload");
            }
            this._uploadPath = this._quercus.getPwd().lookup(realPath);
            try {
                if (!this._uploadPath.isDirectory()) {
                    this._uploadPath.mkdirs();
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this._uploadPath = this._uploadPath.createRoot();
        }
        return this._uploadPath;
    }

    public Path getTempDirectory() {
        if (this._tmpPath == null) {
            String realPath = this.getRequest() != null ? this.getRequest().getRealPath("/WEB-INF/tmp") : "file:/tmp";
            this._tmpPath = this.getPwd().lookup(realPath);
            try {
                if (!this._tmpPath.isDirectory()) {
                    this._tmpPath.mkdirs();
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._tmpPath;
    }

    public void addRemovePath(Path path) {
        if (this._removePaths == null) {
            this._removePaths = new ArrayList();
        }
        this._removePaths.add(path);
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    public void setSessionCallback(SessionCallback callback) {
        this._sessionCallback = callback;
    }

    public SessionCallback getSessionCallback() {
        return this._sessionCallback;
    }

    public SessionArrayValue getSession() {
        return this._session;
    }

    public HttpSession getJavaSession() {
        return this._javaSession;
    }

    public void setSession(SessionArrayValue session) {
        this._session = session;
        if (session != null) {
            Var var = this.getGlobalVar("_SESSION");
            if (!(var instanceof SessionVar)) {
                var = new SessionVar();
                this.setGlobalValue("_SESSION", var);
            }
            ((Value)var).set(session);
            this.setGlobalValue("HTTP_SESSION_VARS", session);
            session.addUse();
        } else {
            Var v = this.getGlobalVar("_SESSION");
            if (v != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
            if ((v = this.getGlobalVar("HTTP_SESSION_VARS")) != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
        }
    }

    public String generateSessionId() {
        String sessionId = this._quercus.getQuercusSessionManager().createSessionId(this);
        if (this._javaSession != null) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        return sessionId;
    }

    public SessionArrayValue createSession(String sessionId, boolean create) {
        Value unserialize;
        StringValue value;
        long now = Alarm.getCurrentTime();
        SessionCallback callback = this.getSessionCallback();
        this._javaSession = this._request.getSession(true);
        if (create && this._javaSession.getId().length() >= 3 && sessionId.length() >= 3) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        SessionArrayValue session = this._quercus.loadSession(this, sessionId);
        if (callback != null && (value = callback.read(this, sessionId)) != null && value.length() != 0 && (unserialize = VariableModule.unserialize(this, value)) instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)unserialize;
            session.reset(now);
            session.putAll(arrayValue);
        }
        this.setSession(session);
        return session;
    }

    public void destroySession(String sessionId) {
        SessionCallback callback = this.getSessionCallback();
        if (callback != null) {
            callback.destroy(this, sessionId);
        } else {
            this._quercus.destroySession(sessionId);
        }
        this.setSession(null);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("quercus.quercus");
        }
        return this._logger;
    }

    public Value getConfigVar(String name) {
        return this.getIniDefinition(name).getValue(this._quercus);
    }

    public IdentityHashMap<String, Value> getIniMap(boolean create) {
        if (this._iniMap == null && create) {
            this._iniMap = new IdentityHashMap();
        }
        return this._iniMap;
    }

    public StringValue setIni(String name, Value value) {
        ++this._iniCount;
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue setIni(String name, String value) {
        ++this._iniCount;
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue getIni(String name) {
        return this.getIniDefinition(name).getAsStringValue(this);
    }

    private IniDefinition getIniDefinition(String name) {
        return this._quercus.getIniDefinitions().get(name);
    }

    public boolean getIniBoolean(String name) {
        return this.getIniDefinition(name).getAsBoolean(this);
    }

    public long getIniLong(String name) {
        return this.getIniDefinition(name).getAsLong(this);
    }

    public String getIniString(String name) {
        return this.getIniDefinition(name).getAsString(this);
    }

    public long getIniBytes(String name, long deflt) {
        return this.getIniDefinition(name).getAsLongBytes(this, deflt);
    }

    public ByteToChar getByteToChar() {
        return ByteToChar.create();
    }

    public Value getThis() {
        return this._this;
    }

    public Value setThis(Value value) {
        Value oldThis = this._this;
        this._this = value.toValue();
        return oldThis;
    }

    public Value getValue(String name) {
        Var var = this.getRef(name);
        if (var != null) {
            return var.toValue();
        }
        return NullValue.NULL;
    }

    public Object getSpecialValue(String name) {
        return this._specialMap.get(name);
    }

    public Value getGlobalValue(String name) {
        Var var = this.getGlobalRef(name);
        if (var != null) {
            return var.toValue();
        }
        return NullValue.NULL;
    }

    public final Var getVar(String name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        Var var = this._map.get(name);
        if (var != null) {
            return var;
        }
        var = this.getRef(name);
        if (var == null) {
            var = new Var();
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
            this._map.put(name, var);
        }
        return var;
    }

    public final Var getGlobalVar(String name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        Var var = this._globalMap.get(name);
        if (var != null) {
            return var;
        }
        var = this.getSuperGlobalRef(name);
        if (var == null) {
            var = this.getGlobalScriptContextRef(name);
        }
        if (var == null) {
            var = new Var();
            var.setGlobal();
        }
        this._globalMap.put(name, var);
        return var;
    }

    public final String createStaticName() {
        return this._quercus.createStaticName();
    }

    public final Var getStaticVar(String name) {
        Var var = this._staticMap.get(name);
        if (var == null) {
            var = new Var();
            var.setGlobal();
            this._staticMap.put(name, var);
        }
        return var;
    }

    public final Var unsetVar(String name) {
        this._map.remove(name);
        return null;
    }

    public final Var setVar(String name, Value value) {
        Var var;
        if (value instanceof Var) {
            var = (Var)value;
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
        } else {
            var = new Var(value.toValue());
        }
        this._map.put(name, var);
        return var;
    }

    public final Var unsetLocalVar(String name) {
        this._map.remove(name);
        return null;
    }

    public final Var unsetGlobalVar(String name) {
        Var oldVar = this._globalMap.remove(name);
        if (oldVar != null) {
            oldVar.set(UnsetValue.UNSET);
        }
        return null;
    }

    public static final Value getLocalVar(Value var) {
        if (var == null) {
            var = new Var();
        }
        return var;
    }

    public static final Value getLocalValue(Value var) {
        if (var != null) {
            return var;
        }
        return NullValue.NULL;
    }

    public static final Value setLocalVar(Value var, Value value) {
        value = value.toValue();
        if (var instanceof Var) {
            var.set(value);
        }
        return value;
    }

    public Var getRef(String name) {
        Var var = this._map.get(name);
        if (var == null && (var = this.getSuperGlobalRef(name)) == null) {
            var = this.getGlobalScriptContextRef(name);
        }
        return var;
    }

    public Var getGlobalRaw(String name) {
        return this._globalMap.get(name);
    }

    public Var getGlobalRef(String name) {
        Var var = this._globalMap.get(name);
        if (var == null) {
            var = this.getSuperGlobalRef(name);
            if (var == null) {
                var = this.getGlobalScriptContextRef(name);
            }
            if (var == null) {
                var = new Var();
            }
            this._globalMap.put(name, var);
        }
        return var;
    }

    /*
     * WARNING - void declaration
     */
    private Var getSuperGlobalRef(String name) {
        switch (SPECIAL_VARS.get((Object)name)) {
            case 14: {
                Var var = new Var();
                this._globalMap.put(name, var);
                var.set(new ArrayValueImpl());
                return var;
            }
            case 9: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 3: {
                Var var = new Var();
                this._globalMap.put(name, var);
                ArrayValueImpl post = new ArrayValueImpl();
                var.set(post);
                if (this._request == null) {
                    return null;
                }
                if (!"POST".equals(this._request.getMethod())) {
                    return var;
                }
                if (this._postArray != null) {
                    for (Map.Entry<Value, Value> entry : this._postArray.entrySet()) {
                        post.put(entry.getKey(), entry.getValue());
                    }
                }
                return var;
            }
            case 13: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 12: {
                Var var = new Var();
                this._globalMap.put(name, var);
                ArrayValueImpl files = new ArrayValueImpl();
                if (this._files != null) {
                    for (Map.Entry<Value, Value> entry : this._files.entrySet()) {
                        files.put(entry.getKey(), entry.getValue());
                    }
                }
                var.set(files);
                return var;
            }
            case 8: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 2: {
                Var var = new Var();
                ArrayValueImpl array = new ArrayValueImpl();
                var.set(array);
                this._globalMap.put(name, var);
                if (this._request == null) {
                    return var;
                }
                String queryString = this._request.getQueryString();
                if (queryString == null) {
                    return var;
                }
                StringUtility.parseStr(this, queryString, array, true, this.getHttpInputEncoding());
                return var;
            }
            case 6: {
                void var7_34;
                Var var = new Var();
                ArrayValueImpl array = new ArrayValueImpl();
                var.set(array);
                this._globalMap.put(name, var);
                if (this._request == null) {
                    return var;
                }
                try {
                    String encoding = this.getHttpInputEncoding();
                    if (encoding == null) {
                        encoding = "iso-8859-1";
                    }
                    this._request.setCharacterEncoding(encoding);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                ArrayList keys = new ArrayList();
                keys.addAll(this._request.getParameterMap().keySet());
                Collections.sort(keys);
                boolean isMagicQuotes = this.getIniBoolean("magic_quotes_gpc");
                for (String string : keys) {
                    String[] value = this._request.getParameterValues(string);
                    Post.addFormValue(this, array, string, value, isMagicQuotes);
                }
                if (name.equals("_REQUEST") && this._postArray != null) {
                    for (Map.Entry entry : this._postArray.entrySet()) {
                        Value key = (Value)entry.getKey();
                        Value value = (Value)entry.getValue();
                        Value existingValue = ((ArrayValue)array).get(key);
                        if (existingValue.isArray() && value.isArray()) {
                            existingValue.toArrayValue(this).putAll(value.toArrayValue(this));
                            continue;
                        }
                        array.put((Value)entry.getKey(), ((Value)entry.getValue()).copy());
                    }
                }
                Cookie[] cookies = this._request.getCookies();
                boolean bl = false;
                while (cookies != null && var7_34 < cookies.length) {
                    Cookie cookie = cookies[var7_34];
                    String decodedValue = Env.decodeValue(cookie.getValue());
                    Post.addFormValue(this, array, cookie.getName(), new String[]{decodedValue}, isMagicQuotes);
                    ++var7_34;
                }
                return var;
            }
            case 16: {
                if (!Quercus.INI_ALWAYS_POPULATE_RAW_POST_DATA.getAsBoolean(this)) {
                    return null;
                }
                if (this._inputData == null) {
                    return null;
                }
                Var var = new Var();
                this._globalMap.put(name, var);
                var.set(this._inputData);
                return var;
            }
            case 15: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 1: {
                Var var = new Var();
                this._globalMap.put(name, var);
                var.set(new ServerArrayValue(this));
                return var;
            }
            case 5: {
                Var var = new Var();
                this._globalMap.put(name, var);
                var.set(new GlobalArrayValue(this));
                return var;
            }
            case 10: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 4: {
                Var var = new Var();
                this._globalMap.put(name, var);
                if (this._request == null) {
                    return var;
                }
                ArrayValueImpl array = new ArrayValueImpl();
                Cookie[] cookies = this._request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        Cookie cookie = cookies[i];
                        String string = Env.decodeValue(cookie.getValue());
                        StringValue valueAsValue = this.createString(string);
                        if (this.getIniBoolean("magic_quotes_gpc")) {
                            valueAsValue = StringModule.addslashes(valueAsValue);
                        }
                        ((ArrayValue)array).append(this.createString(cookie.getName()), valueAsValue);
                    }
                }
                var.set(array);
                return var;
            }
            case 7: {
                Var var = this._globalMap.get("_SESSION");
                return var;
            }
            case 11: {
                Var var = new Var();
                this._globalMap.put(name, var);
                var.set(this.getGlobalVar("_SERVER").get(PHP_SELF_STRING));
                return var;
            }
        }
        return null;
    }

    protected Var getGlobalSpecialRef(String name) {
        Var var = null;
        if (this._map != this._globalMap && (var = this._globalMap.get(name)) != null) {
            return var;
        }
        var = this.getSuperGlobalRef(name);
        return var;
    }

    protected Var getGlobalScriptContextRef(String name) {
        Bindings bindings;
        if (this._scriptContext == null) {
            return null;
        }
        Var var = this._globalMap.get(name);
        if (var != null) {
            return var;
        }
        Object value = this._scriptContext.getAttribute(name);
        if (value == null && (bindings = this._scriptContext.getBindings(100)) != null) {
            value = bindings.get(name);
        }
        if (value == null && (bindings = this._scriptContext.getBindings(200)) != null) {
            value = bindings.get(name);
        }
        if (value != null) {
            var = new Var();
            this._globalMap.put(name, var);
            var.set(this.wrapJava(value));
        }
        return var;
    }

    private static String decodeValue(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            if (ch == '+') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public Var getVar(String name) {
        Var var = this._map.get(name);
        if (var != null) {
            return var;
        }
        var = this.getRef(name);
        if (var == null) {
            var = new Var();
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
            this._map.put(name, var);
        }
        return var;
    }

    public Var getGlobalVar(String name) {
        Var var = this.getGlobalRef(name);
        if (var == null) {
            var = new Var();
            var.setGlobal();
            this._globalMap.put(name, var);
        }
        return var;
    }

    public boolean isGlobalEnv() {
        return this._map == this._globalMap;
    }

    public Value setValue(String name, Value value) {
        if (value instanceof Var) {
            this._map.put(name, (Var)value);
        } else {
            Var var = this.getVar(name);
            var.set(value);
        }
        return value;
    }

    public Object setSpecialValue(String name, Object value) {
        this._specialMap.put(name, value);
        return value;
    }

    public Value setGlobalValue(String name, Value value) {
        if (value instanceof Var) {
            this._globalMap.put(name, (Var)value);
        } else {
            Var var = this.getGlobalVar(name);
            var.set(value);
        }
        return value;
    }

    public Value getStaticClassFieldValue(String className, String name) {
        Var var = this.getStaticClassFieldVar(className, name);
        if (var != null) {
            Value val = var.toValue();
            return val;
        }
        return NullValue.NULL;
    }

    public final Var getStaticClassFieldVar(String className, String name) {
        QuercusClass cl = this.findAbstractClass(className);
        Var var = cl.getStaticField(this, name);
        if (var == null) {
            this.error(L.l("{0}::${1} is an undeclared static property", (Object)className, (Object)name));
        }
        return var;
    }

    public void pushCall(Expr call, Value obj, Value[] args) {
        if (this._callStack.length <= this._callStackTop) {
            Expr[] newStack = new Expr[2 * this._callStack.length];
            System.arraycopy(this._callStack, 0, newStack, 0, this._callStack.length);
            this._callStack = newStack;
            Value[] newThisStack = new Value[2 * this._callThisStack.length];
            System.arraycopy(this._callThisStack, 0, newThisStack, 0, this._callThisStack.length);
            Value[] newArgStack = new Value[2 * this._callArgStack.length];
            System.arraycopy(this._callArgStack, 0, newArgStack, 0, this._callArgStack.length);
            this._callThisStack = newThisStack;
        }
        this._callStack[this._callStackTop] = call;
        this._callThisStack[this._callStackTop] = obj;
        this._callArgStack[this._callStackTop] = args;
        ++this._callStackTop;
    }

    public Expr popCall() {
        return this._callStack[--this._callStackTop];
    }

    public int getCallDepth() {
        return this._callStackTop;
    }

    public Expr peekCall(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public Value peekCallThis(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callThisStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public Value[] peekArgs(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callArgStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public boolean pushFieldGet(String className, StringValue fieldName) {
        FieldGetEntry entry = new FieldGetEntry(className, fieldName);
        if (this._fieldGetList.contains(entry)) {
            return false;
        }
        this._fieldGetList.add(entry);
        return true;
    }

    public void popFieldGet(String className, StringValue fieldName) {
        FieldGetEntry entry = new FieldGetEntry(className, fieldName);
        if (this._fieldGetList.size() > 0) {
            this._fieldGetList.removeLast();
        }
    }

    public QuercusClass getCallingClass() {
        return this._callingClass;
    }

    public QuercusClass setCallingClass(QuercusClass cls) {
        QuercusClass oldCallingClass = this._callingClass;
        this._callingClass = cls;
        return oldCallingClass;
    }

    public ArrayList<String> getStackTrace() {
        ArrayList<String> trace = new ArrayList<String>();
        for (int i = this._callStackTop - 1; i >= 0; --i) {
            Location location = this._callStack[i].getLocation();
            String loc = location != null && location.getFileName() != null ? " (at " + location.getFileName() + ":" + location.getLineNumber() + ")" : "";
            String entry = this._callThisStack[i] != null && !"".equals(this._callThisStack[i].toString()) ? this._callThisStack[i] + "." + this._callStack[i].toString() + loc : this._callStack[i].toString() + loc;
            trace.add(entry);
        }
        return trace;
    }

    public HashMap<String, Var> pushEnv(HashMap<String, Var> map) {
        HashMap<String, Var> oldEnv = this._map;
        this._map = map;
        return oldEnv;
    }

    public void popEnv(HashMap<String, Var> oldEnv) {
        this._map = oldEnv;
    }

    public HashMap<String, Var> getEnv() {
        return this._map;
    }

    public HashMap<String, Var> getGlobalEnv() {
        return this._globalMap;
    }

    public final Value[] setFunctionArgs(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        Value[] newArgs = new Value[args.length];
        for (int i = 0; args != null && i < args.length; ++i) {
            newArgs[i] = args[i].toValue().toArgValue();
        }
        this._functionArgs = newArgs;
        return oldArgs;
    }

    public final Value[] setFunctionArgsNoCopy(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        for (int i = 0; args != null && i < args.length; ++i) {
            args[i] = args[i].toValue();
        }
        this._functionArgs = args;
        return oldArgs;
    }

    public final void restoreFunctionArgs(Value[] args) {
        this._functionArgs = args;
    }

    public final Value[] getFunctionArgs() {
        return this._functionArgs;
    }

    public Object removeSpecialValue(String name) {
        return this._specialMap.remove(name);
    }

    public Value getConstant(String name) {
        Value value = this.getConstantImpl(name);
        if (value != null) {
            return value;
        }
        value = this.createString(name);
        return value;
    }

    public boolean isDefined(String name) {
        return this.getConstantImpl(name) != null;
    }

    private Value getConstantImpl(String name) {
        Value value = this._constMap.get(name);
        if (value != null) {
            return value;
        }
        value = this._quercus.getConstant(name);
        if (value != null) {
            return value;
        }
        if (this._lowerConstMap != null && (value = this._lowerConstMap.get(name.toLowerCase())) != null) {
            return value;
        }
        return null;
    }

    public Value removeConstant(String name) {
        return this._constMap.remove(name);
    }

    public Value addConstant(String name, Value value, boolean isCaseInsensitive) {
        Value oldValue = this._constMap.get(name);
        if (oldValue != null) {
            return oldValue;
        }
        this._constMap.put(name, value);
        if (this._lowerConstMap != null && isCaseInsensitive) {
            this._lowerConstMap.put(name.toLowerCase(), value);
        }
        return value;
    }

    public ArrayValue getDefinedConstants() {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Map.Entry<String, Value> entry : this._quercus.getConstMap().entrySet()) {
            result.put(this.createString(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, Value> entry : this._constMap.entrySet()) {
            result.put(this.createString(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public boolean isExtensionLoaded(String name) {
        return this.getQuercus().isExtensionLoaded(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this.getQuercus().getLoadedExtensions();
    }

    public Value getExtensionFuncs(String name) {
        return this.getQuercus().getExtensionFuncs(name);
    }

    public StreamContextResource getDefaultStreamContext() {
        if (this._defaultStreamContext == null) {
            this._defaultStreamContext = new StreamContextResource();
        }
        return this._defaultStreamContext;
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl funs = new ArrayValueImpl();
        ArrayValueImpl system = new ArrayValueImpl();
        ArrayValueImpl user = new ArrayValueImpl();
        AbstractFunction[] systemFuns = this._quercus.getFunctionMap();
        AbstractFunction[] envFuns = this._fun;
        for (int i = 0; i < envFuns.length; ++i) {
            if (i < systemFuns.length && systemFuns[i] != null && !(systemFuns[i] instanceof UndefinedFunction)) {
                system.append(this.createString(systemFuns[i].getName()));
                continue;
            }
            if (envFuns[i] == null || envFuns[i] instanceof UndefinedFunction) continue;
            user.append(this.createString(envFuns[i].getName()));
        }
        funs.append(this.createString("internal"), system);
        funs.append(this.createString("user"), user);
        return funs;
    }

    public AbstractFunction findFunction(String name) {
        int id = this._quercus.findFunctionId(name);
        if (id >= 0) {
            if (id < this._fun.length && !(this._fun[id] instanceof UndefinedFunction)) {
                return this._fun[id];
            }
            return null;
        }
        AbstractFunction fun = this._quercus.findFunctionImpl(name);
        if (fun != null) {
            return fun;
        }
        if (this.isStrict()) {
            return null;
        }
        id = this._quercus.findFunctionId(name = name.toLowerCase());
        if (id >= 0) {
            if (id < this._fun.length && !(this._fun[id] instanceof UndefinedFunction)) {
                return this._fun[id];
            }
            return null;
        }
        fun = this._quercus.findLowerFunctionImpl(name);
        if (fun != null) {
            return fun;
        }
        if (this._anonymousFunMap != null) {
            return this._anonymousFunMap.get(name);
        }
        return null;
    }

    public AbstractFunction getFunction(String name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun != null) {
            return fun;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown function.", (Object)name));
    }

    public void updateFunction(int id, AbstractFunction fun) {
        if (this._fun.length <= id) {
            AbstractFunction[] oldFun = this._fun;
            this._fun = new AbstractFunction[id + 256];
            System.arraycopy(oldFun, 0, this._fun, 0, oldFun.length);
        }
        if (this._fun[id] == null) {
            this._fun[id] = fun;
        }
    }

    public AbstractFunction getFunction(Value name) {
        if ((name = name.toValue()) instanceof CallbackFunction) {
            return ((CallbackFunction)name).getFunction();
        }
        return this.getFunction(name.toString());
    }

    public Value addFunction(String name, AbstractFunction fun) {
        AbstractFunction staticFun = this._quercus.findLowerFunctionImpl(name.toLowerCase());
        if (staticFun != null) {
            throw new QuercusException(L.l("can't redefine function {0}", (Object)name));
        }
        int id = this._quercus.getFunctionId(name);
        if (this._fun.length <= id) {
            AbstractFunction[] funMap = new AbstractFunction[id + 256];
            System.arraycopy(this._fun, 0, funMap, 0, this._fun.length);
            this._fun = funMap;
        }
        if (this._fun[id] != null && !(this._fun[id] instanceof UndefinedFunction)) {
            throw new QuercusException(L.l("can't redefine function {0}", (Object)name));
        }
        this._fun[id] = fun;
        return BooleanValue.TRUE;
    }

    public AbstractFunction createAnonymousFunction(String args, String code) throws IOException {
        log.log(Level.FINE, code);
        if (this._anonymousFunMap == null) {
            this._anonymousFunMap = new HashMap();
        }
        String name = "\u0000lamba" + (this._anonymousFunMap.size() + 1);
        AbstractFunction fun = this.getQuercus().parseFunction(name, args, code);
        this._anonymousFunMap.put(name, fun);
        return fun;
    }

    public Value addFunctionFromPage(String name, String lowerName, AbstractFunction fun) {
        return BooleanValue.TRUE;
    }

    public AbstractFunction findMethod(String className, String methodName) {
        QuercusClass cl = this.findClass(className);
        if (cl == null) {
            this.error(L.l("'{0}' is an unknown class.", (Object)className));
            return null;
        }
        AbstractFunction fun = cl.findFunction(methodName);
        if (fun == null) {
            this.error(L.l("'{0}::{1}' is an unknown method.", (Object)className, (Object)methodName));
            return null;
        }
        return fun;
    }

    public Value evalCode(String code) throws IOException {
        Quercus quercus;
        QuercusProgram program;
        Value value;
        if (log.isLoggable(Level.FINER)) {
            log.finer(code);
        }
        if ((value = (program = (quercus = this.getQuercus()).parseEvalExpr(code)).execute(this)) == null) {
            return NullValue.NULL;
        }
        return value;
    }

    public Value call(String name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this);
    }

    public Value call(String name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this, a0);
    }

    public Value call(String name, Value a0, Value a1) {
        return this.getFunction(name).call(this, a0, a1);
    }

    public Value call(String name, Value a0, Value a1, Value a2) {
        return this.getFunction(name).call(this, a0, a1, a2);
    }

    public Value call(String name, Value a0, Value a1, Value a2, Value a3) {
        return this.getFunction(name).call(this, a0, a1, a2, a3);
    }

    public Value call(String name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this.getFunction(name).call(this, a0, a1, a2, a3, a4);
    }

    public Value call(String name, Value[] args) {
        return this.getFunction(name).call(this, args);
    }

    public Value callRef(String name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this);
    }

    public Value callRef(String name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0);
    }

    public Value callRef(String name, Value a0, Value a1) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3, a4);
    }

    public Value callRef(String name, Value[] args) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, args);
    }

    public void addClassDef(String name, ClassDef cl) {
        int id = this._quercus.getClassId(name);
        if (this._classDef.length <= id) {
            ClassDef[] def = new ClassDef[id + 256];
            System.arraycopy(this._classDef, 0, def, 0, this._classDef.length);
            this._classDef = def;
        }
        if (this._classDef[id] == null) {
            this._classDef[id] = cl;
        }
    }

    public ClassDef findClassDef(String name) {
        int id = this._quercus.getClassId(name);
        if (id < this._classDef.length) {
            return this._classDef[id];
        }
        return null;
    }

    public ObjectValue createObject() {
        try {
            return (ObjectValue)this._quercus.getStdClass().createObject(this);
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public ObjectValue createIncompleteObject(String name) {
        try {
            ObjectValue obj = (ObjectValue)this._quercus.getStdClass().createObject(this);
            obj.setIncompleteObjectName(name);
            return obj;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue getEmptyString() {
        if (this._isUnicodeSemantics) {
            return UnicodeBuilderValue.EMPTY;
        }
        return StringBuilderValue.EMPTY;
    }

    public StringValue createStringBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createString(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeValueImpl(new String(buffer, offset, length));
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createString(char[] buffer, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, length);
        }
        return new StringBuilderValue(buffer, 0, length);
    }

    public StringValue createString(char[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, offset, length);
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createString(String s) {
        if (s == null || s.length() == 0) {
            return this._isUnicodeSemantics ? UnicodeBuilderValue.EMPTY : StringBuilderValue.EMPTY;
        }
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(s);
        }
        return new StringBuilderValue(s);
    }

    public StringValue createString(char ch) {
        if (this._isUnicodeSemantics) {
            return UnicodeValueImpl.create(ch);
        }
        return StringBuilderValue.create(ch);
    }

    public StringValue createBinaryString(TempBuffer head) {
        StringValue string = this._isUnicodeSemantics ? new BinaryBuilderValue() : new StringBuilderValue();
        while (head != null) {
            string.append(head.getBuffer(), 0, head.getLength());
            head = head.getNext();
        }
        return string;
    }

    public Value createException(Throwable e) {
        QuercusClass cls = this.findClass("Exception");
        StringValue message = this.createString(e.getMessage());
        Value[] args = new Value[]{message};
        Value value = cls.callNew(this, args);
        StackTraceElement elt = e.getStackTrace()[0];
        value.putField(this, "file", (Value)this.createString(elt.getFileName()));
        value.putField(this, "line", (Value)LongValue.create(elt.getLineNumber()));
        value.putField(this, "trace", ErrorModule.debug_backtrace(this));
        return value;
    }

    public int generateId() {
        return ++this._objectId;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        JavaClassDef def = this.getJavaClassDefinition(className, true);
        if (def != null) {
            return def;
        }
        throw this.createErrorException(L.l("'{0}' class definition not found", (Object)className));
    }

    public JavaClassDef getJavaClassDefinition(Class type) {
        JavaClassDef def = this._quercus.getJavaClassDefinition(type, type.getName());
        return def;
    }

    private JavaClassDef getJavaClassDefinition(String className, boolean useImport) {
        JavaClassDef def = null;
        try {
            def = this._quercus.getJavaClassDefinition(className);
        }
        catch (Throwable e) {
            if (useImport) {
                def = this.importJavaClass(className);
            }
            log.log(Level.FINER, e.toString(), e);
        }
        return def;
    }

    public JavaClassDef importJavaClass(String className) {
        if (this._importMap == null) {
            return null;
        }
        String fullName = this._importMap.getQualified(className);
        if (fullName != null) {
            return this.getJavaClassDefinition(fullName, false);
        }
        ArrayList<String> wildcardList = this._importMap.getWildcardList();
        for (String entry : wildcardList) {
            fullName = entry + '.' + className;
            JavaClassDef def = this.getJavaClassDefinition(fullName, false);
            if (def == null) continue;
            this._importMap.putQualified(className, fullName);
            return def;
        }
        return null;
    }

    public void putQualifiedImport(String javaName) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        String phpName = this._importMap.putQualified(javaName);
    }

    public void addWildcardImport(String name) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        this._importMap.addWildcardImport(name);
    }

    public Value wrapJava(Object obj, boolean isNullAsFalse) {
        if (obj == null) {
            if (isNullAsFalse) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        return this.wrapJava(obj);
    }

    public Value wrapJava(Object obj, JavaClassDef def, boolean isNullAsFalse) {
        if (obj == null) {
            if (isNullAsFalse) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        return this.wrapJava(obj, def);
    }

    public Value wrapJava(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        JavaClassDef def = this.getJavaClassDefinition(obj.getClass());
        return def.wrap(this, obj);
    }

    public Value wrapJava(Object obj, JavaClassDef def) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (def.getType() != obj.getClass()) {
            def = this.getJavaClassDefinition(obj.getClass());
        }
        return def.wrap(this, obj);
    }

    public QuercusClass findClass(String name) {
        return this.findClass(name, true, true);
    }

    public QuercusClass findClass(String name, boolean useAutoload, boolean useImport) {
        QuercusClass cl = this._classMap.get(name);
        if (cl != null) {
            return cl;
        }
        cl = this._lowerClassMap.get(name.toLowerCase());
        if (cl != null) {
            return cl;
        }
        cl = this.createClassFromCache(name, useAutoload, useImport);
        if (cl != null) {
            this._classMap.put(cl.getName(), cl);
            this._lowerClassMap.put(cl.getName().toLowerCase(), cl);
            cl.init(this);
            return cl;
        }
        return this.findClassExt(name, useAutoload, useImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuercusClass findClassExt(String name, boolean useAutoload, boolean useImport) {
        if (useAutoload) {
            StringValue nameString = this.createString(name);
            if (!this._autoloadClasses.contains(name)) {
                try {
                    this._autoloadClasses.add(name);
                    int size = this._autoloadList != null ? this._autoloadList.size() : 0;
                    for (int i = 0; i < size; ++i) {
                        Callback cb = this._autoloadList.get(i);
                        cb.call(this, nameString);
                        QuercusClass cls = this.findClass(name, false, useImport);
                        if (cls == null) continue;
                        QuercusClass quercusClass = cls;
                        return quercusClass;
                    }
                    if (size == 0) {
                        if (this._autoload == null) {
                            this._autoload = this.findFunction("__autoload");
                        }
                        if (this._autoload != null) {
                            this._autoload.call(this, nameString);
                            QuercusClass quercusClass = this.findClass(name, false, useImport);
                            return quercusClass;
                        }
                    }
                }
                finally {
                    this._autoloadClasses.remove(name);
                }
            }
        }
        if (useImport) {
            if (this.importPhpClass(name)) {
                return this.findClass(name, false, false);
            }
            try {
                JavaClassDef javaClassDef = this.getJavaClassDefinition(name, true);
                if (javaClassDef != null) {
                    QuercusClass cls = this.createQuercusClass(javaClassDef, null);
                    this._classMap.put(cls.getName(), cls);
                    this._lowerClassMap.put(cls.getName().toLowerCase(), cls);
                    cls.init(this);
                    return cls;
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    public void addClass(String name, ClassDef def) {
        for (String iface : def.getInterfaces()) {
            QuercusClass cl = this.findClass(iface);
        }
        QuercusClass parentClass = null;
        if (this.findClass(name, false, false) == null) {
            String parentName = def.getParentName();
            if (parentName != null) {
                parentClass = this.findAbstractClass(parentName);
            }
            QuercusClass qClass = this.createQuercusClass(def, parentClass);
            this._classMap.put(name, qClass);
            this._lowerClassMap.put(name.toLowerCase(), qClass);
        }
    }

    private QuercusClass createClassFromCache(String name, boolean useAutoload, boolean useImport) {
        int id = this._quercus.getClassId(name);
        ClassDef classDef = this._classDef[id];
        if (classDef != null) {
            String parentName = classDef.getParentName();
            QuercusClass parent = null;
            if (parentName != null) {
                parent = this.findClass(parentName);
            }
            if (parentName == null || parent != null) {
                return this.createQuercusClass(classDef, parent);
            }
            return null;
        }
        ClassDef staticClass = this._quercus.findClass(name);
        if (staticClass != null) {
            return this.createQuercusClass(staticClass, null);
        }
        return null;
    }

    public void addAutoloadFunction(Callback fun) {
        if (fun == null) {
            throw new NullPointerException();
        }
        if (this._autoloadList == null) {
            this._autoloadList = new ArrayList();
        }
        this._autoloadList.add(fun);
    }

    public void removeAutoloadFunction(Callback fun) {
        if (this._autoloadList != null) {
            this._autoloadList.remove(fun);
            if (this._autoloadList.size() == 0) {
                this._autoloadList = null;
            }
        }
    }

    public ArrayList<Callback> getAutoloadFunctions() {
        return this._autoloadList;
    }

    public boolean importPhpClass(String name) {
        if (this._importMap == null) {
            return false;
        }
        String fullName = this._importMap.getQualifiedPhp(name);
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (fullName != null) {
            url = loader.getResource(fullName);
        } else {
            String entry;
            Iterator<String> i$ = this._importMap.getWildcardPhpList().iterator();
            while (i$.hasNext() && (url = loader.getResource((entry = i$.next()) + '/' + name + ".php")) == null) {
            }
        }
        if (url != null) {
            this.includeOnce(new StringBuilderValue(url.toString()));
            return true;
        }
        return false;
    }

    public Value getDeclaredClasses() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ClassDef> entry : this._quercus.getClassMap().entrySet()) {
            list.add(entry.getKey());
        }
        Collections.sort(list);
        ArrayValueImpl array = new ArrayValueImpl();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            array.put((String)iter.next());
        }
        return array;
    }

    public QuercusClass findAbstractClass(String name) {
        QuercusClass cl = this.findClass(name, true, true);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class name.", (Object)name));
    }

    public QuercusClass getClass(String name) {
        QuercusClass cl = this.findClass(name);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class.", (Object)name));
    }

    QuercusClass createQuercusClass(ClassDef def, QuercusClass parent) {
        ClassKey key = new ClassKey(def, parent);
        SoftReference qClassRef = (SoftReference)_classCache.get((Object)key);
        QuercusClass qClass = null;
        if (qClassRef != null && (qClass = (QuercusClass)qClassRef.get()) != null) {
            return new QuercusClass(qClass, parent);
        }
        qClass = new QuercusClass(this.getModuleContext(), def, parent);
        qClass.validate(this);
        _classCache.put((Object)key, new SoftReference<QuercusClass>(qClass));
        return qClass;
    }

    public boolean isInitializedClass(String name) {
        return this._initializedClassSet.contains(name);
    }

    public void addInitializedClass(String name) {
        this._initializedClassSet.add(name);
    }

    public AbstractFunction findFunction(String className, String methodName) {
        QuercusClass cl = this.findClass(className);
        if (cl == null) {
            throw new QuercusRuntimeException(L.l("'{0}' is an unknown class", (Object)className));
        }
        return cl.findFunction(methodName);
    }

    public Callback createCallback(Value value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if ((value = value.toValue()) instanceof Callback) {
            return (Callback)value;
        }
        if (value instanceof StringValue) {
            if (value.isEmpty()) {
                return null;
            }
            String s = value.toString();
            int p = s.indexOf("::");
            if (p < 0) {
                return new CallbackFunction(this, s);
            }
            String className = s.substring(0, p);
            String methodName = s.substring(p + 2);
            QuercusClass cl = this.findClass(className);
            if (cl == null) {
                throw new IllegalStateException(L.l("can't find class {0}", (Object)className));
            }
            return new CallbackFunction(cl.getFunction(methodName));
        }
        if (value instanceof ArrayValue) {
            Value obj = value.get(LongValue.ZERO);
            Value name = value.get(LongValue.ONE);
            if (!(name instanceof StringValue)) {
                throw new IllegalStateException(L.l("unknown callback name {0}", (Object)name));
            }
            if (obj instanceof StringValue) {
                QuercusClass cl = this.findClass(obj.toString());
                if (cl == null) {
                    throw new IllegalStateException(L.l("can't find class {0}", (Object)obj.toString()));
                }
                return new CallbackFunction(cl.getFunction(name.toString()));
            }
            return new CallbackObjectMethod(this, obj, name.toString());
        }
        return null;
    }

    public Value requireOnce(StringValue include) {
        return this.include(this.getSelfDirectory(), include, true, true);
    }

    public Value require(StringValue include) {
        return this.include(this.getSelfDirectory(), include, true, false);
    }

    public Value include(StringValue include) {
        return this.include(this.getSelfDirectory(), include, false, false);
    }

    public Value includeOnce(StringValue include) {
        return this.include(this.getSelfDirectory(), include, false, true);
    }

    public Value includeOnce(Path scriptPwd, StringValue include, boolean isRequire) {
        return this.include(scriptPwd, include, isRequire, true);
    }

    public Value include(Path scriptPwd, StringValue include, boolean isRequire, boolean isOnce) {
        try {
            Path pwd = this.getPwd();
            Path path = this.lookupInclude(include, pwd, scriptPwd);
            if (path == null) {
                if (isRequire) {
                    this.error(L.l("'{0}' is not a valid path", (Object)include));
                    return BooleanValue.FALSE;
                }
                this.warning(L.l("'{0}' is not a valid path", (Object)include));
                return BooleanValue.FALSE;
            }
            if (!this._isAllowUrlInclude && this.isUrl(path)) {
                String msg = L.l("not allowed to include url {0}", (Object)path.getURL());
                log.warning(this.dbgId() + msg);
                this.error(msg);
                return BooleanValue.FALSE;
            }
            QuercusPage page = this._includeMap.get(path);
            if (page != null && isOnce) {
                return BooleanValue.TRUE;
            }
            if (page == null || page.isModified()) {
                page = this._quercus.parse(path);
                page.init(this);
                page.importDefinitions(this);
                this._includeMap.put(path, page);
            }
            return page.execute(this);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private boolean isUrl(Path path) {
        String scheme = path.getScheme();
        if ("".equals(scheme) || "file".equals(scheme) || "memory".equals(scheme)) {
            return false;
        }
        return !"php".equals(scheme) || "php://input".equals(path.toString()) || path.toString().startsWith("php://filter");
    }

    public Path lookupPwd(Value relPathV) {
        if (!relPathV.isset()) {
            return null;
        }
        StringValue relPath = relPathV.toStringValue();
        if (relPath.length() == 0) {
            return null;
        }
        Path path = this._lookupCache.get(relPath);
        if (path == null) {
            path = this.getPwd().lookup(relPath.toString());
            this._lookupCache.put(relPath, path);
        }
        return path;
    }

    public Path lookup(StringValue relPath) {
        return this.lookupInclude(this.getSelfDirectory(), relPath.toString());
    }

    public Path lookupInclude(StringValue relPath) {
        return this.lookupInclude(relPath, this.getPwd(), this.getSelfDirectory());
    }

    private Path lookupInclude(StringValue include, Path pwd, Path scriptPwd) {
        String includePath = this.getDefaultIncludePath();
        Path path = this._quercus.getIncludeCache(include, includePath, pwd, scriptPwd);
        if (path == null && (path = this.lookupIncludeImpl(include, pwd, scriptPwd)) != null) {
            this._quercus.putIncludeCache(include, includePath, pwd, scriptPwd, path);
        }
        if (path == NullPath.NULL) {
            path = null;
        }
        this._includePath = includePath;
        this._includePathIniCount = this._iniCount;
        return path;
    }

    private String getDefaultIncludePath() {
        String includePath = this._includePath;
        if (this._includePathIniCount != this._iniCount) {
            includePath = Quercus.INI_INCLUDE_PATH.getAsString(this);
            this._includePath = null;
            this._includePathList = null;
        }
        if (includePath == null) {
            includePath = ".";
        }
        return includePath;
    }

    private Path lookupIncludeImpl(StringValue includeValue, Path pwd, Path scriptPwd) {
        String include = includeValue.toString();
        Path path = this.lookupInclude(pwd, include);
        if (path == null) {
            path = this.lookupInclude(scriptPwd, include);
        }
        if (path == null && !this.includeExists(path = scriptPwd.lookup(include))) {
            path = null;
        }
        return path;
    }

    private Path lookupInclude(Path pwd, String relPath) {
        ArrayList<Path> pathList = this.getIncludePath(pwd);
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i).lookup(relPath);
            if (!path.canRead() || path.isDirectory()) continue;
            return path;
        }
        return null;
    }

    private boolean includeExists(Path path) {
        if (path.canRead() && !path.isDirectory()) {
            return true;
        }
        if (!this.getQuercus().isRequireSource()) {
            return this.getQuercus().includeExists(path);
        }
        return false;
    }

    private ArrayList<Path> getIncludePath(Path pwd) {
        ArrayList<Object> pathList;
        String includePath = this.getDefaultIncludePath();
        if (this._includePathList == null) {
            String subpath;
            int tail;
            this._includePathList = new ArrayList();
            this._includePathMap = new HashMap();
            int head = 0;
            String pathSeparator = FileModule.PATH_SEPARATOR;
            int length = pathSeparator.length();
            while ((tail = includePath.indexOf(pathSeparator, head)) >= 0) {
                subpath = includePath.substring(head, tail);
                this._includePathList.add(subpath);
                head = tail + length;
            }
            subpath = includePath.substring(head);
            this._includePathList.add(subpath);
            this._includePath = includePath;
            this._includePathIniCount = this._iniCount;
        }
        if ((pathList = this._includePathMap.get(pwd)) == null) {
            pathList = new ArrayList();
            for (int i = 0; i < this._includePathList.size(); ++i) {
                pathList.add(pwd.lookup(this._includePathList.get(i)));
            }
            this._includePathMap.put(pwd, pathList);
        }
        return pathList;
    }

    public String setIncludePath(String path) {
        String prevIncludePath = Quercus.INI_INCLUDE_PATH.getAsString(this);
        if (this._defaultIncludePath == null) {
            this._defaultIncludePath = prevIncludePath;
        }
        Quercus.INI_INCLUDE_PATH.set(this, path);
        this._includePathIniCount = -1;
        return prevIncludePath;
    }

    public void restoreIncludePath() {
        Quercus.INI_INCLUDE_PATH.set(this, this._defaultIncludePath);
    }

    public ArrayValue getIncludedFiles() {
        ArrayValueImpl array = new ArrayValueImpl();
        ArrayList<String> list = new ArrayList<String>();
        for (Path path : this._includeMap.keySet()) {
            list.add(path.toString());
        }
        Collections.sort(list);
        for (String pathName : list) {
            ((ArrayValue)array).put(this.createString(pathName));
        }
        return array;
    }

    public Value suppress(int errorMask, Value value) {
        this.setErrorMask(errorMask);
        return value;
    }

    public Value exit(Value msg) {
        if (msg.isNull() || msg instanceof LongValue) {
            return this.exit();
        }
        try {
            this.getOut().print(msg.toString());
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusExitException(msg.toString());
    }

    public Value exit() {
        throw new QuercusExitException();
    }

    public Value die(String msg) {
        try {
            this.getOut().print(msg);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusDieException(msg);
    }

    public Value die() {
        throw new QuercusDieException();
    }

    public Value cast(Class cl, Value value) {
        if ((value = value.toValue()).isNull()) {
            return null;
        }
        if (cl.isAssignableFrom(value.getClass())) {
            return value;
        }
        this.warning(L.l("{0} ({1}) is not assignable to {2}", (Object)value, (Object)value.getClass().getName(), (Object)cl.getName()));
        return null;
    }

    public static Value first(Value value) {
        return value;
    }

    public static Value first(Value value, Value a1) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return value;
    }

    public void checkTypeHint(Value value, String type, String argName, String functionName) {
        if (value.isNull()) {
            this.error(L.l("'{0}' is an unexpected value for arg '{1}' in function '{2}', expected '{3}'", (Object)value, (Object)argName, (Object)functionName, (Object)type));
        }
    }

    public Value error(String msg) {
        return this.error(0, "", msg + this.getFunctionLocation());
    }

    public Value error(Location location, String msg) {
        return this.error(0, location, msg + this.getFunctionLocation());
    }

    public Value error(String loc, String msg) {
        return this.error(0, loc, msg + this.getFunctionLocation());
    }

    public Value error(String msg, Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(msg);
    }

    public Value error(Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(e.toString());
    }

    public QuercusRuntimeException createErrorException(String msg) throws QuercusRuntimeException {
        return this.createErrorException(null, msg);
    }

    public QuercusRuntimeException createErrorException(Location location, String msg) throws QuercusRuntimeException {
        if (location == null) {
            location = this.getLocation();
        }
        String prefix = location.getMessagePrefix();
        String fullMsg = msg + this.getFunctionLocation();
        this.error(0, location, fullMsg);
        String exMsg = prefix + fullMsg;
        return new QuercusRuntimeException(fullMsg);
    }

    public Value warning(String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, "", msg + this.getFunctionLocation());
    }

    public Value warning(Location location, String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, location, "", msg + this.getFunctionLocation());
    }

    public Value warning(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(msg);
    }

    public Value warning(Location location, String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(location, msg);
    }

    public Value warning(Throwable e) {
        return this.warning(e.toString(), e);
    }

    public Value warning(Location location, Throwable e) {
        return this.warning(location, e.toString(), e);
    }

    public Value strict(String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(11, "", msg + this.getFunctionLocation());
    }

    public Value invalidArgument(String name, Object value) {
        return this.warning(L.l("invalid value `{0}' for `{1}'", value, (Object)name));
    }

    public Value deprecatedArgument(String name) {
        return this.strict(L.l("argument `{1}' is deprecated", (Object)name));
    }

    public Value notice(String msg) {
        return this.error(3, "", msg + this.getFunctionLocation());
    }

    public Value notice(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.notice(msg);
    }

    public Value stub(String msg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getLocation().getMessagePrefix() + msg);
        }
        return NullValue.NULL;
    }

    public static Value nullAsFalse(Value value) {
        return value == null || value.isNull() ? BooleanValue.FALSE : value;
    }

    public Value parse(String msg) throws Exception {
        return this.error(2, "", msg);
    }

    public Value compileError(String msg) {
        return this.error(6, "", msg);
    }

    public Value compileWarning(String msg) {
        return this.error(7, "", msg);
    }

    public int getErrorMask() {
        return this._errorMask;
    }

    public int setErrorMask(int mask) {
        int oldMask = this._errorMask;
        this._errorMask = mask;
        return oldMask;
    }

    public void setErrorHandler(int mask, Callback fun) {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._prevErrorHandlers[i] = this._errorHandlers[i];
        }
        if ((mask & 1) != 0) {
            this._errorHandlers[0] = fun;
        }
        if ((mask & 2) != 0) {
            this._errorHandlers[1] = fun;
        }
        if ((mask & 4) != 0) {
            this._errorHandlers[2] = fun;
        }
        if ((mask & 8) != 0) {
            this._errorHandlers[3] = fun;
        }
        if ((mask & 0x100) != 0) {
            this._errorHandlers[8] = fun;
        }
        if ((mask & 0x200) != 0) {
            this._errorHandlers[9] = fun;
        }
        if ((mask & 0x400) != 0) {
            this._errorHandlers[10] = fun;
        }
        if ((mask & 0x800) != 0) {
            this._errorHandlers[11] = fun;
        }
        if ((mask & 0x1000) != 0) {
            this._errorHandlers[12] = fun;
        }
    }

    public void restoreErrorHandler() {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._errorHandlers[i] = this._prevErrorHandlers[i];
        }
    }

    public Callback getExceptionHandler() {
        return this._exceptionHandler;
    }

    public Value setExceptionHandler(Callback fun) {
        this._prevExceptionHandler = this._exceptionHandler;
        this._exceptionHandler = fun;
        if (this._prevExceptionHandler != null) {
            return this._prevExceptionHandler.toStringValue();
        }
        return NullValue.NULL;
    }

    public void restoreExceptionHandler() {
        this._exceptionHandler = this._prevExceptionHandler;
    }

    public Value error(int code, String locString, String msg) {
        return this.error(code, null, locString, msg);
    }

    public Value error(int code, Location location, String msg) {
        return this.error(code, location, "", msg);
    }

    public Value error(int code, Location location, String loc, String msg) {
        int mask = 1 << code;
        if (log.isLoggable(Level.FINEST)) {
            QuercusException e = new QuercusException(loc + msg);
            log.log(Level.FINEST, e.toString(), e);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(this + " " + loc + msg);
        }
        if (code >= 0 && code < this._errorHandlers.length && this._errorHandlers[code] != null) {
            Callback handler = this._errorHandlers[code];
            try {
                String fileName;
                this._errorHandlers[code] = null;
                Value fileNameV = NullValue.NULL;
                if (location == null) {
                    location = this.getLocation();
                }
                if ((fileName = location.getFileName()) != null) {
                    fileNameV = this.createString(fileName);
                }
                Value lineV = NullValue.NULL;
                int line = location.getLineNumber();
                if (line > 0) {
                    lineV = new LongValue(line);
                }
                NullValue context = NullValue.NULL;
                handler.call(this, new LongValue(mask), (Value)this.createString(msg), fileNameV, lineV, (Value)context);
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                this._errorHandlers[code] = handler;
            }
        }
        if ((this._errorMask & mask) != 0) {
            try {
                String fullMsg = this.getLocationPrefix(location, loc) + this.getCodeName(mask) + msg;
                if (this.getIniBoolean("track_errors")) {
                    this.setGlobalValue("php_errormsg", this.createString(fullMsg));
                }
                if ("stderr".equals(this.getIniString("display_errors"))) {
                    System.err.println(fullMsg);
                } else if (this.getIniBoolean("display_errors")) {
                    this.getOut().println(fullMsg);
                }
                if (this.getIniBoolean("log_errors")) {
                    log.info(fullMsg);
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if ((mask & 0x151) != 0) {
            String locPrefix = this.getLocationPrefix(location, loc);
            if (!"".equals(locPrefix)) {
                throw new QuercusErrorException(locPrefix + this.getCodeName(mask) + msg);
            }
            throw new QuercusErrorException(msg);
        }
        return NullValue.NULL;
    }

    private String getLocationPrefix(Location location, String loc) {
        if (loc != null && !"".equals(loc)) {
            return loc;
        }
        if (location == null) {
            location = this.getLocation();
        }
        return location.getMessagePrefix();
    }

    private String getCodeName(int code) {
        switch (code) {
            case 1: {
                return "Fatal Error: ";
            }
            case 2: {
                return "Warning: ";
            }
            case 4: {
                return "Parse Error: ";
            }
            case 8: {
                return "Notice: ";
            }
            case 16: {
                return "Fatal Error: ";
            }
            case 32: {
                return "Warning: ";
            }
            case 64: {
                return "Fatal Error: ";
            }
            case 128: {
                return "Warning : ";
            }
            case 256: {
                return "Fatal Error: ";
            }
            case 512: {
                return "Warning: ";
            }
            case 1024: {
                return "Notice: ";
            }
            case 2048: {
                return "Notice: ";
            }
            case 4096: {
                return "Error: ";
            }
        }
        return String.valueOf("ErrorCode(" + code + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSourceLine(Path path, int sourceLine, int length) {
        if (path == null) {
            return null;
        }
        if (path instanceof NullPath) {
            return null;
        }
        ReadStream is = null;
        try {
            int ch;
            is = path.openRead();
            boolean hasCr = false;
            int line = 1;
            while (line < sourceLine) {
                ch = is.read();
                if (ch < 0) {
                    String[] stringArray = null;
                    return stringArray;
                }
                if (ch == 13) {
                    hasCr = true;
                    ++line;
                    continue;
                }
                if (ch == 10) {
                    if (!hasCr) {
                        ++line;
                    }
                    hasCr = false;
                    continue;
                }
                hasCr = false;
            }
            String[] result = new String[length];
            int i = 0;
            StringBuilder sb = new StringBuilder();
            while (i < length && (ch = is.read()) > 0) {
                if (ch == 10 && hasCr) {
                    hasCr = false;
                    continue;
                }
                if (ch == 13) {
                    hasCr = true;
                    result[i++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                if (ch == 10) {
                    hasCr = false;
                    result[i++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                hasCr = false;
                sb.append((char)ch);
            }
            if (i < length) {
                result[i] = sb.toString();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return null;
    }

    public Location getLocation() {
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getLocation();
        }
        return Location.UNKNOWN;
    }

    public int getSourceLine(String className, int javaLine) {
        return javaLine;
    }

    public String getFunctionLocation() {
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getFunctionLocation();
        }
        return "";
    }

    public static Value toValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static Value toValue(long value) {
        return new LongValue(value);
    }

    public static Var toVar(Value value) {
        if (value instanceof Var) {
            return (Var)value;
        }
        if (value == null) {
            return new Var();
        }
        return new Var(value);
    }

    public static Value setFieldVar(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        if (oldValue instanceof Var) {
            return new Var(value);
        }
        return value;
    }

    public static Value setRef(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        return new Var(value);
    }

    public static Value comma(Value a0, Value a1) {
        return a1;
    }

    public static Value comma(Value a0, Value a1, Value a2) {
        return a2;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3) {
        return a3;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3, Value a4) {
        return a4;
    }

    public String toString() {
        return "Env[]";
    }

    public Value ifNull(Value condition, Value ifNull, Value ifNotNull) {
        return condition.isNull() ? ifNull : ifNotNull;
    }

    public LocaleInfo getLocaleInfo() {
        if (this._locale == null) {
            this._locale = new LocaleInfo();
        }
        return this._locale;
    }

    public void addShutdown(Callback callback, Value[] args) {
        this._shutdownList.add(new Shutdown(callback, args));
    }

    public void setGzStream(Object obj) {
        this._gzStream = obj;
    }

    public Object getGzStream() {
        return this._gzStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            while (this._outputBuffer != null) {
                this.popOutputBuffer();
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        int i;
        int i2;
        for (i2 = this._objCleanupList.size() - 1; i2 >= 0; --i2) {
            ObjectExtValue objCleanup = this._objCleanupList.get(i2);
            try {
                if (objCleanup == null) continue;
                objCleanup.cleanup(this);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        try {
            for (i2 = 0; i2 < this._shutdownList.size(); ++i2) {
                this._shutdownList.get(i2).call(this);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            this.sessionWriteClose();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        ArrayList<EnvCleanup> cleanupList = new ArrayList<EnvCleanup>(this._cleanupList);
        for (i = cleanupList.size() - 1; i >= 0; --i) {
            EnvCleanup envCleanup = cleanupList.get(i);
            try {
                if (envCleanup == null) continue;
                envCleanup.cleanup();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        _threadEnv.set(this._oldThreadEnv);
        for (i = 0; this._removePaths != null && i < this._removePaths.size(); ++i) {
            Path path = this._removePaths.get(i);
            try {
                path.remove();
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        AbstractFunction[] fun = this._fun;
        this._fun = null;
        if (fun != null) {
            for (int i3 = 0; i3 < fun.length; ++i3) {
                fun[i3] = null;
            }
            _freeFunList.free((Object)fun);
        }
        ClassDef[] classDef = this._classDef;
        this._classDef = null;
        if (classDef != null) {
            for (int i4 = 0; i4 < classDef.length; ++i4) {
                classDef[i4] = null;
            }
            _freeClassDefList.free((Object)classDef);
        }
        QuercusClass[] qClass = this._qClass;
        this._qClass = null;
        if (qClass != null) {
            for (int i5 = 0; i5 < qClass.length; ++i5) {
                qClass[i5] = null;
            }
            _freeClassList.free((Object)qClass);
        }
    }

    public void sessionWriteClose() {
        SessionArrayValue session = this._session;
        this._session = null;
        if (session != null) {
            SessionCallback callback = this.getSessionCallback();
            if (callback != null) {
                String value = session.getSize() > 0 ? VariableModule.serialize(this, session.getArray()) : "";
                callback.write(this, session.getId(), value);
                callback.close(this);
            } else {
                this._quercus.saveSession(this, session);
                Value sessionCopy = session.copy(this);
                this.setGlobalValue("_SESSION", sessionCopy);
                this.setGlobalValue("HTTP_SESSION_VARS", sessionCopy);
            }
        }
    }

    public String dbgId() {
        return "Quercus[" + this._selfPath + "] ";
    }

    static {
        SPECIAL_VARS.put((Object)"GLOBALS", 5);
        SPECIAL_VARS.put((Object)"_SERVER", 1);
        SPECIAL_VARS.put((Object)"_GET", 2);
        SPECIAL_VARS.put((Object)"_POST", 3);
        SPECIAL_VARS.put((Object)"_FILES", 12);
        SPECIAL_VARS.put((Object)"_REQUEST", 6);
        SPECIAL_VARS.put((Object)"_COOKIE", 4);
        SPECIAL_VARS.put((Object)"_SESSION", 7);
        SPECIAL_VARS.put((Object)"_ENV", 14);
        SPECIAL_VARS.put((Object)"HTTP_GET_VARS", 8);
        SPECIAL_VARS.put((Object)"HTTP_POST_VARS", 9);
        SPECIAL_VARS.put((Object)"HTTP_POST_FILES", 13);
        SPECIAL_VARS.put((Object)"HTTP_COOKIE_VARS", 10);
        SPECIAL_VARS.put((Object)"HTTP_SERVER_VARS", 15);
        SPECIAL_VARS.put((Object)"PHP_SELF", 11);
        SPECIAL_VARS.put((Object)"HTTP_RAW_POST_DATA", 16);
    }

    static class ClassKey {
        private final WeakReference<ClassDef> _defRef;
        private final WeakReference<QuercusClass> _parentRef;
        private final int _hash;

        ClassKey(ClassDef def, QuercusClass parent) {
            this._defRef = new WeakReference<ClassDef>(def);
            this._parentRef = parent != null ? new WeakReference<QuercusClass>(parent) : null;
            int hash = 37;
            if (def != null) {
                hash = 65521 * hash + def.hashCode();
            }
            if (parent != null) {
                hash = 65521 * hash + parent.hashCode();
            }
            this._hash = hash;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            ClassDef bDef;
            ClassKey key = (ClassKey)o;
            ClassDef aDef = (ClassDef)this._defRef.get();
            if (aDef != (bDef = (ClassDef)key._defRef.get())) {
                return false;
            }
            if (this._parentRef == key._parentRef) {
                return true;
            }
            if (this._parentRef == null || key._parentRef == null) {
                return false;
            }
            QuercusClass aParent = (QuercusClass)this._parentRef.get();
            QuercusClass bParent = (QuercusClass)key._parentRef.get();
            return aParent != null && aParent.equals(bParent);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._defRef.get() + "," + (this._parentRef != null ? (QuercusClass)this._parentRef.get() : null) + "]";
        }
    }

    static class FieldGetEntry {
        private final String _className;
        private final StringValue _fieldName;

        FieldGetEntry(String className, StringValue fieldName) {
            this._className = className;
            this._fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldGetEntry)) {
                return false;
            }
            FieldGetEntry entry = (FieldGetEntry)o;
            return entry._className.equals(this._className) && entry._fieldName.equals(this._fieldName);
        }
    }
}

