/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputBuffer {
    public static final int PHP_OUTPUT_HANDLER_START = 0;
    public static final int PHP_OUTPUT_HANDLER_CONT = 1;
    public static final int PHP_OUTPUT_HANDLER_END = 2;
    private static final Logger log = Logger.getLogger(OutputBuffer.class.getName());
    private int _state;
    private boolean _haveFlushed;
    private Callback _callback;
    private final boolean _erase;
    private final int _chunkSize;
    private final int _level;
    private final OutputBuffer _next;
    private TempStream _tempStream;
    private WriteStream _out;
    private final Env _env;

    OutputBuffer(OutputBuffer next, Env env, Callback callback, int chunkSize, boolean erase) {
        block6: {
            this._next = next;
            this._level = this._next != null ? this._next._level + 1 : 1;
            this._erase = erase;
            this._chunkSize = chunkSize;
            this._env = env;
            this._callback = callback;
            this._tempStream = new TempStream();
            this._out = new WriteStream((StreamImpl)this._tempStream);
            this._out.setNewlineString("\n");
            String encoding = env.getOutputEncoding();
            if (encoding != null) {
                try {
                    this._out.setEncoding(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    try {
                        this._out.setEncoding("UTF-8");
                    }
                    catch (UnsupportedEncodingException e2) {
                        if (!log.isLoggable(Level.WARNING)) break block6;
                        log.log(Level.WARNING, e.toString(), e2);
                    }
                }
            }
        }
        this._state = 1;
        this._haveFlushed = false;
    }

    public OutputBuffer getNext() {
        return this._next;
    }

    public WriteStream getOut() {
        return this._out;
    }

    public Value getContents() {
        try {
            this._out.flush();
            StringValue bb = this._env.createBinaryBuilder();
            for (TempBuffer ptr = this._tempStream.getHead(); ptr != null; ptr = ptr.getNext()) {
                bb.append(ptr.getBuffer(), 0, ptr.getLength());
            }
            return bb;
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public long getLength() {
        try {
            this._out.flush();
            return this._tempStream.getLength();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
            return -1L;
        }
    }

    public int getLevel() {
        return this._level;
    }

    public boolean haveFlushed() {
        return this._haveFlushed;
    }

    public boolean getEraseFlag() {
        return this._erase;
    }

    public int getChunkSize() {
        return this._chunkSize;
    }

    public void clean() {
        try {
            this._out.flush();
            this._tempStream.clearWrite();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
        }
    }

    public void flush() {
        this._state |= 2;
        if (!this.callCallback()) {
            this.doFlush();
        }
        this._state &= 0xFFFFFFFE;
        this._state &= 0xFFFFFFFD;
        this._haveFlushed = true;
    }

    public void close() {
        this._state |= 4;
        if (!this.callCallback()) {
            this._state = 0;
            this.doFlush();
        }
        WriteStream out = this._out;
        this._out = null;
        TempStream tempStream = this._tempStream;
        this._tempStream = null;
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (tempStream != null) {
            tempStream.destroy();
        }
    }

    private boolean callCallback() {
        if (this._callback == null || !this._callback.isValid()) {
            return false;
        }
        Value result = this._callback.call(this._env, this.getContents(), LongValue.create(this._state));
        if (result.toValue() != BooleanValue.FALSE) {
            this.clean();
            result.print(this._env, this.getNextOut());
            return true;
        }
        return false;
    }

    private void doFlush() {
        try {
            this._out.flush();
            WriteStream out = this.getNextOut();
            this._tempStream.writeToStream((OutputStream)out);
            this._tempStream.clearWrite();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
        }
    }

    private WriteStream getNextOut() {
        if (this._next != null) {
            return this._next.getOut();
        }
        return this._env.getOriginalOut();
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void setCallback(Callback callback) {
        this._callback = callback;
    }
}

