/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFunExpr
extends Expr {
    protected final Expr[] _keys;
    protected final Expr[] _values;

    public ArrayFunExpr(Location location, ArrayList<Expr> keyList, ArrayList<Expr> valueList) {
        super(location);
        this._keys = new Expr[keyList.size()];
        keyList.toArray(this._keys);
        this._values = new Expr[valueList.size()];
        valueList.toArray(this._values);
    }

    public ArrayFunExpr(Location location, Expr[] keys, Expr[] values) {
        super(location);
        this._keys = keys;
        this._values = values;
    }

    public ArrayFunExpr(ArrayList<Expr> keyList, ArrayList<Expr> valueList) {
        this(Location.UNKNOWN, keyList, valueList);
    }

    public ArrayFunExpr(Expr[] keys, Expr[] values) {
        this(Location.UNKNOWN, keys, values);
    }

    @Override
    public boolean isConstant() {
        int i;
        for (i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] == null || this._keys[i].isLiteral()) continue;
            return false;
        }
        for (i = 0; i < this._values.length; ++i) {
            if (this._values[i] == null || this._values[i].isLiteral()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value eval(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (int i = 0; i < this._values.length; ++i) {
            Expr keyExpr = this._keys[i];
            Value value = this._values[i].evalArg(env);
            value = value.toArgValue();
            if (keyExpr != null) {
                Value key = keyExpr.evalArg(env).toArgValue();
                array.put(key, value);
                continue;
            }
            ((ArrayValue)array).put(value);
        }
        return array;
    }

    @Override
    public String toString() {
        return "array()";
    }
}

