/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.UnaryExpr;

public class PreIncrementExpr
extends UnaryExpr {
    protected final int _incr;

    public PreIncrementExpr(Location location, Expr expr, int incr) {
        super(location, expr);
        this._incr = incr;
    }

    public PreIncrementExpr(Expr expr, int incr) {
        super(expr);
        this._incr = incr;
    }

    public Value eval(Env env) {
        Value var = this._expr.evalRef(env);
        return var.preincr(this._incr);
    }

    public boolean isDouble() {
        return this._expr.isDouble();
    }

    public boolean isLong() {
        return this._expr.isLong();
    }

    public boolean isNumber() {
        return true;
    }

    public String toString() {
        if (this._incr > 0) {
            return "++" + this._expr;
        }
        return "--" + this._expr;
    }
}

