/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class StaticFieldVarGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(StaticFieldVarGetExpr.class);
    protected final String _className;
    protected final Expr _varName;

    public StaticFieldVarGetExpr(Location location, String className, Expr varName) {
        super(location);
        this._className = className;
        this._varName = varName;
    }

    public StaticFieldVarGetExpr(String className, Expr varName) {
        this._className = className;
        this._varName = varName;
    }

    public Value eval(Env env) {
        return env.getStaticClassFieldValue(this._className, this._varName.evalString(env));
    }

    public Value evalCopy(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName.evalString(env)).copy();
    }

    public Value evalArg(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName.evalString(env));
    }

    public Value evalArray(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName.evalString(env)).getArray();
    }

    public Value evalObject(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName.evalString(env)).getObject(env);
    }

    public Value evalRef(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName.evalString(env));
    }

    public void evalAssign(Env env, Value value) {
        env.getStaticClassFieldVar(this._className, this._varName.evalString(env)).set(value);
    }

    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)this._className, (Object)this._varName));
    }

    public String toString() {
        return this._className + "::$" + this._varName;
    }
}

