/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.UnserializeCacheEntry;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class ApcModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(ApcModule.class.getName());
    private static final L10N L = new L10N(ApcModule.class);
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    private static final int _defaultSize = 4096;
    private LruCache<String, Entry> _cache;
    private HashMap<String, Value> _constMap = new HashMap();
    static final IniDefinition INI_APC_ENABLED = _iniDefinitions.add("apc.enabled", true, 7);
    static final IniDefinition INI_APC_SHM_SEGMENTS = _iniDefinitions.add("apc.shm_segments", 1L, 4);
    static final IniDefinition INI_APC_SHM_SIZE = _iniDefinitions.add("apc.shm_size", 30L, 4);
    static final IniDefinition INI_APC_OPTIMIZATION = _iniDefinitions.add("apc.optimization", false, 7);
    static final IniDefinition INI_APC_NUM_FILES_HINT = _iniDefinitions.add("apc.num_files_hint", 1000L, 4);
    static final IniDefinition INI_APC_USER_ENTRIES_HINT = _iniDefinitions.add("apc.user_entries_hint", 4096L, 4);
    static final IniDefinition INI_APC_TTL = _iniDefinitions.add("apc.ttl", 0L, 4);
    static final IniDefinition INI_APC_USER_TTL = _iniDefinitions.add("apc.user_ttl", 0L, 4);
    static final IniDefinition INI_APC_GC_TTL = _iniDefinitions.add("apc.gc_ttl", "3600", 4);
    static final IniDefinition INI_APC_CACHE_BY_DEFAULT = _iniDefinitions.add("apc.cache_by_default", true, 4);
    static final IniDefinition INI_APC_FILTERS = _iniDefinitions.add("apc.filters", "", 4);
    static final IniDefinition INI_APC_MMAP_FILE_MASK = _iniDefinitions.add("apc.mmap_file_mask", "", 4);
    static final IniDefinition INI_APC_SLAM_DEFENSE = _iniDefinitions.add("apc.slam_defense", false, 4);
    static final IniDefinition INI_APC_FILE_UPDATE_PROTECTION = _iniDefinitions.add("apc.file_update_protection", "2", 4);
    static final IniDefinition INI_APC_ENABLE_CLI = _iniDefinitions.add("apc.enable_cli", false, 4);
    static final IniDefinition INI_APC_MAX_FILE_SIZE = _iniDefinitions.add("apc.max_file_size", "1M", 4);
    static final IniDefinition INI_APC_STAT = _iniDefinitions.add("apc.stat", "1", 4);
    static final IniDefinition INI_APC_WRITE_LOCK = _iniDefinitions.add("apc.write_lock", "1", 4);
    static final IniDefinition INI_APC_LOCALCACHE = _iniDefinitions.add("apc.localcache", "0", 4);
    static final IniDefinition INI_APC_LOCALCACHE_SIZE = _iniDefinitions.add("apc.localcache.size", "4096", 4);

    public String[] getLoadedExtensions() {
        return new String[]{"apc"};
    }

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value apc_cache_info(Env env, @Optional String type, @Optional boolean limited) {
        ArrayValueImpl value = new ArrayValueImpl();
        if (this._cache != null) {
            value.put("num_slots", this._cache.getCapacity());
            value.put("ttl", 0L);
            value.put("num_hits", this._cache.getHitCount());
            value.put("num_misses", this._cache.getMissCount());
            value.put("start_time", 0L);
        } else {
            value.put("num_slots", 0L);
            value.put("ttl", 0L);
            value.put("num_hits", 0L);
            value.put("num_misses", 0L);
            value.put("start_time", 0L);
        }
        ArrayValueImpl cacheList = new ArrayValueImpl();
        value.put(env.createString("cache_list"), cacheList);
        if ("user".equals(type) && this._cache != null && !limited) {
            ArrayList<Object> keys = new ArrayList<Object>();
            ArrayList<Object> values = new ArrayList<Object>();
            LruCache<String, Entry> lruCache = this._cache;
            synchronized (lruCache) {
                for (LruCache.Entry lruEntry : this._cache) {
                    keys.add(lruEntry.getKey());
                    values.add(lruEntry.getValue());
                }
            }
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                Entry entryValue = (Entry)values.get(i);
                if (!entryValue.isValid()) continue;
                ArrayValueImpl array = new ArrayValueImpl();
                cacheList.put(array);
                array.put(env.createString("info"), env.createString(key));
                array.put(env.createString("ttl"), LongValue.create(entryValue.getTTL()));
                array.put(env.createString("type"), env.createString("user"));
                array.put(env.createString("num_hits"), LongValue.create(entryValue.getHitCount()));
            }
        }
        return value;
    }

    public boolean apc_clear_cache(Env env, @Optional String type) {
        if (this._cache != null) {
            this._cache.clear();
        }
        return true;
    }

    public boolean apc_define_constants(Env env, String key, ArrayValue values, @Optional(value="true") boolean caseSensitive) {
        this._constMap.put(key, values.copy(env));
        return true;
    }

    public boolean apc_delete(Env env, String key) {
        if (this._cache == null) {
            return false;
        }
        return this._cache.remove((Object)key) != null;
    }

    public Value apc_fetch(Env env, String key) {
        if (this._cache == null) {
            return BooleanValue.FALSE;
        }
        Entry entry = (Entry)this._cache.get((Object)key);
        if (entry == null) {
            return BooleanValue.FALSE;
        }
        Value value = entry.getValue(env);
        if (value != null) {
            ApcModule.initObject(env, value);
        }
        if (value != null) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    private static void initObject(Env env, Value value) {
        if (value.isObject()) {
            ObjectValue obj = (ObjectValue)value.toValue().toObject(env);
            String className = obj.isIncompleteObject() ? obj.getIncompleteObjectName() : obj.getName();
            QuercusClass cls = env.findClass(className);
            if (cls != null) {
                obj.setIncompleteObjectName(null);
                obj.initObject(env, cls);
            }
        } else if (value.isArray()) {
            Iterator<Value> iter = value.getValueIterator(env);
            while (iter.hasNext()) {
                ApcModule.initObject(env, iter.next());
            }
        }
    }

    public boolean apc_load_constants(Env env, String key, @Optional(value="true") boolean caseSensitive) {
        ArrayValue array = (ArrayValue)this._constMap.get(key);
        if (array == null) {
            return false;
        }
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            env.addConstant(entry.getKey().toString(), entry.getValue().copy(env), !caseSensitive);
        }
        return true;
    }

    public Value apc_sma_info(Env env, @Optional String type) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.put("num_seg", 1L);
        value.put("seg_size", 0x100000L);
        value.put("avail_mem", 0x100000L);
        value.put(env.createString("block_lists"), new ArrayValueImpl());
        return value;
    }

    public Value apc_store(Env env, String key, Value value, @Optional(value="0") int ttl) {
        if (this._cache == null) {
            long size = env.getIniLong("apc.user_entries_hint");
            if (size <= 0L) {
                size = 4096L;
            }
            this._cache = new LruCache((int)size);
        }
        this._cache.put((Object)key, (Object)new Entry(env, value, ttl));
        return BooleanValue.TRUE;
    }

    static class Entry
    extends UnserializeCacheEntry {
        private long _createTime;
        private long _accessTime;
        private long _expire;
        private int _hitCount;

        Entry(Env env, Value value, int ttl) {
            super(env, value);
            this._expire = ttl <= 0 ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + (long)ttl * 1000L;
            this._createTime = Alarm.getCurrentTime();
        }

        public long getTTL() {
            if (this._expire >= 0x3FFFFFFFFFFFFFFFL) {
                return 0L;
            }
            return (this._expire - Alarm.getCurrentTime()) / 1000L;
        }

        public long getHitCount() {
            return this._hitCount;
        }

        public boolean isValid() {
            if (Alarm.getCurrentTime() <= this._expire) {
                return true;
            }
            this.clear();
            return false;
        }

        public Value getValue(Env env) {
            if (Alarm.getCurrentTime() <= this._expire) {
                this._accessTime = Alarm.getCurrentTime();
                ++this._hitCount;
                return super.getValue(env);
            }
            return null;
        }
    }
}

