/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.Location;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ErrorModule;

@ClassImplementation
public class ExceptionClass {
    private static final StringValue MESSAGE = new StringBuilderValue("message");
    private static final StringValue FILE = new StringBuilderValue("file");
    private static final StringValue LINE = new StringBuilderValue("line");
    private static final StringValue CODE = new StringBuilderValue("code");
    private static final StringValue TRACE = new StringBuilderValue("trace");

    public static Value __construct(Env env, @This ObjectValue value, @Optional StringValue message, @Optional(value="0") int code) {
        value.putField(env, "message", (Value)message);
        value.putField(env, "code", (Value)LongValue.create(code));
        Location location = env.getLocation();
        if (location != null) {
            if (location.getFileName() != null) {
                value.putField(env, "file", (Value)env.createString(location.getFileName()));
            } else {
                value.putField(env, "file", (Value)env.createString("unknown"));
            }
            value.putField(env, "line", (Value)new LongValue(location.getLineNumber()));
        }
        value.putField(env, "trace", ErrorModule.debug_backtrace(env));
        return value;
    }

    public static Value __toString(Env env, @This ObjectValue value) {
        StringValue sb = env.createUnicodeBuilder();
        sb.append("ExceptionClass[" + value.getName() + "]\n");
        sb.append(ExceptionClass.getMessage(env, value));
        sb.append("\n");
        sb.append(ExceptionClass.getTraceAsString(env, value));
        sb.append("\n");
        return sb;
    }

    public static Value getMessage(Env env, @This ObjectValue obj) {
        return obj.getField(env, MESSAGE);
    }

    public static Value getCode(Env env, @This ObjectValue obj) {
        return obj.getField(env, CODE);
    }

    public static Value getFile(Env env, @This ObjectValue obj) {
        return obj.getField(env, FILE);
    }

    public static Value getLine(Env env, @This ObjectValue obj) {
        return obj.getField(env, LINE);
    }

    public static Value getTrace(Env env, @This ObjectValue obj) {
        return obj.getField(env, TRACE);
    }

    public static Value getTraceAsString(Env env, @This ObjectValue obj) {
        return env.createString("<trace>");
    }
}

