/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.config.ConfigException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MhashModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(MhashModule.class);
    private static final Logger log = Logger.getLogger(MhashModule.class.getName());
    public static final int MHASH_CRC32 = 0;
    public static final int MHASH_MD5 = 1;
    public static final int MHASH_SHA1 = 2;
    public static final int MHASH_HAVAL256 = 3;
    public static final int MHASH_RIPEMD160 = 5;
    public static final int MHASH_TIGER = 7;
    public static final int MHASH_GOST = 8;
    public static final int MHASH_CRC32B = 9;
    public static final int MHASH_HAVAL224 = 10;
    public static final int MHASH_HAVAL192 = 11;
    public static final int MHASH_HAVAL160 = 12;
    public static final int MHASH_HAVAL128 = 13;
    public static final int MHASH_TIGER128 = 14;
    public static final int MHASH_TIGER160 = 15;
    public static final int MHASH_MD4 = 16;
    public static final int MHASH_SHA256 = 17;
    public static final int MHASH_ADLER32 = 18;
    public static final int MHASH_SHA224 = 19;
    public static final int MHASH_SHA512 = 20;
    public static final int MHASH_SHA384 = 21;
    public static final int MHASH_WHIRLPOOL = 22;
    public static final int MHASH_RIPEMD128 = 23;
    public static final int MHASH_RIPEMD256 = 24;
    public static final int MHASH_RIPEMD320 = 25;
    public static final int MHASH_SNEFRU128 = 26;
    public static final int MHASH_SNEFRU256 = 27;
    public static final int MHASH_MD2 = 28;
    private HashMap<Integer, MhashAlgorithm> _algorithmMap = new HashMap();
    private int _highestOrdinal;

    public MhashModule() {
        this.addAlgorithm(0, "CRC32", "CRC32");
        this.addAlgorithm(1, "MD5", "MD5");
        this.addAlgorithm(2, "SHA1", "SHA-1");
        this.addAlgorithm(3, "HAVAL256", "HAVAL-256");
        this.addAlgorithm(5, "RIPEMD160", "RIPEMD-160");
        this.addAlgorithm(7, "TIGER", "TIGER");
        this.addAlgorithm(8, "GOST", "GOST");
        this.addAlgorithm(9, "CRC32B", "CRC32B");
        this.addAlgorithm(10, "HAVAL224", "HAVAL-224");
        this.addAlgorithm(11, "HAVAL192", "HAVAL-192");
        this.addAlgorithm(12, "HAVAL160", "HAVAL-160");
        this.addAlgorithm(13, "HAVAL128", "HAVAL-128");
        this.addAlgorithm(14, "TIGER128", "TIGER-128");
        this.addAlgorithm(15, "TIGER160", "TIGER-160");
        this.addAlgorithm(16, "MD4", "MD4");
        this.addAlgorithm(17, "SHA256", "SHA-256");
        this.addAlgorithm(18, "ADLER32", "ADLER-32");
        this.addAlgorithm(19, "SHA224", "SHA-224");
        this.addAlgorithm(20, "SHA512", "SHA-512");
        this.addAlgorithm(21, "SHA384", "SHA-384");
        this.addAlgorithm(22, "WHIRLPOOL", "WHIRLPOOL");
        this.addAlgorithm(23, "RIPEMD128", "RIPEMD-128");
        this.addAlgorithm(24, "RIPEMD256", "RIPEMD-256");
        this.addAlgorithm(25, "RIPEMD320", "RIPEMD-320");
        this.addAlgorithm(26, "SNEFRU128", "SNEFRU-128");
        this.addAlgorithm(27, "SNEFRU256", "SNEFRU-256");
        this.addAlgorithm(28, "MD2", "MD2");
    }

    public String[] getLoadedExtensions() {
        return new String[]{"mhash"};
    }

    private void addAlgorithm(int ordinal, String name, String javaName) {
        MhashAlgorithm algorithm = new MhashAlgorithm(name, javaName, null);
        this._algorithmMap.put(ordinal, algorithm);
        if (this._highestOrdinal < ordinal) {
            this._highestOrdinal = ordinal;
        }
    }

    public Value mhash(Env env, int hash, StringValue data, @Optional String key) {
        if (key.length() > 0) {
            throw new UnsupportedOperationException("key");
        }
        MhashAlgorithm algorithm = this._algorithmMap.get(hash);
        if (algorithm == null) {
            return BooleanValue.FALSE;
        }
        MessageDigest messageDigest = algorithm.createMessageDigest();
        if (messageDigest == null) {
            log.warning(L.l("no MessageDigest for {0}", (Object)algorithm));
            return BooleanValue.FALSE;
        }
        byte[] result = messageDigest.digest(data.toBytes());
        return env.createBinaryBuilder(result);
    }

    public int mhash_count() {
        return this._highestOrdinal;
    }

    public Value mhash_get_block_size(int hash) {
        MhashAlgorithm algorithm = this._algorithmMap.get(hash);
        if (algorithm == null || algorithm.createMessageDigest() == null) {
            return BooleanValue.FALSE;
        }
        return new LongValue(512L);
    }

    public Value mhash_get_hash_name(Env env, int hash) {
        MhashAlgorithm algorithm = this._algorithmMap.get(hash);
        if (algorithm == null) {
            return BooleanValue.FALSE;
        }
        return env.createString(algorithm.getName());
    }

    public static class MhashAlgorithm {
        private String _name;
        private String _javaName;
        private String _javaProvider;

        MhashAlgorithm(String name, String javaName, String javaProvider) {
            this._name = name;
            this._javaName = javaName;
            this._javaProvider = javaProvider;
        }

        public MhashAlgorithm() {
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setJavaName(String javaName) {
            this._javaName = javaName;
        }

        public String getJavaName() {
            return this._javaName;
        }

        public void setJavaProvider(String javaProvider) {
            this._javaProvider = javaProvider;
        }

        public String getJavaProvider() {
            return this._javaProvider;
        }

        public void init() throws ConfigException {
            if (this._name == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"name"));
            }
            if (this._javaName == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"java-name"));
            }
        }

        public MessageDigest createMessageDigest() {
            try {
                if (this._javaProvider != null) {
                    return MessageDigest.getInstance(this._javaName, this._javaProvider);
                }
                return MessageDigest.getInstance(this._javaName);
            }
            catch (NoSuchAlgorithmException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, ex.toString(), ex);
                }
                return null;
            }
            catch (NoSuchProviderException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, ex.toString(), ex);
                }
                return null;
            }
        }

        public String toString() {
            return "MhashAlgorithm[name=" + this._name + " java-name=" + this._javaName + " java-provider=" + this._javaProvider + "]";
        }
    }
}

