/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.lib.curl.Authentication;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;

public class HttpConnection {
    private HttpURLConnection _conn;
    private URL _URL;
    private String _username;
    private String _password;
    private URL _proxyURL;
    private String _proxyUsername;
    private String _proxyPassword;
    private String _proxyType;
    private int _responseCode;
    private boolean _hadSentAuthorization = false;
    private boolean _hadSentProxyAuthorization = false;
    private String _authorization;
    private String _proxyAuthorization;

    protected HttpConnection(URL url, String username, String password) throws IOException {
        this._URL = url;
        this._username = username;
        this._password = password;
    }

    public HttpConnection(URL url, String username, String password, URL proxyURL, String proxyUsername, String proxyPassword, String proxyType) throws IOException {
        this._URL = url;
        this._proxyURL = proxyURL;
        this._proxyType = proxyType;
        this._username = username;
        this._password = password;
        this._proxyUsername = proxyUsername;
        this._proxyPassword = proxyPassword;
    }

    protected void init(CurlResource curl) throws IOException {
        Proxy proxy = this.getProxy();
        this._conn = (HttpURLConnection)this._URL.openConnection(proxy);
    }

    public static final HttpConnection createConnection(URL url, String username, String password, CurlResource curl, URL proxyURL, String proxyUsername, String proxyPassword, String proxyType) throws IOException {
        HttpConnection conn;
        if (url.getProtocol().equals("https")) {
            HttpsConnection secureConn = new HttpsConnection(url, username, password);
            conn = secureConn;
        } else {
            conn = new HttpConnection(url, username, password);
        }
        conn._proxyURL = proxyURL;
        conn._proxyUsername = proxyUsername;
        conn._proxyPassword = proxyPassword;
        conn._proxyType = proxyType;
        conn.init(curl);
        return conn;
    }

    public static final HttpConnection createConnection(URL url, String username, String password, CurlResource curl) throws IOException {
        HttpConnection conn;
        if (url.getProtocol().equals("https")) {
            HttpsConnection secureConn = new HttpsConnection(url, username, password);
            conn = secureConn;
        } else {
            conn = new HttpConnection(url, username, password);
        }
        conn.init(curl);
        return conn;
    }

    public void setConnectTimeout(int time) {
        this._conn.setConnectTimeout(time);
    }

    public void setDoOutput(boolean doOutput) {
        this._conn.setDoOutput(doOutput);
    }

    public void setInstanceFollowRedirects(boolean isToFollowRedirects) {
        this._conn.setInstanceFollowRedirects(isToFollowRedirects);
    }

    public void setReadTimeout(int time) {
        this._conn.setReadTimeout(time);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this._conn.setRequestMethod(method);
    }

    public void setRequestProperty(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    protected final Proxy getProxy() {
        if (this._proxyURL == null) {
            return Proxy.NO_PROXY;
        }
        InetSocketAddress address = new InetSocketAddress(this._proxyURL.getHost(), this._proxyURL.getPort());
        return new Proxy(Proxy.Type.valueOf(this._proxyType), address);
    }

    protected final URL getURL() {
        return this._URL;
    }

    protected final HttpURLConnection getConnection() {
        return this._conn;
    }

    protected final void setConnection(HttpURLConnection conn) {
        this._conn = conn;
    }

    public void connect(CurlResource curl) throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        this.authenticate();
        this._conn.connect();
    }

    public void authenticate() throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        if (this._username != null || this._proxyUsername != null) {
            this.authenticateImpl();
        }
        if (this._proxyAuthorization != null) {
            this._conn.setRequestProperty("Proxy-Authorization", this._proxyAuthorization);
        }
        if (this._authorization != null) {
            this._conn.setRequestProperty("Authorization", this._authorization);
        }
    }

    public void authenticateImpl() throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        Proxy proxy = Proxy.NO_PROXY;
        if (this._proxyURL != null) {
            InetSocketAddress address = new InetSocketAddress(this._proxyURL.getHost(), this._proxyURL.getPort());
            proxy = new Proxy(Proxy.Type.valueOf(this._proxyType), address);
        }
        HttpURLConnection headConn = (HttpURLConnection)this._URL.openConnection(proxy);
        headConn.setRequestMethod("HEAD");
        if (this._proxyAuthorization != null) {
            headConn.setRequestProperty("Proxy-Authorization", this._proxyAuthorization);
        }
        if (this._authorization != null) {
            headConn.setRequestProperty("Authorization", this._authorization);
        }
        headConn.connect();
        int responseCode = headConn.getResponseCode();
        if (responseCode == 407 && this._proxyAuthorization == null) {
            String header = headConn.getHeaderField("Proxy-Authenticate");
            this._proxyAuthorization = this.getAuthorization(this._URL, this._conn.getRequestMethod(), header, "Proxy-Authorization", this._proxyUsername, this._proxyPassword);
            this.authenticateImpl();
        } else if (responseCode == 401 && this._authorization == null) {
            String header = headConn.getHeaderField("WWW-Authenticate");
            this._authorization = this.getAuthorization(this._URL, this._conn.getRequestMethod(), header, "Authorization", this._username, this._password);
            this.authenticateImpl();
        }
        headConn.disconnect();
    }

    private final String getAuthorization(URL url, String requestMethod, String header, String clientField, String username, String password) throws ConnectException, SocketTimeoutException, IOException {
        if (username == null || password == null) {
            return "";
        }
        String uri = url.getFile();
        if (uri.length() == 0) {
            uri = "/";
        }
        String auth = Authentication.getAuthorization(username, password, requestMethod, uri, header);
        return auth;
    }

    public int getContentLength() {
        return this._conn.getContentLength();
    }

    public InputStream getErrorStream() {
        return this._conn.getErrorStream();
    }

    public String getHeaderField(String key) {
        return this._conn.getHeaderField(key);
    }

    public String getHeaderField(int i) {
        return this._conn.getHeaderField(i);
    }

    public String getHeaderFieldKey(int i) {
        return this._conn.getHeaderFieldKey(i);
    }

    public InputStream getInputStream() throws IOException {
        return this._conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._conn.getOutputStream();
    }

    public int getResponseCode() {
        try {
            return this._conn.getResponseCode();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public void disconnect() {
        this.close();
    }

    public void close() {
        if (this._conn != null) {
            this._conn.disconnect();
        }
    }
}

