/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcStatementResource;
import com.caucho.quercus.lib.db.Postgres;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgresStatement
extends JdbcStatementResource {
    private static final Logger log = Logger.getLogger(PostgresStatement.class.getName());
    private static final L10N L = new L10N(PostgresStatement.class);
    private ArrayList<LongValue> _preparedMapping = new ArrayList();

    PostgresStatement(Postgres conn) {
        super(conn);
    }

    public boolean execute(Env env) {
        try {
            int size = this._preparedMapping.size();
            boolean matches = false;
            for (int i = 0; i < size; ++i) {
                LongValue param = this._preparedMapping.get(i);
                Value paramV = this.getParam(param.toInt() - 1);
                if (paramV.equals(UnsetValue.UNSET)) {
                    env.warning(L.l("Not all parameters are bound"));
                    return false;
                }
                Object object = paramV.toJavaObject();
                this.setObject(i + 1, object);
            }
            return this.executeStatement();
        }
        catch (Exception e) {
            env.warning(L.l(e.toString()));
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean prepare(Env env, StringValue query) {
        try {
            String queryStr = query.toString();
            this._preparedMapping.clear();
            Pattern pattern = Pattern.compile("\\$([0-9]+)");
            Matcher matcher = pattern.matcher(queryStr);
            while (matcher.find()) {
                int phpParam;
                try {
                    phpParam = Integer.parseInt(matcher.group(1));
                }
                catch (Exception ex) {
                    this._preparedMapping.clear();
                    return false;
                }
                this._preparedMapping.add(LongValue.create(phpParam));
            }
            queryStr = queryStr.replaceAll("\\$[0-9]+", "?");
            return super.prepare(env, env.createString(queryStr));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    protected int getPreparedMappingSize() {
        return this._preparedMapping.size();
    }
}

