/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.logging.Logger;

public class FileInput
extends ReadStreamInput
implements LockableStream,
EnvCleanup {
    private static final Logger log = Logger.getLogger(FileInput.class.getName());
    private Env _env;
    private Path _path;
    private ReadStream _is;

    public FileInput(Env env, Path path) throws IOException {
        super(env);
        this._env = env;
        env.addCleanup(this);
        this._path = path;
        this._is = path.openRead();
        this.init(this._is);
    }

    public Path getPath() {
        return this._path;
    }

    public BinaryInput openCopy() throws IOException {
        return new FileInput(this._env, this._path);
    }

    public long getLength() {
        return this.getPath().getLength();
    }

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                position = this.getLength() + offset;
                break;
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public boolean lock(boolean shared, boolean block) {
        return this._is.lock(shared, block);
    }

    public boolean unlock() {
        return this._is.unlock();
    }

    public Value stat() {
        return FileModule.statImpl(this._env, this.getPath());
    }

    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    public void cleanup() {
        super.close();
    }

    public String toString() {
        return "FileInput[" + this.getPath() + "]";
    }
}

