/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.file.FileValue;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReadValue
extends FileValue {
    private static final Logger log = Logger.getLogger(FileReadValue.class.getName());
    private ReadStream _is;
    private long _offset;

    public FileReadValue(Path path) throws IOException {
        super(path);
        this._is = path.openRead();
    }

    public long getLength() {
        return this.getPath().getLength();
    }

    public int read() throws IOException {
        if (this._is != null) {
            int v = this._is.read();
            if (v >= 0) {
                ++this._offset;
            } else {
                this.close();
            }
            return v;
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            int len = this._is.read(buffer, offset, length);
            if (len >= 0) {
                this._offset += (long)len;
            } else {
                this.close();
            }
            return len;
        }
        return -1;
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is != null) {
            int ch = this._is.read();
            if (ch == 10) {
                ++this._offset;
                return true;
            }
            this._is.unread();
            return false;
        }
        return false;
    }

    public void writeToStream(OutputStream os, int length) throws IOException {
        if (this._is != null) {
            this._is.writeToStream(os, length);
        }
    }

    public StringValue readLine(Env env) throws IOException {
        if (this._is != null) {
            return env.createString(this._is.readLineNoChop());
        }
        return null;
    }

    public boolean isEOF() {
        if (this._is == null) {
            return true;
        }
        try {
            return this._is.available() <= 0;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return true;
        }
    }

    public long getPosition() {
        if (this._is == null) {
            return -1L;
        }
        return this._is.getPosition();
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public String toString() {
        return "File[" + this.getPath() + "]";
    }
}

